/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker;

import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;

public class PossibleResourcesMarker {
    public static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    static final String NO_MATCH = "-nomatch-";
    private final ShrinkerDebugReporter debugReporter;
    private final ResourceStore resourceStore;
    private final Set<String> strings;
    private final boolean foundWebContent;

    public PossibleResourcesMarker(ShrinkerDebugReporter debugReporter, ResourceStore resourceStore, Set<String> strings, boolean foundWebContent) {
        this.debugReporter = debugReporter;
        this.resourceStore = resourceStore;
        this.strings = strings;
        this.foundWebContent = foundWebContent;
    }

    public void markPossibleResourcesReachable() {
        Set names = (Set)this.resourceStore.getResources().stream().map(resource -> resource.name).collect(ImmutableSet.toImmutableSet());
        int shortest = names.stream().mapToInt(String::length).min().orElse(Integer.MAX_VALUE);
        this.strings.stream().filter(string -> string.length() >= shortest).flatMap(string -> {
            int n = string.length();
            boolean justName = true;
            boolean formatting = false;
            boolean haveSlash = false;
            for (int i2 = 0; i2 < n; ++i2) {
                char c = string.charAt(i2);
                haveSlash |= c == '/';
                formatting |= c == '%';
                justName = justName && c != '.' && c != ':' && c != '%' && c != '/';
            }
            Stream reachable = Streams.concat((Stream[])new Stream[]{this.foundWebContent ? this.possibleWebResources(names, (String)string) : Stream.empty(), justName ? this.possiblePrefixMatch((String)string) : Stream.empty(), formatting && !haveSlash ? this.possibleFormatting((String)string) : Stream.empty(), haveSlash ? this.possibleTypedResource(names, (String)string) : Stream.empty(), this.possibleIntResource((String)string)});
            return reachable.peek(resource -> this.debugReporter.debug((Function0<String>)((Function0)() -> "Marking " + resource + " used because it matches string pool constant " + string)));
        }).forEach(ResourceUsageModel::markReachable);
    }

    private Stream<ResourceUsageModel.Resource> possibleWebResources(Set<String> names, String string) {
        int start;
        List resources = this.resourceStore.getResourcesFromWebUrl(string);
        if (!resources.isEmpty()) {
            return resources.stream();
        }
        int dot = string.indexOf(46, start = Math.max(string.lastIndexOf(47), 0));
        String name2 = string.substring(start, dot != -1 ? dot : string.length());
        if (names.contains(name2)) {
            return this.resourceStore.getResourceMaps().stream().filter(map2 -> map2.containsKey((Object)name2)).flatMap(map2 -> map2.get((Object)name2).stream());
        }
        return Stream.empty();
    }

    private Stream<ResourceUsageModel.Resource> possiblePrefixMatch(String string) {
        return this.resourceStore.getResources().stream().filter(resource -> resource.name.startsWith(string));
    }

    private Stream<ResourceUsageModel.Resource> possibleFormatting(String string) {
        try {
            Pattern pattern = Pattern.compile(PossibleResourcesMarker.convertFormatStringToRegexp(string));
            return this.resourceStore.getResources().stream().filter(resource -> pattern.matcher(resource.name).matches());
        }
        catch (PatternSyntaxException ignored) {
            return Stream.empty();
        }
    }

    private Stream<ResourceUsageModel.Resource> possibleTypedResource(Set<String> names, String string) {
        int slash = string.indexOf(47);
        String name2 = string.substring(slash + 1);
        if (name2.isEmpty() || !names.contains(name2)) {
            return Stream.empty();
        }
        if (slash > 0) {
            int colon = string.indexOf(58);
            String typeName = string.substring(colon + 1, slash);
            ResourceType type = ResourceType.fromClassName((String)typeName);
            return type != null ? this.resourceStore.getResources(type, name2).stream() : Stream.empty();
        }
        return this.resourceStore.getResourceMaps().stream().filter(map2 -> map2.containsKey((Object)name2)).flatMap(map2 -> map2.get((Object)name2).stream());
    }

    private Stream<ResourceUsageModel.Resource> possibleIntResource(String string) {
        String withoutSlash = string.substring(string.lastIndexOf(47) + 1);
        if (withoutSlash.isEmpty() || !Character.isDigit(withoutSlash.charAt(0))) {
            return Stream.empty();
        }
        Integer id = Ints.tryParse((String)withoutSlash);
        ResourceUsageModel.Resource resource = null;
        if (id != null) {
            resource = this.resourceStore.getResource(id.intValue());
        }
        return resource != null ? Stream.of(resource) : Stream.empty();
    }

    @VisibleForTesting
    static String convertFormatStringToRegexp(String formatString) {
        StringBuilder regexp = new StringBuilder();
        int from = 0;
        boolean hasEscapedLetters = false;
        Matcher matcher = FORMAT.matcher(formatString);
        int length = formatString.length();
        while (matcher.find(from)) {
            int start = matcher.start();
            int end = matcher.end();
            if (start == 0 && end == length) {
                return NO_MATCH;
            }
            if (start > from) {
                hasEscapedLetters |= PossibleResourcesMarker.appendEscapedPattern(formatString, regexp, from, start);
            }
            String pattern = ".*";
            String conversion = matcher.group(6);
            String timePrefix = matcher.group(5);
            if (timePrefix == null && conversion != null && conversion.length() == 1) {
                String width;
                char type = conversion.charAt(0);
                switch (type) {
                    case 'S': 
                    case 'T': 
                    case 's': 
                    case 't': {
                        break;
                    }
                    case '%': {
                        pattern = "%";
                        break;
                    }
                    case 'n': {
                        pattern = "\n";
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        pattern = ".";
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        pattern = "\\p{XDigit}+";
                        break;
                    }
                    case 'd': 
                    case 'o': {
                        pattern = "\\p{Digit}+";
                        break;
                    }
                    case 'b': {
                        pattern = "(true|false)";
                        break;
                    }
                    case 'B': {
                        pattern = "(TRUE|FALSE)";
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        pattern = "(null|\\p{XDigit}+)";
                        break;
                    }
                    case 'f': {
                        pattern = "-?[\\p{XDigit},.]+";
                        break;
                    }
                    case 'e': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+e\\+?\\p{Digit}+";
                        break;
                    }
                    case 'E': {
                        pattern = "-?\\p{Digit}+[,.]\\p{Digit}+E\\+?\\p{Digit}+";
                        break;
                    }
                    case 'a': {
                        pattern = "0x[\\p{XDigit},.+p]+";
                        break;
                    }
                    case 'A': {
                        pattern = "0X[\\p{XDigit},.+P]+";
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        pattern = "-?[\\p{XDigit},.+eE]+";
                    }
                }
                if (!".*".equals(pattern) && (width = matcher.group(3)) != null) {
                    String flags = matcher.group(2);
                    pattern = "0".equals(flags) ? "0*" + pattern : " " + pattern;
                }
                int regexLength = regexp.length();
                if (!".*".equals(pattern) || regexLength < 2 || regexp.charAt(regexLength - 1) != '*' || regexp.charAt(regexLength - 2) != '.') {
                    regexp.append(pattern);
                }
            }
            from = end;
        }
        if (from < length) {
            hasEscapedLetters |= PossibleResourcesMarker.appendEscapedPattern(formatString, regexp, from, length);
        }
        if (!hasEscapedLetters) {
            return NO_MATCH;
        }
        return regexp.toString();
    }

    private static boolean appendEscapedPattern(String formatString, StringBuilder regexp, int from, int to) {
        regexp.append(Pattern.quote(formatString.substring(from, to)));
        for (int i2 = from; i2 < to; ++i2) {
            if (!Character.isLetter(formatString.charAt(i2))) continue;
            return true;
        }
        return false;
    }
}

