/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.ArtifactUtils;
import com.android.build.gradle.internal.ide.dependencies.DependencyGraphBuilder;
import com.android.build.gradle.internal.ide.dependencies.DependencyModelBuilder;
import com.android.build.gradle.internal.ide.dependencies.Level1RuntimeArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;

class ArtifactDependencyGraph
implements DependencyGraphBuilder {
    private final DependencyFailureHandler dependencyFailureHandler = new DependencyFailureHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDependencies(DependencyModelBuilder<?> modelBuilder, ArtifactCollectionsInputs artifactCollectionsInputs, boolean withFullDependency, IssueReporter issueReporter2) {
        try {
            Set<ResolvedArtifact> compileArtifacts = ArtifactUtils.getAllArtifacts(artifactCollectionsInputs, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, this.dependencyFailureHandler);
            Set dependenciesLintJars = artifactCollectionsInputs.getLintJars().getArtifacts();
            ImmutableMap.Builder lintJarMapBuilder = ImmutableMap.builder();
            for (ResolvedArtifactResult artifact : dependenciesLintJars) {
                lintJarMapBuilder.put((Object)artifact.getId().getComponentIdentifier(), (Object)artifact.getFile());
            }
            ImmutableMap lintJarMap = lintJarMapBuilder.build();
            if (withFullDependency && modelBuilder.getNeedFullRuntimeClasspath()) {
                Set<ResolvedArtifact> runtimeArtifacts = ArtifactUtils.getAllArtifacts(artifactCollectionsInputs, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, this.dependencyFailureHandler);
                Set runtimeIds = runtimeArtifacts.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    modelBuilder.addArtifact(artifact, !runtimeIds.contains(artifact.getComponentIdentifier()), (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.COMPILE);
                }
                for (ResolvedArtifact artifact : runtimeArtifacts) {
                    modelBuilder.addArtifact(artifact, false, (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.RUNTIME);
                }
            } else {
                Level1RuntimeArtifactCollections level1RuntimeArtifactCollections = artifactCollectionsInputs.getLevel1RuntimeArtifactCollections();
                ImmutableSet<ComponentIdentifier> runtimeIds = ArtifactDependencyGraph.getRuntimeComponentIdentifiers(level1RuntimeArtifactCollections.getRuntimeArtifacts());
                for (ResolvedArtifact artifact : compileArtifacts) {
                    modelBuilder.addArtifact(artifact, !runtimeIds.contains((Object)artifact.getComponentIdentifier()), (Map<ComponentIdentifier, File>)lintJarMap, DependencyModelBuilder.ClasspathType.COMPILE);
                }
                if (modelBuilder.getNeedRuntimeOnlyClasspath()) {
                    modelBuilder.setRuntimeOnlyClasspath(ArtifactDependencyGraph.getRuntimeOnlyClasspath(level1RuntimeArtifactCollections, compileArtifacts, runtimeIds));
                }
            }
        }
        finally {
            this.dependencyFailureHandler.registerIssues(issueReporter2);
        }
    }

    private static ImmutableSet<ComponentIdentifier> getRuntimeComponentIdentifiers(ArtifactCollection runtimeArtifactCollection) {
        ImmutableSet.Builder runtimeIdentifiersBuilder = ImmutableSet.builder();
        for (ResolvedArtifactResult result2 : runtimeArtifactCollection.getArtifacts()) {
            runtimeIdentifiersBuilder.add((Object)result2.getId().getComponentIdentifier());
        }
        return runtimeIdentifiersBuilder.build();
    }

    private static ImmutableList<File> getRuntimeOnlyClasspath(Level1RuntimeArtifactCollections runtimeArtifactCollections, Set<ResolvedArtifact> artifacts2, ImmutableSet<ComponentIdentifier> runtimeIdentifiers) {
        Set compileIdentifiers = artifacts2.stream().map(ResolvedArtifact::getComponentIdentifier).collect(Collectors.toSet());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> projectRuntime = ArtifactUtils.asMultiMap(runtimeArtifactCollections.getRuntimeProjectJars());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> externalRuntime = ArtifactUtils.asMultiMap(runtimeArtifactCollections.getRuntimeExternalJars());
        ImmutableList.Builder runtimeOnlyClasspathBuilder = ImmutableList.builder();
        for (ComponentIdentifier runtimeIdentifier : runtimeIdentifiers) {
            if (compileIdentifiers.contains(runtimeIdentifier)) continue;
            for (ResolvedArtifactResult resolvedArtifactResult : projectRuntime.get((Object)runtimeIdentifier)) {
                runtimeOnlyClasspathBuilder.add((Object)resolvedArtifactResult.getFile());
            }
            for (ResolvedArtifactResult resolvedArtifactResult : externalRuntime.get((Object)runtimeIdentifier)) {
                runtimeOnlyClasspathBuilder.add((Object)resolvedArtifactResult.getFile());
            }
        }
        return runtimeOnlyClasspathBuilder.build();
    }

    ArtifactDependencyGraph() {
    }
}

