/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.CompressAssetsWorkParameters;
import com.android.utils.FileUtils;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Source;
import com.android.zipflinger.ZipArchive;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.work.ChangeType;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/CompressAssetsWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/tasks/CompressAssetsWorkParameters;", "compressAssetsWorkParameters", "(Lcom/android/build/gradle/internal/tasks/CompressAssetsWorkParameters;)V", "execute", "", "gradle-core"})
public abstract class CompressAssetsWorkAction
implements WorkAction<CompressAssetsWorkParameters> {
    private final CompressAssetsWorkParameters compressAssetsWorkParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Object object = this.compressAssetsWorkParameters.getOutput().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compressAssetsWorkParameters.output.get()");
        File output2 = ((RegularFile)object).getAsFile();
        ChangeType changeType = (ChangeType)this.compressAssetsWorkParameters.getChangeType().get();
        if (changeType != ChangeType.ADDED) {
            FileUtils.deleteIfExists((File)output2);
        }
        if (changeType != ChangeType.REMOVED) {
            Files.createParentDirs((File)output2);
            Closeable closeable = (Closeable)new ZipArchive(output2);
            boolean bl = false;
            Throwable throwable = null;
            try {
                ZipArchive jar = (ZipArchive)closeable;
                boolean bl2 = false;
                Object object2 = this.compressAssetsWorkParameters.getInput().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"compressAssetsWorkParameters.input.get()");
                File file = ((RegularFile)object2).getAsFile();
                String string = (String)this.compressAssetsWorkParameters.getEntryPath().get();
                Object object3 = this.compressAssetsWorkParameters.getEntryCompressionLevel().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"compressAssetsWorkParame\u2026tryCompressionLevel.get()");
                jar.add((Source)new BytesSource(file, string, ((Number)object3).intValue()));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Inject
    public CompressAssetsWorkAction(@NotNull CompressAssetsWorkParameters compressAssetsWorkParameters) {
        Intrinsics.checkParameterIsNotNull((Object)compressAssetsWorkParameters, (String)"compressAssetsWorkParameters");
        this.compressAssetsWorkParameters = compressAssetsWorkParameters;
    }
}

