/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.ClassesDirToClassesTransformKt;
import com.android.build.gradle.internal.packaging.JarCreatorFactory;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesKt;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesWorkAction$WhenMappings;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.builder.dexing.DexUtilsKt;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.builder.packaging.JarCreator;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J,\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016J4\u0010\u0014\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesWorkAction$Params;", "()V", "copyFilesIncrementally", "", "inputChanges", "Lcom/android/builder/files/SerializableFileChanges;", "outputDir", "Ljava/io/File;", "filter", "Ljava/util/function/Predicate;", "", "copyFilesNonIncrementally", "input", "", "getClassesDirFormat", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ClassesDirFormat;", "inputClassRoots", "run", "zipFilesNonIncrementally", "outputJar", "jarCreatorType", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "Params", "gradle-core"})
public abstract class BundleLibraryClassesWorkAction
extends ProfileAwareWorkAction<Params> {
    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void $this$mapTo$iv$iv;
        Object object = ((Params)this.getParameters()).getPackageName().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.packageName.get()");
        String string = StringsKt.replace$default((String)((String)object), (char)'.', (char)'/', (boolean)false, (int)4, null);
        Object object2 = ((Params)this.getParameters()).getPackageRClass().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.packageRClass.get()");
        Collection collection = LibraryAarJarsTask.Companion.getDefaultExcludes(string, (Boolean)object2);
        Object object3 = ((Params)this.getParameters()).getToIgnore().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.toIgnore.get()");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object3));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pattern pattern = Pattern.compile((String)it);
            collection2.add(pattern);
        }
        List ignorePatterns = (List)destination$iv$iv;
        Predicate predicate2 = new Predicate<String>(ignorePatterns){
            final /* synthetic */ List $ignorePatterns;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(String relativePath) {
                Pattern it;
                String normalizedPath = FileUtils.toSystemIndependentPath((String)relativePath);
                if (!BundleLibraryClassesKt.access$getCLASS_PATTERN$p().matcher(normalizedPath).matches()) {
                    if (!BundleLibraryClassesKt.access$getMETA_INF_PATTERN$p().matcher(normalizedPath).matches()) return false;
                }
                Iterable $this$any$iv = this.$ignorePatterns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return true;
                }
                Iterator<T> iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return true;
                    T element$iv = iterator.next();
                    it = (Pattern)element$iv;
                    boolean bl = false;
                } while (!it.matcher(normalizedPath).matches());
                return false;
            }
            {
                this.$ignorePatterns = list;
            }
        };
        Function1 function1 = DexUtilsKt.isJarFile();
        Object object4 = ((Params)this.getParameters()).getOutput().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"parameters.output.get()");
        if (((Boolean)function1.invoke(object4)).booleanValue()) {
            Set set = ((Params)this.getParameters()).getInput().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"parameters.input.files");
            Object object5 = ((Params)this.getParameters()).getOutput().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"parameters.output.get()");
            File file = (File)object5;
            Object object6 = ((Params)this.getParameters()).getJarCreatorType().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"parameters.jarCreatorType.get()");
            this.zipFilesNonIncrementally(set, file, predicate2, (JarCreatorType)((Object)object6));
        } else {
            Set set = ((Params)this.getParameters()).getInput().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"parameters.input.files");
            switch (BundleLibraryClassesWorkAction$WhenMappings.$EnumSwitchMapping$0[this.getClassesDirFormat(set).ordinal()]) {
                case 1: {
                    FileUtils.deleteRecursivelyIfExists((File)((File)((Params)this.getParameters()).getOutput().get()));
                    FileUtils.mkdirs((File)((File)((Params)this.getParameters()).getOutput().get()));
                    Set set2 = ((Params)this.getParameters()).getInput().getFiles();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"parameters.input.files");
                    Object object7 = ((Params)this.getParameters()).getOutput().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"parameters.output.get()");
                    File file = FilesKt.resolve((File)((File)object7), (String)"classes.jar");
                    Object object8 = ((Params)this.getParameters()).getJarCreatorType().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object8, (String)"parameters.jarCreatorType.get()");
                    this.zipFilesNonIncrementally(set2, file, predicate2, (JarCreatorType)((Object)object8));
                    break;
                }
                case 2: {
                    Object object9 = ((Params)this.getParameters()).getIncremental().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object9, (String)"parameters.incremental.get()");
                    if (((Boolean)object9).booleanValue()) {
                        Object object10 = ((Params)this.getParameters()).getOutput().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object10, (String)"parameters.output.get()");
                        if (ClassesDirToClassesTransformKt.getClassesDirFormat((File)object10) == AndroidArtifacts.ClassesDirFormat.CONTAINS_SINGLE_JAR) {
                            Set set3 = ((Params)this.getParameters()).getInput().getFiles();
                            Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"parameters.input.files");
                            Object object11 = ((Params)this.getParameters()).getOutput().get();
                            Intrinsics.checkExpressionValueIsNotNull((Object)object11, (String)"parameters.output.get()");
                            this.copyFilesNonIncrementally(set3, (File)object11, predicate2);
                            break;
                        }
                        Object object12 = ((Params)this.getParameters()).getInputChanges().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object12, (String)"parameters.inputChanges.get()");
                        SerializableFileChanges serializableFileChanges = (SerializableFileChanges)object12;
                        Object object13 = ((Params)this.getParameters()).getOutput().get();
                        Intrinsics.checkExpressionValueIsNotNull((Object)object13, (String)"parameters.output.get()");
                        this.copyFilesIncrementally(serializableFileChanges, (File)object13, predicate2);
                        break;
                    }
                    Set set4 = ((Params)this.getParameters()).getInput().getFiles();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set4, (String)"parameters.input.files");
                    Object object14 = ((Params)this.getParameters()).getOutput().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object14, (String)"parameters.output.get()");
                    this.copyFilesNonIncrementally(set4, (File)object14, predicate2);
                    break;
                }
            }
        }
    }

    private final AndroidArtifacts.ClassesDirFormat getClassesDirFormat(Set<? extends File> inputClassRoots) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = inputClassRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!((Boolean)DexUtilsKt.isJarFile().invoke((Object)it)).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl ? AndroidArtifacts.ClassesDirFormat.CONTAINS_SINGLE_JAR : AndroidArtifacts.ClassesDirFormat.CONTAINS_CLASS_FILES_ONLY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipFilesNonIncrementally(Set<? extends File> input, File outputJar, Predicate<String> filter2, JarCreatorType jarCreatorType) {
        FileUtils.deleteIfExists((File)outputJar);
        FileUtils.mkdirs((File)outputJar.getParentFile());
        Path path = outputJar.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputJar.toPath()");
        Closeable closeable = (Closeable)JarCreatorFactory.INSTANCE.make(path, filter2, jarCreatorType);
        boolean bl = false;
        Throwable throwable = null;
        try {
            JarCreator jarCreator = (JarCreator)closeable;
            boolean bl2 = false;
            jarCreator.setCompressionLevel(0);
            Iterable $this$forEach$iv = input;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File base = (File)element$iv;
                boolean bl3 = false;
                if (base.isDirectory()) {
                    jarCreator.addDirectory(base.toPath());
                    continue;
                }
                boolean bl4 = (Boolean)DexUtilsKt.isJarFile().invoke((Object)base);
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "Expected jar file but found " + base.getPath() + '.';
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                jarCreator.addJar(base.toPath());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void copyFilesNonIncrementally(Set<? extends File> input, File outputDir, Predicate<String> filter2) {
        FileUtils.deleteRecursivelyIfExists((File)outputDir);
        FileUtils.mkdirs((File)outputDir);
        Iterable $this$forEach$iv = input;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File classRoot = (File)element$iv;
            boolean bl = false;
            boolean bl2 = classRoot.isDirectory();
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Expected directory but found " + classRoot.getPath() + '.';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Sequence $this$forEach$iv2 = (Sequence)FilesKt.walk$default((File)classRoot, null, (int)1, null);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String relativePath;
                File it = (File)element$iv2;
                boolean bl6 = false;
                String string = relativePath = FilesKt.relativeTo((File)it, (File)classRoot).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relativePath");
                CharSequence charSequence = string;
                boolean bl7 = false;
                if (!(charSequence.length() > 0) || !filter2.test(relativePath)) continue;
                File outputFile = FilesKt.resolve((File)outputDir, (String)relativePath);
                FileUtils.mkdirs((File)outputFile.getParentFile());
                FileUtils.copyFile((File)it, (File)outputFile);
            }
        }
    }

    private final void copyFilesIncrementally(SerializableFileChanges inputChanges, File outputDir, Predicate<String> filter2) {
        SerializableChange it;
        Iterable $this$forEach$iv = inputChanges.getRemovedFiles();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SerializableChange)element$iv;
            boolean bl = false;
            File staleOutputFile = FilesKt.resolve((File)outputDir, (String)it.getNormalizedPath());
            FileUtils.deleteRecursivelyIfExists((File)staleOutputFile);
        }
        $this$forEach$iv = CollectionsKt.plus((Collection)inputChanges.getModifiedFiles(), (Iterable)inputChanges.getAddedFiles());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SerializableChange)element$iv;
            boolean bl = false;
            String relativePath = it.getNormalizedPath();
            CharSequence charSequence = relativePath;
            boolean bl2 = false;
            if (!(charSequence.length() > 0) || !filter2.test(relativePath)) continue;
            File outputFile = FilesKt.resolve((File)outputDir, (String)relativePath);
            FileUtils.mkdirs((File)outputFile.getParentFile());
            FileUtils.copyFile((File)it.getFile(), (File)outputFile);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0007R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0007R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleLibraryClassesWorkAction$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "incremental", "Lorg/gradle/api/provider/Property;", "", "getIncremental", "()Lorg/gradle/api/provider/Property;", "input", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getInput", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "inputChanges", "Lcom/android/builder/files/SerializableFileChanges;", "getInputChanges", "jarCreatorType", "Lcom/android/build/gradle/internal/packaging/JarCreatorType;", "getJarCreatorType", "output", "Ljava/io/File;", "getOutput", "packageName", "", "getPackageName", "packageRClass", "getPackageRClass", "toIgnore", "Lorg/gradle/api/provider/ListProperty;", "getToIgnore", "()Lorg/gradle/api/provider/ListProperty;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<String> getPackageName();

        @NotNull
        public abstract ListProperty<String> getToIgnore();

        @NotNull
        public abstract Property<File> getOutput();

        @NotNull
        public abstract ConfigurableFileCollection getInput();

        @NotNull
        public abstract Property<Boolean> getIncremental();

        @NotNull
        public abstract Property<SerializableFileChanges> getInputChanges();

        @NotNull
        public abstract Property<Boolean> getPackageRClass();

        @NotNull
        public abstract Property<JarCreatorType> getJarCreatorType();
    }
}

