/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0004()*+B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001b\u001a\u00020\u001cJ\r\u0010\u001d\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "cacheBuilderSpec", "Lcom/google/common/cache/CacheBuilderSpec;", "(Lcom/google/common/cache/CacheBuilderSpec;)V", "logLevel", "Lorg/gradle/api/logging/LogLevel;", "getLogLevel", "()Lorg/gradle/api/logging/LogLevel;", "logger", "Lorg/gradle/api/logging/Logger;", "getLogger", "()Lorg/gradle/api/logging/Logger;", "symbolInterner", "Lcom/google/common/collect/Interner;", "Lcom/android/ide/common/symbols/Symbol;", "getSymbolInterner", "()Lcom/google/common/collect/Interner;", "symbolInternerReference", "Ljava/lang/ref/SoftReference;", "symbolTableCache", "Lcom/google/common/cache/LoadingCache;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService$FileCacheKey;", "Lcom/android/ide/common/symbols/SymbolTable;", "close", "", "dropSymbolInterner", "dropSymbolInterner$gradle_core", "dropSymbolTables", "dropSymbolTables$gradle_core", "getSymbolTablesCached", "", "files", "", "Ljava/io/File;", "loadClasspath", "loadSymbolTablesNonCached", "Companion", "FileCacheKey", "Parameters", "RegistrationAction", "gradle-core"})
@ThreadSafe
public abstract class SymbolTableBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LogLevel logLevel;
    private SoftReference<Interner<Symbol>> symbolInternerReference;
    private final LoadingCache<FileCacheKey, SymbolTable> symbolTableCache;
    private static final CacheBuilderSpec SOFT_VALUES;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final List<SymbolTable> loadClasspath(@NotNull Iterable<? extends File> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.logger.log(this.logLevel, "SymbolTableBuildService: loadClasspath started");
        Object object = ((Parameters)this.getParameters()).getCacheEnabled().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.cacheEnabled.get()");
        List<SymbolTable> list = (Boolean)object != false ? this.getSymbolTablesCached(files2) : this.loadSymbolTablesNonCached(files2);
        boolean bl = false;
        boolean bl2 = false;
        List<SymbolTable> result2 = list;
        boolean bl3 = false;
        this.logger.log(this.logLevel, "SymbolTableBuildService: loadClasspath took {} to return {} tables", new Object[]{stopwatch.elapsed(), result2.size()});
        return result2;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    private final List<SymbolTable> loadSymbolTablesNonCached(Iterable<? extends File> files2) {
        ImmutableList result2;
        SymbolIo symbolIo = new SymbolIo();
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableList.Builder it = builder;
        boolean bl3 = false;
        for (File file : files2) {
            it.add((Object)symbolIo.readSymbolListWithPackageName(file.toPath()));
        }
        ImmutableList immutableList = result2 = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"result");
        return (List)immutableList;
    }

    private final synchronized Interner<Symbol> getSymbolInterner() {
        Interner interner2 = this.symbolInternerReference;
        if (interner2 == null || (interner2 = interner2.get()) == null) {
            Interner interner3 = Interners.newStrongInterner();
            boolean bl = false;
            boolean bl2 = false;
            Interner it = interner3;
            boolean bl3 = false;
            this.symbolInternerReference = new SoftReference<Interner>(it);
            for (SymbolTable symbolTable : this.symbolTableCache.asMap().values()) {
                for (Symbol symbol : symbolTable.getSymbols().values()) {
                    it.intern((Object)symbol);
                }
            }
            Interner interner4 = interner3;
            interner2 = interner4;
            Intrinsics.checkExpressionValueIsNotNull((Object)interner4, (String)"Interners.newStrongInter\u2026          }\n            }");
        }
        return interner2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SymbolTable> getSymbolTablesCached(Iterable<? extends File> files2) {
        void $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv = files2;
        boolean $i$f$map = false;
        Iterable<? extends File> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
            SymbolTable symbolTable = (SymbolTable)this.symbolTableCache.get((Object)new FileCacheKey(path, null, 2, null));
            collection.add(symbolTable);
        }
        return (List)destination$iv$iv;
    }

    @VisibleForTesting
    public final void dropSymbolInterner$gradle_core() {
        block0: {
            SoftReference<Interner<Symbol>> softReference = this.symbolInternerReference;
            if (softReference == null) break block0;
            softReference.clear();
        }
    }

    @VisibleForTesting
    public final void dropSymbolTables$gradle_core() {
        this.symbolTableCache.invalidateAll();
    }

    @Override
    public final void close() {
        this.dropSymbolInterner$gradle_core();
        this.dropSymbolTables$gradle_core();
    }

    @VisibleForTesting
    public SymbolTableBuildService(@NotNull CacheBuilderSpec cacheBuilderSpec) {
        Intrinsics.checkParameterIsNotNull((Object)cacheBuilderSpec, (String)"cacheBuilderSpec");
        Logger logger = Logging.getLogger(SymbolTableBuildService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Symbol\u2026BuildService::class.java)");
        this.logger = logger;
        this.logLevel = Intrinsics.areEqual((Object)BooleanOption.ENABLE_SYMBOL_TABLE_CACHING.getDefaultValue(), (Object)((Boolean)((Parameters)this.getParameters()).getCacheEnabled().get())) ^ true ? LogLevel.INFO : LogLevel.DEBUG;
        LoadingCache loadingCache = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).build((CacheLoader)new CacheLoader<FileCacheKey, SymbolTable>(this){
            final /* synthetic */ SymbolTableBuildService this$0;

            @NotNull
            public SymbolTable load(@NotNull FileCacheKey key) {
                Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
                SymbolTable result2 = new SymbolIo(SymbolTableBuildService.access$getSymbolInterner$p(this.this$0)).readSymbolListWithPackageName(key.getFile());
                this.this$0.getLogger().log(this.this$0.getLogLevel(), "SymbolTableBuildService: cache miss - loaded table '{}' from disk", new Object[]{result2.getTablePackage()});
                SymbolTable symbolTable = result2;
                Intrinsics.checkExpressionValueIsNotNull((Object)symbolTable, (String)"result");
                return symbolTable;
            }
            {
                this.this$0 = this$0;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)loadingCache, (String)"CacheBuilder.from(cacheB\u2026          }\n            )");
        this.symbolTableCache = loadingCache;
    }

    @Inject
    public SymbolTableBuildService() {
        CacheBuilderSpec cacheBuilderSpec = SOFT_VALUES;
        Intrinsics.checkExpressionValueIsNotNull((Object)cacheBuilderSpec, (String)"SOFT_VALUES");
        this(cacheBuilderSpec);
    }

    static {
        Companion = new Companion(null);
        SOFT_VALUES = CacheBuilderSpec.parse((String)"softValues");
    }

    public static final /* synthetic */ Interner access$getSymbolInterner$p(SymbolTableBuildService $this) {
        return $this.getSymbolInterner();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "()V", "cacheEnabled", "Lorg/gradle/api/provider/Property;", "", "getCacheEnabled", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Parameters
    implements BuildServiceParameters {
        @NotNull
        public abstract Property<Boolean> getCacheEnabled();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\t\u001a\u00020\u0001H\u00c2\u0003J\u001d\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$FileCacheKey;", "", "file", "Ljava/nio/file/Path;", "key", "(Ljava/nio/file/Path;Ljava/lang/Object;)V", "getFile", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
    private static final class FileCacheKey {
        @NotNull
        private final Path file;
        private final Object key;

        public boolean equals(@Nullable Object other) {
            return other instanceof FileCacheKey && Intrinsics.areEqual((Object)this.key, (Object)((FileCacheKey)other).key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        @NotNull
        public final Path getFile() {
            return this.file;
        }

        public FileCacheKey(@NotNull Path file, @NotNull Object key) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.file = file;
            this.key = key;
        }

        public /* synthetic */ FileCacheKey(Path path, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Object object2 = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).fileKey();
                if (object2 == null) {
                    String string = path.toUri().toString();
                    object2 = string;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.toUri().toString()");
                }
                object = object2;
            }
            this(path, object);
        }

        @NotNull
        public final Path component1() {
            return this.file;
        }

        private final Object component2() {
            return this.key;
        }

        @NotNull
        public final FileCacheKey copy(@NotNull Path file, @NotNull Object key) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return new FileCacheKey(file, key);
        }

        public static /* synthetic */ FileCacheKey copy$default(FileCacheKey fileCacheKey, Path path, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                path = fileCacheKey.file;
            }
            if ((n & 2) != 0) {
                object = fileCacheKey.key;
            }
            return fileCacheKey.copy(path, object);
        }

        @NotNull
        public String toString() {
            return "FileCacheKey(file=" + this.file + ", key=" + this.key + ")";
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService;", "Lcom/android/build/gradle/internal/services/SymbolTableBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<SymbolTableBuildService, Parameters> {
        private final ProjectOptions projectOptions;

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            Property<Boolean> property = parameters.getCacheEnabled();
            Provider<Boolean> provider2 = this.projectOptions.getProvider(BooleanOption.ENABLE_SYMBOL_TABLE_CACHING);
            Intrinsics.checkExpressionValueIsNotNull(provider2, (String)"projectOptions.getProvid\u2026BLE_SYMBOL_TABLE_CACHING)");
            HasConfigurableValuesKt.setDisallowChanges(property, provider2);
        }

        public RegistrationAction(@NotNull Project project, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            super(project, SymbolTableBuildService.class, null, 4, null);
            this.projectOptions = projectOptions;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/services/SymbolTableBuildService$Companion;", "", "()V", "SOFT_VALUES", "Lcom/google/common/cache/CacheBuilderSpec;", "kotlin.jvm.PlatformType", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

