/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.SdkHandler;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.TargetInfo;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010 \u001a\u00020#H\u0002J\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014J\b\u0010%\u001a\u0004\u0018\u00010\u0012J\b\u0010&\u001a\u0004\u0018\u00010\u0012J\b\u0010'\u001a\u0004\u0018\u00010\u0012J\b\u0010(\u001a\u0004\u0018\u00010\u0012J\u0010\u0010)\u001a\u0004\u0018\u00010\u00122\u0006\u0010*\u001a\u00020\u0005J\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014J\b\u0010,\u001a\u0004\u0018\u00010-J\b\u0010.\u001a\u00020\tH\u0002J\u0006\u0010/\u001a\u000200R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/build/gradle/internal/SdkFullLoadingStrategy;", "", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "(Lcom/android/build/gradle/internal/SdkHandler;Ljava/lang/String;Lcom/android/repository/Revision;Z)V", "sdkInfo", "Lcom/android/builder/sdk/SdkInfo;", "sdkInitResult", "Ljava/lang/Boolean;", "targetInfo", "Lcom/android/builder/sdk/TargetInfo;", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreLambaStubs", "getEmulatorLibFolder", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getFileFromTarget", "", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getSystemImageLibFolder", "imageHash", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "reset", "", "gradle-core"})
public final class SdkFullLoadingStrategy {
    private Boolean sdkInitResult;
    private SdkInfo sdkInfo;
    private TargetInfo targetInfo;
    private final SdkHandler sdkHandler;
    private final String platformTargetHashSupplier;
    private final Revision buildToolRevisionSupplier;
    private final boolean useAndroidX;

    private final synchronized boolean init() {
        if (this.sdkInitResult != null) {
            Boolean bl = this.sdkInitResult;
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            return bl;
        }
        String string = this.platformTargetHashSupplier;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String platformHash = string;
        Revision revision = this.buildToolRevisionSupplier;
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Revision buildToolRevision = revision;
        Pair<SdkInfo, TargetInfo> result2 = this.sdkHandler.initTarget(platformHash, buildToolRevision);
        if (result2 == null) {
            this.sdkInitResult = false;
            return false;
        }
        this.sdkHandler.ensurePlatformToolsIsInstalledWarnOnFailure();
        this.sdkInitResult = true;
        Object object = result2.getFirst();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"result.first");
        this.sdkInfo = (SdkInfo)object;
        Object object2 = result2.getSecond();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"result.second");
        this.targetInfo = (TargetInfo)object2;
        return true;
    }

    @Nullable
    public final File getAdbExecutable() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo = this.sdkInfo;
            if (sdkInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
            }
            file = sdkInfo.getAdb();
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAnnotationsJar() {
        File file;
        if (this.init()) {
            SdkInfo sdkInfo = this.sdkInfo;
            if (sdkInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"sdkInfo");
            }
            file = sdkInfo.getAnnotationsJar();
        } else {
            file = null;
        }
        return file;
    }

    private final File getFileFromTarget(int component2) {
        File file;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            file = targetInfo.getTarget().getFile(component2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlFramework() {
        return this.getFileFromTarget(2);
    }

    @Nullable
    public final File getAndroidJar() {
        return this.getFileFromTarget(1);
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            list = iAndroidTarget.getAdditionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        List list;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            list = iAndroidTarget.getOptionalLibraries();
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        AndroidVersion androidVersion;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            androidVersion = iAndroidTarget.getVersion();
        } else {
            androidVersion = null;
        }
        return androidVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<File> getTargetBootClasspath() {
        List list;
        if (this.init()) {
            void $this$mapTo$iv$iv;
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            IAndroidTarget iAndroidTarget = targetInfo.getTarget();
            Intrinsics.checkExpressionValueIsNotNull((Object)iAndroidTarget, (String)"targetInfo.target");
            List list2 = iAndroidTarget.getBootClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"targetInfo.target.bootClasspath");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file = new File((String)it);
                collection.add(file);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        BuildToolInfo buildToolInfo;
        if (this.init()) {
            TargetInfo targetInfo = this.targetInfo;
            if (targetInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"targetInfo");
            }
            buildToolInfo = targetInfo.getBuildTools();
        } else {
            buildToolInfo = null;
        }
        return buildToolInfo;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo != null ? buildToolInfo.getRevision() : null;
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component2) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component2));
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSystemImageLibFolder(@NotNull String imageHash) {
        Intrinsics.checkParameterIsNotNull((Object)imageHash, (String)"imageHash");
        return this.sdkHandler.installSystemImageWarnOnFailure(imageHash);
    }

    @Nullable
    public final File getEmulatorLibFolder() {
        return this.sdkHandler.getLocalEmulator();
    }

    public final synchronized void reset() {
        this.sdkInitResult = null;
        this.sdkHandler.unload();
    }

    public SdkFullLoadingStrategy(@NotNull SdkHandler sdkHandler2, @Nullable String platformTargetHashSupplier, @Nullable Revision buildToolRevisionSupplier, boolean useAndroidX) {
        Intrinsics.checkParameterIsNotNull((Object)sdkHandler2, (String)"sdkHandler");
        this.sdkHandler = sdkHandler2;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
    }
}

