/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.DetermineUsedStlResult;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt$WhenMappings;
import com.android.ide.common.process.ProcessInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"generatePrefabPackages", "", "ops", "Lorg/gradle/process/ExecOperations;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "gradle-core"})
public final class GeneratePrefabPackagesKt {
    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abiModel) {
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        Intrinsics.checkParameterIsNotNull((Object)abiModel, (String)"abiModel");
        Iterable $this$map$iv = CreateCxxVariantModelKt.getPrefabPackageDirectoryList(abiModel.getVariant());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getPath();
            collection.add(string2);
        }
        List packagePaths = (List)destination$iv$iv;
        switch (GeneratePrefabPackagesKt$WhenMappings.$EnumSwitchMapping$0[abiModel.getVariant().getModule().getBuildSystem().ordinal()]) {
            case 1: {
                string = "ndk-build";
                break;
            }
            case 2: {
                string = "cmake";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String buildSystem = string;
        int osVersion = abiModel.getAbiPlatformVersion();
        File file = CreateCxxVariantModelKt.getPrefabClassPath(abiModel.getVariant());
        if (file == null) {
            throw (Throwable)new RuntimeException("CxxAbiModule.prefabClassPath cannot be null when Prefab is used");
        }
        File prefabClassPath = file;
        DetermineUsedStlResult result2 = CxxVariantModelKt.determineUsedStl(abiModel.getVariant());
        if (!(result2 instanceof DetermineUsedStlResult.Success)) {
            if (result2 instanceof DetermineUsedStlResult.Failure) {
                LoggingEnvironmentKt.errorln(((DetermineUsedStlResult.Failure)result2).getError(), new Object[0]);
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Stl selectedStl = ((DetermineUsedStlResult.Success)result2).getStl();
        ProcessInfoBuilder builder = new ProcessInfoBuilder().setClasspath(prefabClassPath.toString()).setMain("com.google.prefab.cli.AppKt").addArgs("--build-system", buildSystem).addArgs("--platform", "android").addArgs("--abi", abiModel.getAbi().getTag()).addArgs("--os-version", String.valueOf(osVersion)).addArgs("--stl", selectedStl.getArgumentName()).addArgs("--ndk-version", String.valueOf(abiModel.getVariant().getModule().getNdkVersion().getMajor())).addArgs("--output", FilesKt.resolve((File)abiModel.getPrefabFolder(), (String)"prefab").toString()).addArgs(packagePaths);
        File file2 = FilesKt.resolve((File)CxxAbiModelKt.getSoFolder(abiModel), (String)("prefab_command_" + buildSystem + '_' + abiModel.getAbi().getTag() + ".txt"));
        File file3 = FilesKt.resolve((File)CxxAbiModelKt.getSoFolder(abiModel), (String)("prefab_stdout_" + buildSystem + '_' + abiModel.getAbi().getTag() + ".txt"));
        File file4 = FilesKt.resolve((File)CxxAbiModelKt.getSoFolder(abiModel), (String)("prefab_stderr_" + buildSystem + '_' + abiModel.getAbi().getTag() + ".txt"));
        ProcessInfoBuilder processInfoBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)processInfoBuilder, (String)"builder");
        ProcessOutputJunctionKt.createProcessOutputJunction(file2, file3, file4, processInfoBuilder, "prefab").javaProcess().logStderrToLifecycle().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super JavaExecSpec>, ExecResult>(ops2){

            public final ExecResult invoke(Action<? super JavaExecSpec> p1) {
                return ((ExecOperations)this.receiver).javaexec(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ExecOperations.class);
            }

            public final String getName() {
                return "javaexec";
            }

            public final String getSignature() {
                return "javaexec(Lorg/gradle/api/Action;)Lorg/gradle/process/ExecResult;";
            }
        }));
    }
}

