/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.impl.SingleInitialProviderRequestImpl;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.component.ApkCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.signing.SigningConfigProviderParams;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.FinalizeBundleTask$CreationAction$handleProvider$2;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.StringOption;
import com.android.builder.internal.packaging.AabFlinger;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R$\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "finalBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "finalBundleFileName", "", "getFinalBundleFileName", "()Ljava/lang/String;", "intermediaryBundleFile", "getIntermediaryBundleFile", "<set-?>", "Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "signingConfigData", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "Params", "gradle-core"})
public abstract class FinalizeBundleTask
extends NonIncrementalTask {
    @Nullable
    private SigningConfigDataProvider signingConfigData;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract RegularFileProperty getIntermediaryBundleFile();

    @Nested
    @Optional
    @Nullable
    public final SigningConfigDataProvider getSigningConfigData() {
        return this.signingConfigData;
    }

    @Input
    @NotNull
    public final String getFinalBundleFileName() {
        Object object = this.getFinalBundleFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"finalBundleFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"finalBundleFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"finalBundleFile.get().asFile.name");
        return string;
    }

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getFinalBundleFile();

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ FinalizeBundleTask this$0;

            public final void execute(Params it) {
                block0: {
                    it.initializeFromAndroidVariantTask(this.this$0);
                    it.getIntermediaryBundleFile().set((Provider)this.this$0.getIntermediaryBundleFile());
                    it.getFinalBundleFile().set((Provider)this.this$0.getFinalBundleFile());
                    Object object = this.this$0.getSigningConfigData();
                    if (object == null || (object = ((SigningConfigDataProvider)object).convertToParams()) == null) break block0;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object signing = object2;
                    boolean bl3 = false;
                    it.getSigningConfig().set(signing);
                }
            }
            {
                this.this$0 = finalizeBundleTask;
            }
        });
    }

    public static final /* synthetic */ SigningConfigDataProvider access$getSigningConfigData$p(FinalizeBundleTask $this) {
        return $this.signingConfigData;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "finalBundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFinalBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "intermediaryBundleFile", "getIntermediaryBundleFile", "signingConfig", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigProviderParams;", "getSigningConfig", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getIntermediaryBundleFile();

        @NotNull
        public abstract RegularFileProperty getFinalBundleFile();

        @NotNull
        public abstract Property<SigningConfigProviderParams> getSigningConfig();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$Params;", "()V", "compressBundle", "", "inputFile", "Ljava/io/File;", "outputFile", "run", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void compressBundle(File inputFile, File outputFile) {
            Object object = inputFile;
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = new ZipInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
            n = 0;
            Throwable throwable = null;
            try {
                ZipInputStream inputStream = (ZipInputStream)object;
                boolean bl2 = false;
                Object object2 = outputFile;
                int n2 = 0;
                object2 = new FileOutputStream((File)object2);
                n2 = 8192;
                boolean bl3 = false;
                object2 = new ZipOutputStream(object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n2));
                n2 = 0;
                Throwable throwable2 = null;
                try {
                    ZipOutputStream outputStream = (ZipOutputStream)object2;
                    boolean bl4 = false;
                    while (inputStream.getNextEntry() != null) {
                        ZipEntry entry;
                        ZipEntry outEntry = new ZipEntry(entry.getName());
                        outEntry.setTime(0L);
                        outputStream.putNextEntry(outEntry);
                        ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                        outputStream.closeEntry();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileUtils.deleteIfExists((File)((File)((Params)this.getParameters()).getFinalBundleFile().getAsFile().get()));
            Serializable serializable = (SigningConfigProviderParams)((Params)this.getParameters()).getSigningConfig().getOrNull();
            if (serializable != null && (serializable = ((SigningConfigProviderParams)serializable).resolve()) != null) {
                Serializable serializable2 = serializable;
                boolean bl = false;
                boolean bl2 = false;
                Serializable it = serializable2;
                boolean bl3 = false;
                String string = ((SigningConfigData)it).getStoreType();
                File file = ((SigningConfigData)it).getStoreFile();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = ((SigningConfigData)it).getStorePassword();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = ((SigningConfigData)it).getKeyPassword();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                String string4 = ((SigningConfigData)it).getKeyAlias();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)string, (File)file, (String)string2, (String)string3, (String)string4);
                Object object = ((Params)this.getParameters()).getFinalBundleFile().getAsFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.finalBundleFile.asFile.get()");
                File file2 = (File)object;
                Object object2 = ((SigningConfigData)it).getKeyAlias();
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale2 = locale;
                boolean bl4 = false;
                String string5 = object2;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toUpperCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase(locale)");
                CertificateInfo certificateInfo2 = certificateInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)certificateInfo2, (String)"certificateInfo");
                PrivateKey privateKey = certificateInfo2.getKey();
                Intrinsics.checkExpressionValueIsNotNull((Object)privateKey, (String)"certificateInfo.key");
                object2 = (Closeable)new AabFlinger(file2, string6, privateKey, CollectionsKt.listOf((Object)certificateInfo.getCertificate()), 18);
                boolean bl5 = false;
                Throwable throwable = null;
                try {
                    AabFlinger it2 = (AabFlinger)object2;
                    boolean bl6 = false;
                    Object object3 = ((Params)this.getParameters()).getIntermediaryBundleFile().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.intermediaryBundleFile.get()");
                    File file3 = ((RegularFile)object3).getAsFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"parameters.intermediaryBundleFile.get().asFile");
                    it2.writeZip(file3, -1);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            } else {
                BundleToolRunnable bundleToolRunnable = this;
                boolean bl = false;
                boolean bl7 = false;
                BundleToolRunnable $this$run = bundleToolRunnable;
                boolean bl8 = false;
                Object object = ((Params)$this$run.getParameters()).getIntermediaryBundleFile().getAsFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.intermediaryBundleFile.asFile.get()");
                File file = (File)object;
                Object object4 = ((Params)$this$run.getParameters()).getFinalBundleFile().getAsFile().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"parameters.finalBundleFile.asFile.get()");
                $this$run.compressBundle(file, (File)object4);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/FinalizeBundleTask;", "Lcom/android/build/gradle/internal/component/ApkCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApkCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<FinalizeBundleTask, ApkCreationConfig> {
        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("sign", "Bundle");
        }

        @Override
        @NotNull
        public Class<FinalizeBundleTask> getType() {
            return FinalizeBundleTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<FinalizeBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            String bundleName = ((ApkCreationConfig)this.creationConfig).getGlobalScope().getProjectBaseName() + '-' + ((ApkCreationConfig)this.creationConfig).getBaseName() + ".aab";
            String apkLocationOverride = ((ApkCreationConfig)this.creationConfig).getServices().getProjectOptions().get(StringOption.IDE_APK_LOCATION);
            if (apkLocationOverride == null) {
                ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)FinalizeBundleTask$CreationAction$handleProvider$1.INSTANCE).withName(bundleName).on((Artifact.SingleArtifact)ArtifactType.BUNDLE.INSTANCE);
            } else {
                SingleInitialProviderRequestImpl singleInitialProviderRequestImpl = ((ApkCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)FinalizeBundleTask$CreationAction$handleProvider$2.INSTANCE);
                File file = FileUtils.join((File)((ApkCreationConfig)this.creationConfig).getServices().file(apkLocationOverride), (String[])new String[]{((ApkCreationConfig)this.creationConfig).getDirName()});
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026  creationConfig.dirName)");
                singleInitialProviderRequestImpl.atLocation(file.getAbsolutePath()).withName(bundleName).on((Artifact.SingleArtifact)ArtifactType.BUNDLE.INSTANCE);
            }
        }

        @Override
        public void configure(@NotNull FinalizeBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((ApkCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getIntermediaryBundleFile());
            if (!((ApkCreationConfig)this.creationConfig).getDebuggable()) {
                ComponentCreationConfig componentCreationConfig = this.creationConfig;
                if (componentCreationConfig == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.component.impl.ComponentImpl");
                }
                task.signingConfigData = SigningConfigDataProvider.Companion.create((ComponentImpl)componentCreationConfig);
            }
        }

        public CreationAction(@NotNull ApkCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }
    }
}

