/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.shrinker;

import com.android.aapt.Resources;
import com.android.build.gradle.internal.res.shrinker.ApkArchiveFormat;
import com.android.build.gradle.internal.res.shrinker.ArchiveFormat;
import com.android.build.gradle.internal.res.shrinker.BundleArchiveFormat;
import com.android.build.gradle.internal.res.shrinker.DummyContent;
import com.android.build.gradle.internal.res.shrinker.LinkedResourcesFormat;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinker;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerImpl;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerModel;
import com.android.build.gradle.internal.res.shrinker.ResourceTableUtilKt;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ResourcesGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ResourceUsageRecorder;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BQ\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020\"H\u0002J \u0010'\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010(\u001a\u00020.H\u0002J \u0010/\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0006\u0010(\u001a\u00020)H\u0016J,\u00100\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020302H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/build/gradle/internal/res/shrinker/ResourceShrinkerImpl;", "Lcom/android/build/gradle/internal/res/shrinker/ResourceShrinker;", "resourcesGatherers", "", "Lcom/android/build/gradle/internal/res/shrinker/gatherer/ResourcesGatherer;", "obfuscationMappingsRecorder", "Lcom/android/build/gradle/internal/res/shrinker/obfuscation/ObfuscationMappingsRecorder;", "usageRecorders", "Lcom/android/build/gradle/internal/res/shrinker/usages/ResourceUsageRecorder;", "graphBuilders", "Lcom/android/build/gradle/internal/res/shrinker/graph/ResourcesGraphBuilder;", "debugReporter", "Lcom/android/build/gradle/internal/res/shrinker/ShrinkerDebugReporter;", "supportMultipackages", "", "usePreciseShrinking", "(Ljava/util/List;Lcom/android/build/gradle/internal/res/shrinker/obfuscation/ObfuscationMappingsRecorder;Ljava/util/List;Ljava/util/List;Lcom/android/build/gradle/internal/res/shrinker/ShrinkerDebugReporter;ZZ)V", "model", "Lcom/android/build/gradle/internal/res/shrinker/ResourceShrinkerModel;", "getModel", "()Lcom/android/build/gradle/internal/res/shrinker/ResourceShrinkerModel;", "getSupportMultipackages", "()Z", "unused", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "analyze", "", "close", "copyToOutput", "zis", "Ljava/io/InputStream;", "zos", "Ljava/util/jar/JarOutputStream;", "entry", "Ljava/util/zip/ZipEntry;", "getUnusedResourceCount", "", "removeResourceUnusedTableEntries", "srcEntry", "replaceWithDummyEntry", "format", "Lcom/android/build/gradle/internal/res/shrinker/LinkedResourcesFormat;", "rewriteResourceZip", "source", "Ljava/io/File;", "dest", "Lcom/android/build/gradle/internal/res/shrinker/ArchiveFormat;", "rewriteResourcesInApkFormat", "rewriteResourcesInBundleFormat", "moduleNameToPackageNameMap", "", "", "gradle-core"})
public final class ResourceShrinkerImpl
implements ResourceShrinker {
    @NotNull
    private final ResourceShrinkerModel model;
    private List<? extends ResourceUsageModel.Resource> unused;
    private final List<ResourcesGatherer> resourcesGatherers;
    private final ObfuscationMappingsRecorder obfuscationMappingsRecorder;
    private final List<ResourceUsageRecorder> usageRecorders;
    private final List<ResourcesGraphBuilder> graphBuilders;
    private final ShrinkerDebugReporter debugReporter;
    private final boolean supportMultipackages;
    private final boolean usePreciseShrinking;

    @NotNull
    public final ResourceShrinkerModel getModel() {
        return this.model;
    }

    @Override
    public void analyze() {
        Object it;
        Iterable $this$forEach$iv = this.resourcesGatherers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourcesGatherer)element$iv;
            boolean bl = false;
            it.gatherResourceValues(this.model);
        }
        ObfuscationMappingsRecorder obfuscationMappingsRecorder = this.obfuscationMappingsRecorder;
        if (obfuscationMappingsRecorder != null) {
            obfuscationMappingsRecorder.recordObfuscationMappings(this.model);
        }
        $this$forEach$iv = this.usageRecorders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourceUsageRecorder)element$iv;
            boolean bl = false;
            it.recordUsages(this.model);
        }
        $this$forEach$iv = this.graphBuilders;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ResourcesGraphBuilder)element$iv;
            boolean bl = false;
            it.buildGraph(this.model);
        }
        this.model.getResourceStore().processToolsAttributes();
        this.model.keepPossiblyReferencedResources();
        this.debugReporter.debug((Function0<String>)((Function0)new Function0<String>(this){
            final /* synthetic */ ResourceShrinkerImpl this$0;

            @NotNull
            public final String invoke() {
                return this.this$0.getModel().getResourceStore().dumpResourceModel();
            }
            {
                this.this$0 = resourceShrinkerImpl;
                super(0);
            }
        }));
        this.unused = ResourcesUtil.findUnusedResources((List)this.model.getResourceStore().getResources(), (Function1)((Function1)new Function1<List<? extends ResourceUsageModel.Resource>, Unit>(this){
            final /* synthetic */ ResourceShrinkerImpl this$0;

            public final void invoke(@NotNull List<? extends ResourceUsageModel.Resource> roots) {
                Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
                ResourceShrinkerImpl.access$getDebugReporter$p(this.this$0).debug((Function0<String>)((Function0)analyze.1.INSTANCE));
                ResourceShrinkerImpl.access$getDebugReporter$p(this.this$0).debug((Function0<String>)((Function0)new Function0<String>(roots){
                    final /* synthetic */ List $roots;

                    @NotNull
                    public final String invoke() {
                        return CollectionsKt.joinToString$default((Iterable)this.$roots, (CharSequence)"\n", null, null, (int)0, null, (Function1)analyze.1.INSTANCE, (int)30, null);
                    }
                    {
                        this.$roots = list;
                        super(0);
                    }
                }));
            }
            {
                this.this$0 = resourceShrinkerImpl;
                super(1);
            }
        }));
    }

    @Override
    public void close() {
        this.debugReporter.close();
    }

    @Override
    public int getUnusedResourceCount() {
        List<? extends ResourceUsageModel.Resource> list = this.unused;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"unused");
        }
        return list.size();
    }

    @Override
    public void rewriteResourcesInApkFormat(@NotNull File source, @NotNull File dest, @NotNull LinkedResourcesFormat format) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
        ResourceStore resourceStore = this.model.getResourceStore();
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceStore, (String)"model.resourceStore");
        this.rewriteResourceZip(source, dest, new ApkArchiveFormat(resourceStore, format));
    }

    @Override
    public void rewriteResourcesInBundleFormat(@NotNull File source, @NotNull File dest, @NotNull Map<String, String> moduleNameToPackageNameMap) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        Intrinsics.checkParameterIsNotNull(moduleNameToPackageNameMap, (String)"moduleNameToPackageNameMap");
        ResourceStore resourceStore = this.model.getResourceStore();
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceStore, (String)"model.resourceStore");
        this.rewriteResourceZip(source, dest, new BundleArchiveFormat(resourceStore, moduleNameToPackageNameMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rewriteResourceZip(File source, File dest, ArchiveFormat format) {
        if (dest.exists() && !dest.delete()) {
            throw (Throwable)new IOException("Could not delete " + dest);
        }
        Closeable closeable = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
        boolean bl = false;
        Throwable throwable = null;
        try {
            JarOutputStream zos = (JarOutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new ZipFile(source);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                ZipFile zip = (ZipFile)closeable2;
                boolean bl4 = false;
                zos.setLevel(9);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zip.entries()");
                Enumeration<? extends ZipEntry> enumeration2 = enumeration;
                boolean bl5 = false;
                Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    boolean bl6 = false;
                    ZipEntry zipEntry = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"it");
                    if (format.fileIsNotReachable(zipEntry)) {
                        if (this.usePreciseShrinking) continue;
                        this.replaceWithDummyEntry(zos, it, format.getResourcesFormat());
                        continue;
                    }
                    String string = it.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                    if (StringsKt.endsWith$default((String)string, (String)"resources.pb", (boolean)false, (int)2, null) && this.usePreciseShrinking) {
                        InputStream inputStream = zip.getInputStream(it);
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zip.getInputStream(it)");
                        this.removeResourceUnusedTableEntries(inputStream, zos, it);
                        continue;
                    }
                    InputStream inputStream = zip.getInputStream(it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"zip.getInputStream(it)");
                    this.copyToOutput(inputStream, zos, it);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        long before = source.length();
        long after = dest.length();
        if (after > before) {
            this.debugReporter.info((Function0<String>)((Function0)new Function0<String>(before, after){
                final /* synthetic */ long $before;
                final /* synthetic */ long $after;

                @NotNull
                public final String invoke() {
                    return "Resource shrinking did not work (grew from " + this.$before + " to " + this.$after + "); using original " + "instead";
                }
                {
                    this.$before = l;
                    this.$after = l2;
                    super(0);
                }
            }));
            Files.copy((File)source, (File)dest);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeResourceUnusedTableEntries(InputStream zis, JarOutputStream zos, ZipEntry srcEntry) {
        void $this$mapTo$iv$iv;
        ResourceUsageModel.Resource it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.model.getResourceStore().getResources();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ResourceUsageModel.Resource)element$iv$iv;
            boolean bl = false;
            if (!(!it.isReachable())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ResourceUsageModel.Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.value;
            collection.add(n);
        }
        List resourceIdsToRemove = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Resources.ResourceTable resourceTable = Resources.ResourceTable.parseFrom((InputStream)zis);
        Intrinsics.checkExpressionValueIsNotNull((Object)resourceTable, (String)"Resources.ResourceTable.parseFrom(zis)");
        Resources.ResourceTable shrunkenResourceTable = ResourceTableUtilKt.nullOutEntriesWithIds(resourceTable, resourceIdsToRemove);
        byte[] bytes2 = shrunkenResourceTable.toByteArray();
        JarEntry outEntry = new JarEntry(srcEntry.getName());
        if (srcEntry.getTime() != -1L) {
            outEntry.setTime(srcEntry.getTime());
        }
        if (srcEntry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(bytes2.length);
            CRC32 crc = new CRC32();
            crc.update(bytes2, 0, bytes2.length);
            outEntry.setCrc(crc.getValue());
        }
        zos.putNextEntry(outEntry);
        zos.write(bytes2);
        zos.closeEntry();
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceWithDummyEntry(JarOutputStream zos, ZipEntry entry, LinkedResourcesFormat format) {
        void bytes2;
        String name2 = entry.getName();
        String string = name2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        Pair pair = StringsKt.endsWith$default((String)string, (String)".9.png", (boolean)false, (int)2, null) ? TuplesKt.to((Object)DummyContent.TINY_9PNG, (Object)289995143L) : (StringsKt.endsWith$default((String)name2, (String)".png", (boolean)false, (int)2, null) ? TuplesKt.to((Object)DummyContent.TINY_PNG, (Object)2293408688L) : (StringsKt.endsWith$default((String)name2, (String)".xml", (boolean)false, (int)2, null) && format == LinkedResourcesFormat.BINARY ? TuplesKt.to((Object)DummyContent.TINY_BINARY_XML, (Object)3622196803L) : (StringsKt.endsWith$default((String)name2, (String)".xml", (boolean)false, (int)2, null) && format == LinkedResourcesFormat.PROTO ? TuplesKt.to((Object)DummyContent.TINY_PROTO_XML, (Object)3204905971L) : TuplesKt.to((Object)new byte[0], (Object)0L))));
        byte[] byArray = (byte[])pair.component1();
        long crc = ((Number)pair.component2()).longValue();
        JarEntry outEntry = new JarEntry(name2);
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        if (entry.getMethod() == 0) {
            outEntry.setMethod(0);
            outEntry.setSize(((void)bytes2).length);
            outEntry.setCrc(crc);
        }
        zos.putNextEntry(outEntry);
        zos.write((byte[])bytes2);
        zos.closeEntry();
        this.debugReporter.info((Function0<String>)((Function0)new Function0<String>(name2, entry, (byte[])bytes2){
            final /* synthetic */ String $name;
            final /* synthetic */ ZipEntry $entry;
            final /* synthetic */ byte[] $bytes;

            @NotNull
            public final String invoke() {
                return "Skipped unused resource " + this.$name + ": " + this.$entry.getSize() + " bytes (replaced with small dummy file " + "of size " + this.$bytes.length + " bytes)";
            }
            {
                this.$name = string;
                this.$entry = zipEntry;
                this.$bytes = byArray;
                super(0);
            }
        }));
    }

    private final void copyToOutput(InputStream zis, JarOutputStream zos, ZipEntry entry) {
        JarEntry outEntry;
        switch (entry.getMethod()) {
            case 0: {
                JarEntry jarEntry = new JarEntry(entry);
                break;
            }
            default: {
                JarEntry jarEntry = outEntry = new JarEntry(entry.getName());
            }
        }
        if (entry.getTime() != -1L) {
            outEntry.setTime(entry.getTime());
        }
        zos.putNextEntry(outEntry);
        if (!entry.isDirectory()) {
            zos.write(ByteStreams.toByteArray((InputStream)zis));
        }
        zos.closeEntry();
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    public ResourceShrinkerImpl(@NotNull List<? extends ResourcesGatherer> resourcesGatherers, @Nullable ObfuscationMappingsRecorder obfuscationMappingsRecorder, @NotNull List<? extends ResourceUsageRecorder> usageRecorders, @NotNull List<? extends ResourcesGraphBuilder> graphBuilders, @NotNull ShrinkerDebugReporter debugReporter, boolean supportMultipackages, boolean usePreciseShrinking) {
        Intrinsics.checkParameterIsNotNull(resourcesGatherers, (String)"resourcesGatherers");
        Intrinsics.checkParameterIsNotNull(usageRecorders, (String)"usageRecorders");
        Intrinsics.checkParameterIsNotNull(graphBuilders, (String)"graphBuilders");
        Intrinsics.checkParameterIsNotNull((Object)debugReporter, (String)"debugReporter");
        this.resourcesGatherers = resourcesGatherers;
        this.obfuscationMappingsRecorder = obfuscationMappingsRecorder;
        this.usageRecorders = usageRecorders;
        this.graphBuilders = graphBuilders;
        this.debugReporter = debugReporter;
        this.supportMultipackages = supportMultipackages;
        this.usePreciseShrinking = usePreciseShrinking;
        this.model = new ResourceShrinkerModel(this.debugReporter, this.supportMultipackages);
    }

    public static final /* synthetic */ ShrinkerDebugReporter access$getDebugReporter$p(ResourceShrinkerImpl $this) {
        return $this.debugReporter;
    }
}

