/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutputHandler;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00124\u0010\n\u001a0\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0004\u0012\u00020\u00120\u000b\u00a2\u0006\u0002\u0010\u0013J$\u0010\n\u001a\u00020\u00182\u001c\u0010\u0019\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000eJ,\u0010\n\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u001c\u0010\u0019\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000eJ\u0006\u0010\u001c\u001a\u00020\u0000J\u0006\u0010\u001d\u001a\u00020\u0000J\u0006\u0010\u001e\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\n\u001a0\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00100\u000f\u0012\u0004\u0012\u00020\u00110\u000e\u0012\u0004\u0012\u00020\u00120\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/build/gradle/internal/cxx/process/ProcessOutputJunction;", "", "process", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "commandFile", "Ljava/io/File;", "stdoutFile", "stderrFile", "logPrefix", "", "execute", "Lkotlin/Function3;", "Lcom/android/ide/common/process/ProcessInfo;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "Lkotlin/Function1;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/BaseExecSpec;", "Lorg/gradle/process/ExecResult;", "Lcom/android/ide/common/process/ProcessResult;", "(Lcom/android/ide/common/process/ProcessInfoBuilder;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;Lkotlin/jvm/functions/Function3;)V", "isJavaProcess", "", "logErrorToLifecycle", "logOutputToInfo", "", "execOperations", "processHandler", "Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "javaProcess", "logStderrToLifecycle", "logStdoutToInfo", "gradle-core"})
public final class ProcessOutputJunction {
    private boolean logErrorToLifecycle;
    private boolean logOutputToInfo;
    private boolean isJavaProcess;
    private final ProcessInfoBuilder process;
    private final File commandFile;
    private final File stdoutFile;
    private final File stderrFile;
    private final String logPrefix;
    private final Function3<ProcessInfo, ProcessOutputHandler, Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>, ProcessResult> execute;

    @NotNull
    public final ProcessOutputJunction javaProcess() {
        this.isJavaProcess = true;
        return this;
    }

    @NotNull
    public final ProcessOutputJunction logStdoutToInfo() {
        this.logOutputToInfo = true;
        return this;
    }

    @NotNull
    public final ProcessOutputJunction logStderrToLifecycle() {
        this.logErrorToLifecycle = true;
        return this;
    }

    public final void execute(@NotNull DefaultProcessOutputHandler processHandler, @NotNull Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult> execOperations) {
        Intrinsics.checkParameterIsNotNull((Object)processHandler, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(execOperations, (String)"execOperations");
        this.commandFile.getParentFile().mkdirs();
        this.commandFile.delete();
        String string = this.process.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"process.toString()");
        LoggingEnvironmentKt.infoln(string, new Object[0]);
        String string2 = this.process.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"process.toString()");
        FilesKt.writeText$default((File)this.commandFile, (String)string2, null, (int)2, null);
        this.stderrFile.delete();
        this.stdoutFile.delete();
        try {
            ProcessInfo proc;
            ProcessInfo processInfo = proc = this.isJavaProcess ? (ProcessInfo)this.process.createJavaProcess() : this.process.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)processInfo, (String)"proc");
            ((ProcessResult)this.execute.invoke((Object)processInfo, (Object)processHandler, execOperations)).rethrowFailure().assertNormalExitValue();
        }
        catch (ProcessException e) {
            throw (Throwable)new BuildCommandException(StringsKt.trimMargin$default((String)("\n                |" + e.getMessage() + "\n                |" + FilesKt.readText$default((File)this.stdoutFile, null, (int)1, null) + "\n                |" + FilesKt.readText$default((File)this.stderrFile, null, (int)1, null) + "\n                "), null, (int)1, null));
        }
    }

    public final void execute(@NotNull Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult> execOperations) throws BuildCommandException, IOException {
        Intrinsics.checkParameterIsNotNull(execOperations, (String)"execOperations");
        DefaultProcessOutputHandler handler2 = new DefaultProcessOutputHandler(this.stderrFile, this.stdoutFile, this.logPrefix, this.logErrorToLifecycle, this.logOutputToInfo);
        this.execute(handler2, execOperations);
    }

    public ProcessOutputJunction(@NotNull ProcessInfoBuilder process2, @NotNull File commandFile, @NotNull File stdoutFile, @NotNull File stderrFile, @NotNull String logPrefix, @NotNull Function3<? super ProcessInfo, ? super ProcessOutputHandler, ? super Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>, ? extends ProcessResult> execute2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)commandFile, (String)"commandFile");
        Intrinsics.checkParameterIsNotNull((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkParameterIsNotNull((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkParameterIsNotNull((Object)logPrefix, (String)"logPrefix");
        Intrinsics.checkParameterIsNotNull(execute2, (String)"execute");
        this.process = process2;
        this.commandFile = commandFile;
        this.stdoutFile = stdoutFile;
        this.stderrFile = stderrFile;
        this.logPrefix = logPrefix;
        this.execute = execute2;
    }
}

