/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.ProcessApplicationManifest;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010$\u001a\u00020%2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020 2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0002J\"\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\b\b\u0002\u0010-\u001a\u00020 2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0007J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020(0,2\b\u0010*\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010/\u001a\u00020%2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020 R(\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\r@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R(\u0010\u0013\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR<\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u00192\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040\u0019@GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/DependencyResourcesComputer;", "", "()V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "extraGeneratedResFolders", "getExtraGeneratedResFolders", "()Lorg/gradle/api/file/FileCollection;", "setExtraGeneratedResFolders", "(Lorg/gradle/api/file/FileCollection;)V", "generatedResOutputDir", "getGeneratedResOutputDir", "setGeneratedResOutputDir", "Lorg/gradle/api/artifacts/ArtifactCollection;", "libraries", "getLibraries", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "setLibraries", "(Lorg/gradle/api/artifacts/ArtifactCollection;)V", "microApkResDirectory", "getMicroApkResDirectory", "setMicroApkResDirectory", "renderscriptResOutputDir", "getRenderscriptResOutputDir", "setRenderscriptResOutputDir", "", "", "resources", "getResources", "()Ljava/util/Map;", "setResources", "(Ljava/util/Map;)V", "", "validateEnabled", "getValidateEnabled", "()Z", "addLibraryResources", "", "resourceSetList", "", "Lcom/android/ide/common/resources/ResourceSet;", "resourceArePrecompiled", "aaptEnv", "compute", "", "precompileDependenciesResources", "getResSet", "initFromVariantScope", "creationConfig", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "includeDependencies", "gradle-core"})
public final class DependencyResourcesComputer {
    public Map<String, ? extends FileCollection> resources;
    @Nullable
    private ArtifactCollection libraries;
    public FileCollection renderscriptResOutputDir;
    public FileCollection generatedResOutputDir;
    @Nullable
    private FileCollection microApkResDirectory;
    @Nullable
    private FileCollection extraGeneratedResFolders;
    private boolean validateEnabled;

    @NotNull
    public final Map<String, FileCollection> getResources() {
        Map<String, FileCollection> map2 = this.resources;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        return map2;
    }

    @VisibleForTesting
    public final void setResources(@NotNull Map<String, ? extends FileCollection> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.resources = map2;
    }

    @Nullable
    public final ArtifactCollection getLibraries() {
        return this.libraries;
    }

    @VisibleForTesting
    public final void setLibraries(@Nullable ArtifactCollection artifactCollection) {
        this.libraries = artifactCollection;
    }

    @NotNull
    public final FileCollection getRenderscriptResOutputDir() {
        FileCollection fileCollection2 = this.renderscriptResOutputDir;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderscriptResOutputDir");
        }
        return fileCollection2;
    }

    @VisibleForTesting
    public final void setRenderscriptResOutputDir(@NotNull FileCollection fileCollection2) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection2, (String)"<set-?>");
        this.renderscriptResOutputDir = fileCollection2;
    }

    @NotNull
    public final FileCollection getGeneratedResOutputDir() {
        FileCollection fileCollection2 = this.generatedResOutputDir;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedResOutputDir");
        }
        return fileCollection2;
    }

    @VisibleForTesting
    public final void setGeneratedResOutputDir(@NotNull FileCollection fileCollection2) {
        Intrinsics.checkParameterIsNotNull((Object)fileCollection2, (String)"<set-?>");
        this.generatedResOutputDir = fileCollection2;
    }

    @Nullable
    public final FileCollection getMicroApkResDirectory() {
        return this.microApkResDirectory;
    }

    @VisibleForTesting
    public final void setMicroApkResDirectory(@Nullable FileCollection fileCollection2) {
        this.microApkResDirectory = fileCollection2;
    }

    @Nullable
    public final FileCollection getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    @VisibleForTesting
    public final void setExtraGeneratedResFolders(@Nullable FileCollection fileCollection2) {
        this.extraGeneratedResFolders = fileCollection2;
    }

    public final boolean getValidateEnabled() {
        return this.validateEnabled;
    }

    private final void addLibraryResources(ArtifactCollection libraries, List<ResourceSet> resourceSetList, boolean resourceArePrecompiled, String aaptEnv) {
        ArtifactCollection artifactCollection = libraries;
        if (artifactCollection != null) {
            ArtifactCollection artifactCollection2 = artifactCollection;
            boolean bl = false;
            boolean bl2 = false;
            ArtifactCollection it = artifactCollection2;
            boolean bl3 = false;
            Set libArtifacts = it.getArtifacts();
            Iterator iterator = libArtifacts.iterator();
            while (iterator.hasNext()) {
                ResolvedArtifactResult artifact;
                ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
                ResourceSet resourceSet = new ResourceSet(ProcessApplicationManifest.Companion.getArtifactName(resolvedArtifactResult), ResourceNamespace.RES_AUTO, null, this.validateEnabled, aaptEnv);
                resourceSet.setFromDependency(true);
                resourceSet.addSource(artifact.getFile());
                if (resourceArePrecompiled) {
                    resourceSet.setAllowedFolderPrefix("values");
                }
                resourceSetList.add(0, resourceSet);
            }
        }
    }

    @JvmOverloads
    @NotNull
    public final List<ResourceSet> compute(boolean precompileDependenciesResources, @Nullable String aaptEnv) {
        FileCollection it;
        boolean bl;
        List<ResourceSet> sourceFolderSets = this.getResSet(aaptEnv);
        int size = sourceFolderSets.size();
        ArtifactCollection artifactCollection = this.libraries;
        if (artifactCollection != null) {
            ArtifactCollection artifactCollection2 = artifactCollection;
            boolean bl2 = false;
            boolean bl3 = false;
            ArtifactCollection it2 = artifactCollection2;
            boolean bl4 = false;
            size += it2.getArtifacts().size();
        }
        ArrayList resourceSetList = new ArrayList(size);
        this.addLibraryResources(this.libraries, resourceSetList, precompileDependenciesResources, aaptEnv);
        resourceSetList.addAll(sourceFolderSets);
        ArrayList generatedResFolders = new ArrayList();
        FileCollection fileCollection2 = this.renderscriptResOutputDir;
        if (fileCollection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderscriptResOutputDir");
        }
        if (fileCollection2 != null) {
            FileCollection fileCollection3 = fileCollection2;
            boolean bl5 = false;
            bl = false;
            it = fileCollection3;
            boolean bl6 = false;
            generatedResFolders.addAll(it.getFiles());
        }
        FileCollection fileCollection4 = this.generatedResOutputDir;
        if (fileCollection4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedResOutputDir");
        }
        if (fileCollection4 != null) {
            FileCollection fileCollection5 = fileCollection4;
            boolean bl7 = false;
            bl = false;
            it = fileCollection5;
            boolean bl8 = false;
            generatedResFolders.addAll(it.getFiles());
        }
        FileCollection fileCollection6 = this.extraGeneratedResFolders;
        if (fileCollection6 != null) {
            FileCollection fileCollection7 = fileCollection6;
            boolean bl9 = false;
            bl = false;
            it = fileCollection7;
            boolean bl10 = false;
            generatedResFolders.addAll(it.getFiles());
        }
        FileCollection fileCollection8 = this.microApkResDirectory;
        if (fileCollection8 != null) {
            FileCollection fileCollection9 = fileCollection8;
            boolean bl11 = false;
            bl = false;
            it = fileCollection9;
            boolean bl12 = false;
            generatedResFolders.addAll(it.getFiles());
        }
        Collection collection = sourceFolderSets;
        boolean bl13 = false;
        if (!collection.isEmpty()) {
            ResourceSet mainResourceSet = sourceFolderSets.get(0);
            bl13 = Intrinsics.areEqual((Object)mainResourceSet.getConfigName(), (Object)"main") || Intrinsics.areEqual((Object)mainResourceSet.getConfigName(), (Object)"androidTest");
            bl = false;
            boolean bl14 = false;
            if (_Assertions.ENABLED && !bl13) {
                boolean bl15 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            mainResourceSet.addSources((Collection)generatedResFolders);
        }
        return resourceSetList;
    }

    public static /* synthetic */ List compute$default(DependencyResourcesComputer dependencyResourcesComputer, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return dependencyResourcesComputer.compute(bl, string);
    }

    @JvmOverloads
    @NotNull
    public final List<ResourceSet> compute(@Nullable String aaptEnv) {
        return DependencyResourcesComputer.compute$default(this, false, aaptEnv, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceSet> getResSet(String aaptEnv) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Map<String, ? extends FileCollection> map2 = this.resources;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resources");
        }
        if (map2 != null) {
            Map<String, ? extends FileCollection> map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ? extends FileCollection> it = map3;
            boolean bl3 = false;
            Object object = it;
            boolean bl4 = false;
            Iterator<Map.Entry<String, ? extends FileCollection>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, ? extends FileCollection> entry;
                Map.Entry<String, ? extends FileCollection> entry2 = entry = iterator.next();
                boolean bl5 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl5 = false;
                FileCollection value = entry2.getValue();
                ResourceSet resourceSet = new ResourceSet((String)key, ResourceNamespace.RES_AUTO, null, this.validateEnabled, aaptEnv);
                resourceSet.addSources((Collection)value.getFiles());
                builder.add((Object)resourceSet);
            }
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (List)immutableList;
    }

    public final void initFromVariantScope(@NotNull ComponentCreationConfig creationConfig, boolean includeDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        GlobalScope globalScope = creationConfig.getGlobalScope();
        BaseVariantData variantData = creationConfig.getVariantData();
        Project project = globalScope.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"globalScope.project");
        Project project2 = project;
        VariantPathHelper paths = creationConfig.getPaths();
        boolean bl = this.validateEnabled = !globalScope.getProjectOptions().get(BooleanOption.DISABLE_RESOURCE_VALIDATION);
        if (includeDependencies) {
            this.libraries = VariantDependencies.getArtifactCollection$default(creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.ANDROID_RES, null, 8, null);
        }
        this.resources = variantData.getAndroidResources();
        this.extraGeneratedResFolders = (FileCollection)variantData.getExtraGeneratedResFolders();
        ConfigurableFileCollection configurableFileCollection = project2.files(new Object[]{paths.getRenderscriptResOutputDir()});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files(paths.renderscriptResOutputDir)");
        this.renderscriptResOutputDir = (FileCollection)configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = project2.files(new Object[]{paths.getGeneratedResOutputDir()});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"project.files(paths.generatedResOutputDir)");
        this.generatedResOutputDir = (FileCollection)configurableFileCollection2;
        if (creationConfig.getTaskContainer().getMicroApkTask() != null && creationConfig.getVariantDslInfo().isEmbedMicroApp()) {
            this.microApkResDirectory = (FileCollection)project2.files(new Object[]{paths.getMicroApkResDirectory()});
        }
    }
}

