/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.tasks.AnalyzeDependenciesTask;
import com.android.build.gradle.tasks.ClassFinder;
import com.android.build.gradle.tasks.DependenciesUsageReport;
import com.android.build.gradle.tasks.DependencyGraphAnalyzer;
import com.android.build.gradle.tasks.DependencyUsageFinder;
import com.android.build.gradle.tasks.ResourcesFinder;
import com.android.utils.FileUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/tasks/DependencyUsageReporter;", "", "variantClasses", "Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantClassesHolder;", "variantDependencies", "Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantDependenciesHolder;", "classFinder", "Lcom/android/build/gradle/tasks/ClassFinder;", "resourceFinder", "Lcom/android/build/gradle/tasks/ResourcesFinder;", "depsUsageFinder", "Lcom/android/build/gradle/tasks/DependencyUsageFinder;", "graphAnalyzer", "Lcom/android/build/gradle/tasks/DependencyGraphAnalyzer;", "(Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantClassesHolder;Lcom/android/build/gradle/tasks/AnalyzeDependenciesTask$VariantDependenciesHolder;Lcom/android/build/gradle/tasks/ClassFinder;Lcom/android/build/gradle/tasks/ResourcesFinder;Lcom/android/build/gradle/tasks/DependencyUsageFinder;Lcom/android/build/gradle/tasks/DependencyGraphAnalyzer;)V", "writeMisconfiguredDependencies", "", "destinationFile", "Ljava/io/File;", "writeToFile", "output", "writeUnusedDependencies", "gradle-core"})
public final class DependencyUsageReporter {
    private final AnalyzeDependenciesTask.VariantClassesHolder variantClasses;
    private final AnalyzeDependenciesTask.VariantDependenciesHolder variantDependencies;
    private final ClassFinder classFinder;
    private final ResourcesFinder resourceFinder;
    private final DependencyUsageFinder depsUsageFinder;
    private final DependencyGraphAnalyzer graphAnalyzer;

    public final void writeUnusedDependencies(@NotNull File destinationFile) {
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        List toRemove = CollectionsKt.sorted((Iterable)SetsKt.minus((Set)CollectionsKt.intersect((Iterable)this.depsUsageFinder.getUnusedDirectDependencies(), (Iterable)this.graphAnalyzer.getRenderableDependencies().keySet()), (Iterable)this.resourceFinder.findUsedDependencies()));
        List toAdd = CollectionsKt.sorted((Iterable)this.graphAnalyzer.findIndirectRequiredDependencies());
        DependenciesUsageReport report = new DependenciesUsageReport(toAdd, toRemove);
        this.writeToFile(report, destinationFile);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMisconfiguredDependencies(@NotNull File destinationFile) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Iterable $this$mapNotNull$iv = this.variantClasses.getPublicClasses();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.classFinder.find(it) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set apiDependencies = CollectionsKt.intersect((Iterable)((List)destination$iv$iv), (Iterable)this.variantDependencies.getApi());
        Set misconfiguredDependencies = SetsKt.minus(this.variantDependencies.getApi(), (Iterable)apiDependencies);
        this.writeToFile(misconfiguredDependencies, destinationFile);
    }

    private final void writeToFile(Object output2, File destinationFile) {
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        FileUtils.writeToFile((File)destinationFile, (String)gson2.toJson(output2));
    }

    public DependencyUsageReporter(@NotNull AnalyzeDependenciesTask.VariantClassesHolder variantClasses, @NotNull AnalyzeDependenciesTask.VariantDependenciesHolder variantDependencies, @NotNull ClassFinder classFinder, @NotNull ResourcesFinder resourceFinder, @NotNull DependencyUsageFinder depsUsageFinder, @NotNull DependencyGraphAnalyzer graphAnalyzer) {
        Intrinsics.checkParameterIsNotNull((Object)variantClasses, (String)"variantClasses");
        Intrinsics.checkParameterIsNotNull((Object)variantDependencies, (String)"variantDependencies");
        Intrinsics.checkParameterIsNotNull((Object)classFinder, (String)"classFinder");
        Intrinsics.checkParameterIsNotNull((Object)resourceFinder, (String)"resourceFinder");
        Intrinsics.checkParameterIsNotNull((Object)depsUsageFinder, (String)"depsUsageFinder");
        Intrinsics.checkParameterIsNotNull((Object)graphAnalyzer, (String)"graphAnalyzer");
        this.variantClasses = variantClasses;
        this.variantDependencies = variantDependencies;
        this.classFinder = classFinder;
        this.resourceFinder = resourceFinder;
        this.depsUsageFinder = depsUsageFinder;
        this.graphAnalyzer = graphAnalyzer;
    }
}

