/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigDataProvider;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.build.gradle.internal.tasks.BundleToStandaloneApkTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.utils.FileUtils;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "bundle", "Lorg/gradle/api/file/RegularFileProperty;", "getBundle", "()Lorg/gradle/api/file/RegularFileProperty;", "fileName", "", "getFileName", "()Ljava/lang/String;", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "outputFile", "getOutputFile", "<set-?>", "Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "signingConfigData", "getSigningConfigData", "()Lcom/android/build/gradle/internal/signing/SigningConfigDataProvider;", "tempDirectory", "doTaskAction", "", "BundleToolRunnable", "CreationAction", "Params", "gradle-core"})
public abstract class BundleToStandaloneApkTask
extends NonIncrementalTask {
    private File tempDirectory;
    @NotNull
    private SigningConfigDataProvider signingConfigData;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getBundle();

    @Nested
    @NotNull
    public abstract Aapt2Input getAapt2();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @OutputDirectory
    @NotNull
    public final File getOutputDirectory() {
        Object object = this.getOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile.get().asFile");
        File file2 = file.getParentFile();
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        return file2;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Object object = this.getOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputFile.get()");
        File file = ((RegularFile)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputFile.get().asFile");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.get().asFile.name");
        return string;
    }

    @Nested
    @NotNull
    public final SigningConfigDataProvider getSigningConfigData() {
        SigningConfigDataProvider signingConfigDataProvider = this.signingConfigData;
        if (signingConfigDataProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfigData");
        }
        return signingConfigDataProvider;
    }

    @Override
    protected void doTaskAction() {
        this.getWorkerExecutor().noIsolation().submit(BundleToolRunnable.class, (Action)new Action<Params>(this){
            final /* synthetic */ BundleToStandaloneApkTask this$0;

            public final void execute(Params it) {
                block0: {
                    it.initializeFromAndroidVariantTask(this.this$0);
                    it.getBundleFile().set((Provider)this.this$0.getBundle());
                    it.getAapt2File().set((Object)Aapt2Daemon.getAapt2Executable(this.this$0.getAapt2()).toFile());
                    it.getOutputFile().set((Provider)this.this$0.getOutputFile());
                    it.getTemporaryDir().set((Object)BundleToStandaloneApkTask.access$getTempDirectory$p(this.this$0));
                    SigningConfigData signingConfigData = this.this$0.getSigningConfigData().resolve();
                    if (signingConfigData == null) break block0;
                    SigningConfigData signingConfigData2 = signingConfigData;
                    boolean bl = false;
                    boolean bl2 = false;
                    SigningConfigData config2 = signingConfigData2;
                    boolean bl3 = false;
                    it.getKeystoreFile().set((Object)config2.getStoreFile());
                    it.getKeystorePassword().set((Object)config2.getStorePassword());
                    it.getKeyAlias().set((Object)config2.getKeyAlias());
                    it.getKeyPassword().set((Object)config2.getKeyPassword());
                }
            }
            {
                this.this$0 = bundleToStandaloneApkTask;
            }
        });
    }

    public static final /* synthetic */ File access$getTempDirectory$p(BundleToStandaloneApkTask $this) {
        File file = $this.tempDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tempDirectory");
        }
        return file;
    }

    public static final /* synthetic */ SigningConfigDataProvider access$getSigningConfigData$p(BundleToStandaloneApkTask $this) {
        SigningConfigDataProvider signingConfigDataProvider = $this.signingConfigData;
        if (signingConfigDataProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfigData");
        }
        return signingConfigDataProvider;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0012\u0010\u0015\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "aapt2File", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getAapt2File", "()Lorg/gradle/api/provider/Property;", "bundleFile", "Lorg/gradle/api/file/RegularFileProperty;", "getBundleFile", "()Lorg/gradle/api/file/RegularFileProperty;", "keyAlias", "", "getKeyAlias", "keyPassword", "getKeyPassword", "keystoreFile", "getKeystoreFile", "keystorePassword", "getKeystorePassword", "outputFile", "getOutputFile", "temporaryDir", "getTemporaryDir", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract RegularFileProperty getBundleFile();

        @NotNull
        public abstract Property<File> getAapt2File();

        @NotNull
        public abstract RegularFileProperty getOutputFile();

        @NotNull
        public abstract Property<File> getTemporaryDir();

        @NotNull
        public abstract Property<File> getKeystoreFile();

        @NotNull
        public abstract Property<String> getKeystorePassword();

        @NotNull
        public abstract Property<String> getKeyAlias();

        @NotNull
        public abstract Property<String> getKeyPassword();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask$BundleToolRunnable;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask$Params;", "()V", "extractUniversalApk", "", "outputApksBundle", "Ljava/nio/file/Path;", "generateUniversalApkBundle", "run", "gradle-core"})
    public static abstract class BundleToolRunnable
    extends ProfileAwareWorkAction<Params> {
        @Override
        public void run() {
            Path outputApksBundle;
            Object object = ((Params)this.getParameters()).getOutputFile().getAsFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.outputFile.asFile.get()");
            FileUtils.cleanOutputDir((File)((File)object).getParentFile());
            FileUtils.cleanOutputDir((File)((File)((Params)this.getParameters()).getTemporaryDir().get()));
            Path path = outputApksBundle = ((File)((Params)this.getParameters()).getTemporaryDir().get()).toPath().resolve("universal_bundle.apks");
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"outputApksBundle");
            this.generateUniversalApkBundle(path);
            this.extractUniversalApk(outputApksBundle);
        }

        private final void generateUniversalApkBundle(Path outputApksBundle) {
            BuildApksCommand.Builder builder = BuildApksCommand.builder().setExecutorService(MoreExecutors.listeningDecorator((ExecutorService)ForkJoinPool.commonPool())).setBundlePath(((File)((Params)this.getParameters()).getBundleFile().getAsFile().get()).toPath()).setOutputFile(outputApksBundle).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)((File)((Params)this.getParameters()).getAapt2File().get()).toPath()));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"BuildApksCommand\n       \u2026      )\n                )");
            BuildApksCommand.Builder command = BundleTaskUtil.setSigningConfiguration(builder, (File)((Params)this.getParameters()).getKeystoreFile().getOrNull(), (String)((Params)this.getParameters()).getKeystorePassword().getOrNull(), (String)((Params)this.getParameters()).getKeyAlias().getOrNull(), (String)((Params)this.getParameters()).getKeyPassword().getOrNull());
            command.setApkBuildMode(BuildApksCommand.ApkBuildMode.UNIVERSAL);
            command.build().execute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void extractUniversalApk(Path outputApksBundle) {
            InputStream inputStream = Files.newInputStream(outputApksBundle, new OpenOption[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"Files.newInputStream(outputApksBundle)");
            Closeable closeable = inputStream;
            int n = 8192;
            boolean bl = false;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            n = 0;
            Throwable throwable = null;
            try {
                ZipInputStream zipInputStream = (ZipInputStream)closeable;
                boolean bl2 = false;
                boolean found = false;
                while (zipInputStream.getNextEntry() != null) {
                    ZipEntry entry;
                    String string = entry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".apk", (boolean)false, (int)2, null)) continue;
                    if (found) {
                        throw (Throwable)new IOException("Expected bundle to contain the single universal apk, but contained multiple: " + outputApksBundle);
                    }
                    Files.copy(zipInputStream, ((File)((Params)this.getParameters()).getOutputFile().getAsFile().get()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    found = true;
                }
                if (!found) {
                    throw (Throwable)new IOException("Expected bundle to contain the single universal apk, but contained none: " + outputApksBundle);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/BundleToStandaloneApkTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<BundleToStandaloneApkTask, VariantCreationConfig> {
        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("package", "UniversalApk");
        }

        @Override
        @NotNull
        public Class<BundleToStandaloneApkTask> getType() {
            return BundleToStandaloneApkTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<BundleToStandaloneApkTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            String suffix = ((VariantCreationConfig)this.creationConfig).getVariantDslInfo().isSigningReady() ? ".apk" : "-unsigned.apk";
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)BundleToStandaloneApkTask$CreationAction$handleProvider$1.INSTANCE).withName(((VariantCreationConfig)this.creationConfig).getGlobalScope().getProjectBaseName() + '-' + ((VariantCreationConfig)this.creationConfig).getBaseName() + "-universal" + suffix).on(InternalArtifactType.UNIVERSAL_APK.INSTANCE);
        }

        @Override
        public void configure(@NotNull BundleToStandaloneApkTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.INTERMEDIARY_BUNDLE.INSTANCE, (Property)task.getBundle());
            ((VariantCreationConfig)this.creationConfig).getServices().initializeAapt2Input(task.getAapt2());
            task.tempDirectory = ((VariantCreationConfig)this.creationConfig).getPaths().getIncrementalDir(this.getName());
            task.signingConfigData = SigningConfigDataProvider.Companion.create(this.creationConfig);
        }

        public CreationAction(@NotNull VariantCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
        }
    }
}

