/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\t"}, d2={"getApkFiles", "", "Ljava/nio/file/Path;", "apkBundle", "device", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "moduleName", "", "getDeviceJson", "gradle-core"})
@JvmName(name="BundleInstallUtils")
public final class BundleInstallUtils {
    @NotNull
    public static final Path getDeviceJson(@NotNull DeviceConfigProvider device) {
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Object object = device.getApiCodeName();
        if (object == null) {
            object = device.getApiLevel();
        }
        String api = object;
        int density = device.getDensity();
        List abis = device.getAbis();
        Set languages = device.getLanguageSplits();
        Path path = Files.createTempFile("apkSelect", "", new FileAttribute[0]);
        boolean bl = false;
        boolean bl2 = false;
        Path $this$apply = path;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder().append("{\n").append("  \"supportedAbis\": [");
        List list = abis;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"abis");
        String json = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)).append("],\n").append("  \"screenDensity\": ").append(density).append(",\n").append("  \"sdkVersion\": ").append((Object)api).toString();
        if (languages != null && !languages.isEmpty()) {
            json = json + ",\n  \"supportedLocales\": [ " + Joiner.on((char)',').join((Iterable)languages) + " ]\n";
        }
        String string = json = json + '}';
        Charset charset = Charsets.UTF_8;
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write($this$apply, byArray, new OpenOption[0]);
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Files.createTempFile(\"ap\u2026ay(Charsets.UTF_8))\n    }");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> getApkFiles(@NotNull Path apkBundle, @NotNull DeviceConfigProvider device, @Nullable String moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)apkBundle, (String)"apkBundle");
        Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
        Path jsonFile = BundleInstallUtils.getDeviceJson(device);
        Path path = Files.createTempDirectory("apkSelect", new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Files.createTempDirectory(\"apkSelect\")");
        Path tempFolder = path;
        Devices.DeviceSpec.Builder builder = Devices.DeviceSpec.newBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"Devices.DeviceSpec.newBuilder()");
        Devices.DeviceSpec.Builder builder2 = builder;
        Closeable closeable = Files.newBufferedReader(jsonFile, Charsets.UTF_8);
        boolean bl = false;
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl2 = false;
            JsonFormat.parser().merge((Reader)it, (Message.Builder)builder2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ExtractApksCommand.Builder command = ExtractApksCommand.builder().setApksArchivePath(apkBundle).setDeviceSpec(builder2.build()).setOutputDirectory(tempFolder);
        String string = moduleName;
        if (string != null) {
            String string2 = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string2;
            boolean bl5 = false;
            command.setModules(ImmutableSet.of((Object)it));
        }
        ImmutableList immutableList = command.build().execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"command.build().execute()");
        return (List)immutableList;
    }

    public static /* synthetic */ List getApkFiles$default(Path path, DeviceConfigProvider deviceConfigProvider, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return BundleInstallUtils.getApkFiles(path, deviceConfigProvider, string);
    }
}

