/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.AnalyticsService;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProjectData;
import com.android.build.gradle.internal.profile.TaskMetadata;
import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.profile.AnalyticsProfileWriter;
import com.android.builder.profile.NameAnonymizer;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u0002022\u0006\u00106\u001a\u000207J\b\u00108\u001a\u00020\u001dH\u0002J\b\u00109\u001a\u00020\u001dH\u0002J\b\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u0006J\u0010\u0010E\u001a\u0002002\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0018\u0010H\u001a\u00020\u00062\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u0006H\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u0006H\u0002J\u0010\u0010O\u001a\u0004\u0018\u00010,2\u0006\u0010G\u001a\u00020\u0006J\u0012\u0010P\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0016\u0010Q\u001a\u00020R2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010S\u001a\u00020\u0006J\u001a\u0010T\u001a\u0002002\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010U\u001a\u0004\u0018\u00010\u00062\u0006\u0010G\u001a\u00020\u0006H\u0002J\u0017\u0010V\u001a\u0004\u0018\u00010\t2\u0006\u0010@\u001a\u00020AH\u0002\u00a2\u0006\u0002\u0010WJ\u000e\u0010X\u001a\u0002022\u0006\u0010Y\u001a\u00020\u000bJ(\u0010Z\u001a\u0002022\u0006\u0010[\u001a\u00020\\2\u0006\u0010D\u001a\u00020\u00062\b\u0010]\u001a\u0004\u0018\u00010\u00062\u0006\u0010^\u001a\u00020_J2\u0010`\u001a\u0002022\u0006\u0010[\u001a\u00020\\2\b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u00062\u0006\u0010^\u001a\u00020_J\u000e\u0010c\u001a\u0002022\u0006\u0010d\u001a\u00020(J\u000e\u0010e\u001a\u0002022\u0006\u0010f\u001a\u00020gJ\u0010\u0010h\u001a\u0002022\u0006\u0010f\u001a\u00020gH\u0002J\u0010\u0010i\u001a\u0002022\b\u0010j\u001a\u0004\u0018\u00010kJ\u0006\u0010l\u001a\u000202J.\u0010m\u001a\u0002022\u0006\u0010D\u001a\u00020\u00062\b\u0010S\u001a\u0004\u0018\u00010\u00062\u0006\u0010n\u001a\u00020o2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00150*R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0017R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010&\u001a&\u0012\f\u0012\n )*\u0004\u0018\u00010(0( )*\u0012\u0012\f\u0012\n )*\u0004\u0018\u00010(0(\u0018\u00010*0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020,0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lcom/android/build/gradle/internal/profile/AnalyticsResourceManager;", "", "profileBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;", "projects", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/android/build/gradle/internal/profile/ProjectData;", "enableProfileJson", "", "profileDir", "Ljava/io/File;", "taskMetadata", "Lcom/android/build/gradle/internal/profile/TaskMetadata;", "rootProjectPath", "(Lcom/google/wireless/android/sdk/stats/GradleBuildProfile$Builder;Ljava/util/concurrent/ConcurrentHashMap;ZLjava/io/File;Ljava/util/concurrent/ConcurrentHashMap;Ljava/lang/String;)V", "analyticsWriter", "Lcom/android/builder/profile/AnalyticsProfileWriter;", "applicationIds", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "configurationSpans", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan;", "getConfigurationSpans", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "executionSpans", "getExecutionSpans$annotations", "()V", "getExecutionSpans", "initialMemorySample", "Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "getInitialMemorySample", "()Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;", "setInitialMemorySample", "(Lcom/google/wireless/android/sdk/stats/GradleBuildMemorySample;)V", "lastRecordId", "Ljava/util/concurrent/atomic/AtomicLong;", "nameAnonymizer", "Lcom/android/builder/profile/NameAnonymizer;", "otherEvents", "", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "", "taskRecords", "Lcom/android/build/gradle/internal/profile/TaskProfilingRecord;", "threadRecorder", "Lcom/android/builder/profile/Recorder;", "allocateRecordId", "", "collectTaskMetadata", "", "graph", "Lorg/gradle/api/execution/TaskExecutionGraph;", "configureAnalyticsService", "params", "Lcom/android/build/gradle/internal/profile/AnalyticsService$Params;", "createAndRecordMemorySample", "createMemorySample", "getFinalProfile", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfile;", "getProfileDir", "Ljava/nio/file/Path;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "gradle", "Lorg/gradle/api/invocation/Gradle;", "getProjectBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildProject$Builder;", "projectPath", "getProjectId", "getProjectPath", "taskPath", "getSystemProperty", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "propertyName", "getTaskExecutionType", "Lcom/android/tools/build/gradle/internal/profile/GradleTaskExecutionType;", "taskName", "getTaskRecord", "getTypeName", "getVariantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "variantName", "getVariantId", "getVariantName", "isConfigCachingEnabled", "(Lorg/gradle/api/invocation/Gradle;)Ljava/lang/Boolean;", "recordApplicationId", "metadataFile", "recordBlockAtConfiguration", "executionType", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$ExecutionType;", "variant", "block", "Lcom/android/builder/profile/Recorder$VoidBlock;", "recordBlockAtExecution", "transform", "Lcom/google/wireless/android/sdk/stats/GradleTransformExecution;", "recordEvent", "event", "recordGlobalProperties", "project", "Lorg/gradle/api/Project;", "recordPlugins", "recordTaskExecutionSpan", "finishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "writeAndFinish", "writeRecord", "executionRecord", "Lcom/google/wireless/android/sdk/stats/GradleBuildProfileSpan$Builder;", "taskExecutionPhases", "gradle-core"})
public final class AnalyticsResourceManager {
    @NotNull
    private GradleBuildMemorySample initialMemorySample;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> configurationSpans;
    @NotNull
    private final ConcurrentLinkedQueue<GradleBuildProfileSpan> executionSpans;
    private final ConcurrentLinkedQueue<String> applicationIds;
    private final NameAnonymizer nameAnonymizer;
    private AtomicLong lastRecordId;
    private final ConcurrentHashMap<String, TaskProfilingRecord> taskRecords;
    private final List<AndroidStudioEvent.Builder> otherEvents;
    private final Recorder threadRecorder;
    private final AnalyticsProfileWriter analyticsWriter;
    private final GradleBuildProfile.Builder profileBuilder;
    private final ConcurrentHashMap<String, ProjectData> projects;
    private boolean enableProfileJson;
    private File profileDir;
    private final ConcurrentHashMap<String, TaskMetadata> taskMetadata;
    private String rootProjectPath;

    @NotNull
    public final GradleBuildMemorySample getInitialMemorySample() {
        return this.initialMemorySample;
    }

    public final void setInitialMemorySample(@NotNull GradleBuildMemorySample gradleBuildMemorySample) {
        Intrinsics.checkParameterIsNotNull((Object)gradleBuildMemorySample, (String)"<set-?>");
        this.initialMemorySample = gradleBuildMemorySample;
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getConfigurationSpans() {
        return this.configurationSpans;
    }

    @VisibleForTesting
    public static /* synthetic */ void getExecutionSpans$annotations() {
    }

    @NotNull
    public final ConcurrentLinkedQueue<GradleBuildProfileSpan> getExecutionSpans() {
        return this.executionSpans;
    }

    public final void writeAndFinish() {
        GradleBuildProfile gradleBuildProfile = this.getFinalProfile();
        List<AndroidStudioEvent.Builder> list = this.otherEvents;
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"otherEvents");
        this.analyticsWriter.writeAndFinish(gradleBuildProfile, list, this.profileDir, this.enableProfileJson);
    }

    @NotNull
    public final GradleBuildProject.Builder getProjectBuilder(@NotNull String projectPath) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        return this.projects.computeIfAbsent(projectPath, new Function<String, ProjectData>(this){
            final /* synthetic */ AnalyticsResourceManager this$0;

            @NotNull
            public final ProjectData apply(@NotNull String it) {
                GradleBuildProject.Builder projectBuilder;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GradleBuildProject.Builder builder = projectBuilder = GradleBuildProject.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"projectBuilder");
                builder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeProjectPath(it));
                return new ProjectData(projectBuilder);
            }
            {
                this.this$0 = analyticsResourceManager;
            }
        }).getProjectBuilder();
    }

    @NotNull
    public final GradleBuildVariant.Builder getVariantBuilder(@NotNull String projectPath, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        ProjectData projectData2 = this.projects.computeIfAbsent(projectPath, new Function<String, ProjectData>(this){
            final /* synthetic */ AnalyticsResourceManager this$0;

            @NotNull
            public final ProjectData apply(@NotNull String it) {
                GradleBuildProject.Builder projectBuilder;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GradleBuildProject.Builder builder = projectBuilder = GradleBuildProject.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"projectBuilder");
                builder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeProjectPath(it));
                return new ProjectData(projectBuilder);
            }
            {
                this.this$0 = analyticsResourceManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)projectData2, (String)"projects.computeIfAbsent\u2026projectBuilder)\n        }");
        ProjectData projectData3 = projectData2;
        GradleBuildVariant.Builder builder = projectData3.getVariantBuilders().computeIfAbsent(variantName, new Function<String, GradleBuildVariant.Builder>(this, projectPath){
            final /* synthetic */ AnalyticsResourceManager this$0;
            final /* synthetic */ String $projectPath;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GradleBuildVariant.Builder apply(@NotNull String it) {
                void var2_2;
                GradleBuildVariant.Builder variantBuilder;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                GradleBuildVariant.Builder builder = variantBuilder = GradleBuildVariant.newBuilder();
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"variantBuilder");
                builder.setId(AnalyticsResourceManager.access$getNameAnonymizer$p(this.this$0).anonymizeVariant(this.$projectPath, it));
                return var2_2;
            }
            {
                this.this$0 = analyticsResourceManager;
                this.$projectPath = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"projectData.variantBuild\u2026 variantBuilder\n        }");
        return builder;
    }

    @Nullable
    public final TaskProfilingRecord getTaskRecord(@NotNull String taskPath) {
        Intrinsics.checkParameterIsNotNull((Object)taskPath, (String)"taskPath");
        if (!this.taskRecords.containsKey(taskPath)) {
            GradleBuildProfileSpan.Builder builder = GradleBuildProfileSpan.newBuilder();
            boolean bl = false;
            boolean bl2 = false;
            GradleBuildProfileSpan.Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setType(GradleBuildProfileSpan.ExecutionType.TASK_EXECUTION);
            $this$apply.setId(this.allocateRecordId());
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            $this$apply.setThreadId(thread.getId());
            GradleBuildProfileSpan.Builder builder2 = builder;
            String string = this.getProjectPath(taskPath);
            if (string == null) {
                return null;
            }
            String projectPath = string;
            String variantName = this.getVariantName(taskPath);
            Map map2 = this.taskRecords;
            GradleBuildProfileSpan.Builder builder3 = builder2;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"builder");
            map2.put(taskPath, new TaskProfilingRecord(this, builder3, taskPath, projectPath, variantName));
        }
        return this.taskRecords.get(taskPath);
    }

    public final void recordTaskExecutionSpan(@Nullable FinishEvent finishEvent) {
        String taskPath;
        if (finishEvent == null || !(finishEvent instanceof TaskFinishEvent)) {
            return;
        }
        TaskOperationDescriptor taskOperationDescriptor = ((TaskFinishEvent)finishEvent).getDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskOperationDescriptor, (String)"finishEvent.descriptor");
        String string = taskPath = taskOperationDescriptor.getTaskPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"taskPath");
        TaskProfilingRecord taskProfilingRecord = this.getTaskRecord(string);
        if (taskProfilingRecord == null) {
            return;
        }
        TaskProfilingRecord taskRecord2 = taskProfilingRecord;
        String string2 = this.getTypeName(taskPath);
        if (string2 == null) {
            return;
        }
        String typeName = string2;
        GradleTaskExecutionType taskType = this.getTaskExecutionType(typeName);
        TaskOperationResult taskResult = ((TaskFinishEvent)finishEvent).getResult();
        taskRecord2.getSpanBuilder().getTaskBuilder().setType(taskType.getNumber()).setDidWork(!(taskResult instanceof TaskSkippedResult)).setSkipped(taskResult instanceof TaskSkippedResult).setUpToDate(taskResult instanceof TaskSuccessResult && ((TaskSuccessResult)taskResult).isUpToDate()).setFailed(taskResult instanceof TaskFailureResult);
        TaskOperationResult taskOperationResult = taskResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)taskOperationResult, (String)"taskResult");
        taskRecord2.setTaskStartTime(taskOperationResult.getStartTime());
        taskRecord2.setTaskEndTime(taskResult.getEndTime());
        taskRecord2.writeTaskSpan();
        this.createAndRecordMemorySample();
    }

    public final synchronized long allocateRecordId() {
        if (this.lastRecordId == null) {
            int spansCount = this.configurationSpans.size();
            this.lastRecordId = new AtomicLong(1 + spansCount);
        }
        AtomicLong atomicLong = this.lastRecordId;
        if (atomicLong == null) {
            Intrinsics.throwNpe();
        }
        return atomicLong.incrementAndGet();
    }

    public final void recordBlockAtConfiguration(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @NotNull String projectPath, @Nullable String variant, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)executionType, (String)"executionType");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variant)), Long.valueOf(this.allocateRecordId()), block);
        this.configurationSpans.add(span);
    }

    public final void recordBlockAtExecution(@NotNull GradleBuildProfileSpan.ExecutionType executionType, @Nullable GradleTransformExecution transform2, @NotNull String projectPath, @Nullable String variantName, @NotNull Recorder.VoidBlock block) {
        Intrinsics.checkParameterIsNotNull((Object)executionType, (String)"executionType");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        GradleBuildProfileSpan span = this.threadRecorder.record(executionType, transform2, Long.valueOf(this.getProjectId(projectPath)), Long.valueOf(this.getVariantId(projectPath, variantName)), Long.valueOf(this.allocateRecordId()), block);
        this.executionSpans.add(span);
    }

    public final void writeRecord(@NotNull String projectPath, @Nullable String variantName, @NotNull GradleBuildProfileSpan.Builder executionRecord, @NotNull List<GradleBuildProfileSpan> taskExecutionPhases) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)executionRecord, (String)"executionRecord");
        Intrinsics.checkParameterIsNotNull(taskExecutionPhases, (String)"taskExecutionPhases");
        long l = this.getProjectId(projectPath);
        boolean bl = false;
        boolean bl2 = false;
        long it = l;
        boolean bl3 = false;
        executionRecord.setProject(it);
        if (variantName == null) {
            executionRecord.setVariant(0L);
        } else {
            l = this.getVariantId(projectPath, variantName);
            bl = false;
            bl2 = false;
            it = l;
            boolean bl4 = false;
            executionRecord.setVariant(it);
        }
        this.executionSpans.add(executionRecord.build());
        Collection collection = taskExecutionPhases;
        bl = false;
        if (!collection.isEmpty()) {
            GradleBuildProfileSpan firstPhase = taskExecutionPhases.get(0);
            this.executionSpans.add(GradleBuildProfileSpan.newBuilder().setType(GradleBuildProfileSpan.ExecutionType.GRADLE_PRE_TASK_SPAN).setParentId(executionRecord.getId()).setThreadId(executionRecord.getThreadId()).setStartTimeInMs(executionRecord.getStartTimeInMs()).setDurationInMs(firstPhase.getStartTimeInMs() - executionRecord.getStartTimeInMs()).build());
        }
        this.executionSpans.addAll((Collection<GradleBuildProfileSpan>)taskExecutionPhases);
    }

    public final void configureAnalyticsService(@NotNull AnalyticsService.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        params.getProfile().set((Object)Base64.getEncoder().encodeToString(this.profileBuilder.build().toByteArray()));
        params.getProjects().set((Map)this.projects);
        params.getEnableProfileJson().set((Object)this.enableProfileJson);
        params.getProfileDir().set((Object)this.profileDir);
        params.getTaskMetadata().set((Map)this.taskMetadata);
        params.getRootProjectPath().set((Object)this.rootProjectPath);
    }

    public final void recordGlobalProperties(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        BuildServiceRegistry buildServiceRegistry = gradle.getSharedServices();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
        BuildServiceRegistry buildServiceRegistry$iv = buildServiceRegistry;
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(ProjectOptionService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
        ProjectOptions projectOptions = ((ProjectOptionService)provider2.get()).getProjectOptions();
        ProviderFactory providers = project.getProviders();
        this.recordPlugins(project);
        ProviderFactory providerFactory = providers;
        Intrinsics.checkExpressionValueIsNotNull((Object)providerFactory, (String)"providers");
        GradleBuildProfile.Builder builder = this.profileBuilder.setOsName(this.getSystemProperty(providerFactory, "os.version")).setOsVersion(this.getSystemProperty(providers, "os.version")).setJavaVersion(this.getSystemProperty(providers, "java.version")).setJavaVmVersion(this.getSystemProperty(providers, "java.vm.version")).setMaxMemory(Runtime.getRuntime().maxMemory());
        Gradle gradle2 = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle2, (String)"project.gradle");
        builder.setGradleVersion(Strings.nullToEmpty((String)gradle2.getGradleVersion()));
        Gradle gradle3 = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"project.gradle");
        Boolean configCachingEnabled = this.isConfigCachingEnabled(gradle3);
        if (configCachingEnabled != null) {
            this.profileBuilder.setConfigurationCachingEnabled(configCachingEnabled.booleanValue());
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File file = project2.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.rootProject.projectDir");
        this.rootProjectPath = file.getAbsolutePath();
        this.enableProfileJson = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        Gradle gradle4 = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle4, (String)"project.gradle");
        Path path = this.getProfileDir(projectOptions, gradle4);
        this.profileDir = path != null ? path.toFile() : null;
    }

    public final void collectTaskMetadata(@NotNull TaskExecutionGraph graph) {
        Intrinsics.checkParameterIsNotNull((Object)graph, (String)"graph");
        for (Task task : graph.getAllTasks()) {
            String string;
            if (task instanceof VariantAwareTask) {
                string = ((VariantAwareTask)task).getVariantName();
            } else {
                Task task2 = task;
                Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"task");
                string = (String)task2.getExtensions().findByName("AGP_VARIANT_NAME");
            }
            String variantName = string;
            Map map2 = this.taskMetadata;
            String string2 = task.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"task.path");
            Project project = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
            String string3 = project.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"task.project.path");
            String string4 = AnalyticsUtil.getPotentialTaskExecutionTypeName(task.getClass());
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"AnalyticsUtil.getPotenti\u2026nTypeName(task.javaClass)");
            map2.put(string2, new TaskMetadata(string3, variantName, string4));
        }
    }

    public final void recordEvent(@NotNull AndroidStudioEvent.Builder event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.otherEvents.add(event);
    }

    public final void recordApplicationId(@NotNull File metadataFile) {
        Intrinsics.checkParameterIsNotNull((Object)metadataFile, (String)"metadataFile");
        this.applicationIds.add(FilesKt.readText$default((File)metadataFile, null, (int)1, null));
    }

    private final long getProjectId(String projectPath) {
        Long id;
        ProjectData projectData2 = this.projects.get(projectPath);
        Long l = projectData2 != null && (projectData2 = projectData2.getProjectBuilder()) != null ? Long.valueOf(projectData2.getId()) : (id = null);
        if (id != null) {
            return id;
        }
        return this.nameAnonymizer.anonymizeProjectPath(projectPath);
    }

    /*
     * Unable to fully structure code
     */
    private final long getVariantId(String projectPath, String variantName) {
        v0 = this.projects.get(projectPath);
        if (v0 == null || (v0 = v0.getVariantBuilders()) == null) ** GOTO lbl-1000
        var4_3 = v0;
        var5_4 = false;
        v0 = (GradleBuildVariant.Builder)var4_3.get(variantName);
        if (v0 != null) {
            v1 = v0.getId();
        } else lbl-1000:
        // 2 sources

        {
            v1 = variantId = null;
        }
        if (variantId != null) {
            return variantId;
        }
        return this.nameAnonymizer.anonymizeVariant(projectPath, variantName);
    }

    private final String getProjectPath(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getProjectPath() : null;
    }

    private final String getVariantName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getVariantName() : null;
    }

    private final String getTypeName(String taskPath) {
        TaskMetadata taskMetadata = this.taskMetadata.get(taskPath);
        return taskMetadata != null ? taskMetadata.getTypeName() : null;
    }

    private final void recordPlugins(Project project) {
        project.getGradle().allprojects((Action)new Action<Project>(this){
            final /* synthetic */ AnalyticsResourceManager this$0;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                String string = project.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.path");
                GradleBuildProject.Builder projectBuilder = this.this$0.getProjectBuilder(string);
                PluginContainer pluginContainer = it.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginContainer, (String)"it.plugins");
                Iterable $this$forEach$iv = (Iterable)pluginContainer;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Plugin plugin = (Plugin)element$iv;
                    boolean bl = false;
                    projectBuilder.addPlugin(AnalyticsUtil.toProto(plugin));
                    projectBuilder.addPluginNames(plugin.getClass().getName());
                }
            }
            {
                this.this$0 = analyticsResourceManager;
            }
        });
    }

    private final GradleTaskExecutionType getTaskExecutionType(String taskName) {
        GradleTaskExecutionType gradleTaskExecutionType;
        try {
            gradleTaskExecutionType = GradleTaskExecutionType.valueOf((String)taskName);
        }
        catch (IllegalArgumentException ignored) {
            gradleTaskExecutionType = GradleTaskExecutionType.UNKNOWN_TASK_TYPE;
        }
        return gradleTaskExecutionType;
    }

    private final String getSystemProperty(ProviderFactory providerFactory, String propertyName) {
        Object object = providerFactory.systemProperty(propertyName).forUseAtConfigurationTime().orElse((Object)"").get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"providerFactory\n        \u2026se(\"\")\n            .get()");
        return (String)object;
    }

    private final GradleBuildProfile getFinalProfile() {
        String string;
        this.profileBuilder.addMemorySample(this.initialMemorySample);
        GradleBuildMemorySample endMemorySample = this.createAndRecordMemorySample();
        this.profileBuilder.addAllSpan((Iterable)this.configurationSpans);
        this.profileBuilder.addAllSpan((Iterable)this.executionSpans);
        Map $this$forEach$iv = this.projects;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            GradleBuildProject.Builder projectBuilder = ((ProjectData)it.getValue()).getProjectBuilder();
            Map<String, GradleBuildVariant.Builder> $this$forEach$iv2 = ((ProjectData)it.getValue()).getVariantBuilders();
            boolean $i$f$forEach2 = false;
            Map<String, GradleBuildVariant.Builder> map3 = $this$forEach$iv2;
            boolean bl3 = false;
            Iterator<Map.Entry<String, GradleBuildVariant.Builder>> iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, GradleBuildVariant.Builder> element$iv2;
                Map.Entry<String, GradleBuildVariant.Builder> entry = element$iv2 = iterator2.next();
                boolean bl4 = false;
                projectBuilder.addVariant(entry.getValue());
            }
            this.profileBuilder.addProject(projectBuilder);
        }
        this.profileBuilder.setBuildTime(endMemorySample.getTimestamp() - this.initialMemorySample.getTimestamp()).setGcCount(endMemorySample.getGcCount() - this.initialMemorySample.getGcCount()).setGcTime(endMemorySample.getGcTimeMs() - this.initialMemorySample.getGcTimeMs());
        try {
            LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AnalyticsResourceManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026ourceManager::class.java)");
            string = Anonymizer.anonymizeUtf8((ILogger)loggerWrapper, (String)this.rootProjectPath);
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        String anonymizedProjectId = string;
        this.profileBuilder.addAllRawProjectId((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)this.applicationIds)))).setProjectId(anonymizedProjectId);
        GradleBuildProfile gradleBuildProfile = this.profileBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleBuildProfile, (String)"profileBuilder.build()");
        return gradleBuildProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GradleBuildMemorySample createAndRecordMemorySample() {
        GradleBuildMemorySample stats = this.createMemorySample();
        GradleBuildProfile.Builder builder = this.profileBuilder;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (builder) {
            boolean bl3 = false;
            GradleBuildProfile.Builder builder2 = this.profileBuilder.addMemorySample(stats);
        }
        return stats;
    }

    private final GradleBuildMemorySample createMemorySample() {
        GradleBuildMemorySample gradleBuildMemorySample = GradleBuildMemorySample.newBuilder().setJavaProcessStats(CommonMetricsData.getJavaProcessStats()).setTimestamp(System.currentTimeMillis()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleBuildMemorySample, (String)"GradleBuildMemorySample.\u2026s())\n            .build()");
        return gradleBuildMemorySample;
    }

    private final Path getProfileDir(ProjectOptions projectOptions, Gradle gradle) {
        Path path;
        String profileDir = projectOptions.get(StringOption.PROFILE_OUTPUT_DIR);
        boolean enableJsonProfile = projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON);
        if (profileDir != null) {
            path = gradle.getRootProject().file((Object)profileDir).toPath();
        } else if (enableJsonProfile) {
            Project project = gradle.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"gradle.rootProject");
            path = project.getBuildDir().toPath().resolve("android-profile");
        } else {
            path = null;
        }
        return path;
    }

    private final Boolean isConfigCachingEnabled(Gradle gradle) {
        Boolean bl;
        try {
            StartParameter startParameter = gradle.getStartParameter();
            if (startParameter == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.StartParameterInternal");
            }
            StartParameterInternal startParameters = (StartParameterInternal)startParameter;
            bl = startParameters.isConfigurationCache();
        }
        catch (Throwable e) {
            LoggerWrapper.getLogger(AnalyticsResourceManager.class).warning("Unable to decide if config caching is enabled, details: %s", e.getMessage());
            return null;
        }
        return bl;
    }

    public AnalyticsResourceManager(@NotNull GradleBuildProfile.Builder profileBuilder, @NotNull ConcurrentHashMap<String, ProjectData> projects, boolean enableProfileJson, @Nullable File profileDir, @NotNull ConcurrentHashMap<String, TaskMetadata> taskMetadata, @Nullable String rootProjectPath) {
        Intrinsics.checkParameterIsNotNull((Object)profileBuilder, (String)"profileBuilder");
        Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
        Intrinsics.checkParameterIsNotNull(taskMetadata, (String)"taskMetadata");
        this.profileBuilder = profileBuilder;
        this.projects = projects;
        this.enableProfileJson = enableProfileJson;
        this.profileDir = profileDir;
        this.taskMetadata = taskMetadata;
        this.rootProjectPath = rootProjectPath;
        this.initialMemorySample = this.createMemorySample();
        this.configurationSpans = new ConcurrentLinkedQueue();
        this.executionSpans = new ConcurrentLinkedQueue();
        this.applicationIds = new ConcurrentLinkedQueue();
        this.nameAnonymizer = new NameAnonymizer();
        this.taskRecords = new ConcurrentHashMap();
        boolean bl = false;
        this.otherEvents = Collections.synchronizedList(new ArrayList());
        this.threadRecorder = (Recorder)new ThreadRecorder();
        this.analyticsWriter = new AnalyticsProfileWriter();
    }

    public static final /* synthetic */ NameAnonymizer access$getNameAnonymizer$p(AnalyticsResourceManager $this) {
        return $this.nameAnonymizer;
    }
}

