/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.generators;

import com.android.build.api.variant.impl.ResValue;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/generators/ResValueGenerator;", "", "genFolder", "Ljava/io/File;", "requests", "", "Lcom/android/build/api/variant/impl/ResValue$Key;", "Lcom/android/build/api/variant/impl/ResValue;", "(Ljava/io/File;Ljava/util/Map;)V", "folderPath", "generate", "", "Companion", "gradle-core"})
public final class ResValueGenerator {
    private final File folderPath;
    private final Map<ResValue.Key, ResValue> requests;
    @NotNull
    public static final String RES_VALUE_FILENAME_XML = "gradleResValues.xml";
    private static final List<ResourceType> RESOURCES_WITH_TAGS;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void generate() throws IOException, ParserConfigurationException {
        block9: {
            Object object;
            DocumentBuilderFactory factory2;
            File pkgFolder = this.folderPath;
            if (!pkgFolder.isDirectory() && !pkgFolder.mkdirs()) {
                throw (Throwable)new RuntimeException("Failed to create " + pkgFolder.getAbsolutePath());
            }
            File resFile = new File(pkgFolder, RES_VALUE_FILENAME_XML);
            DocumentBuilderFactory documentBuilderFactory = factory2 = DocumentBuilderFactory.newInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilderFactory, (String)"factory");
            documentBuilderFactory.setNamespaceAware(true);
            factory2.setValidating(false);
            factory2.setIgnoringComments(true);
            DocumentBuilder builder = factory2.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = document.createElement("resources");
            Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"document.createElement(SdkConstants.TAG_RESOURCES)");
            Node rootNode = element;
            document.appendChild(rootNode);
            rootNode.appendChild(document.createTextNode("\n"));
            rootNode.appendChild(document.createComment("Automatically generated file. DO NOT MODIFY"));
            rootNode.appendChild(document.createTextNode("\n\n"));
            Object object2 = this.requests;
            boolean bl = false;
            Iterator<Map.Entry<ResValue.Key, ResValue>> iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                Attr nameAttr;
                void key;
                Object object3 = object = iterator.next();
                boolean bl2 = false;
                object2 = object3.getKey();
                object3 = object;
                bl2 = false;
                ResValue value = (ResValue)object3.getValue();
                String string = value.getComment();
                if (string != null) {
                    object3 = string;
                    bl2 = false;
                    boolean bl3 = false;
                    Object it = object3;
                    boolean bl4 = false;
                    rootNode.appendChild(document.createTextNode("\n"));
                    rootNode.appendChild(document.createComment((String)it));
                    rootNode.appendChild(document.createTextNode("\n"));
                }
                String type = key.getType();
                ResourceType resourceType = ResourceType.fromClassName((String)type);
                if (resourceType == null && Intrinsics.areEqual((Object)"declare-styleable", (Object)type)) {
                    resourceType = ResourceType.STYLEABLE;
                }
                boolean hasResourceTag = resourceType != null && RESOURCES_WITH_TAGS.contains(resourceType);
                Element element2 = document.createElement(hasResourceTag ? type : "item");
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"document.createElement(i\u2026se SdkConstants.TAG_ITEM)");
                Node itemNode = element2;
                Attr attr = nameAttr = document.createAttribute("name");
                Intrinsics.checkExpressionValueIsNotNull((Object)attr, (String)"nameAttr");
                attr.setValue(key.getName());
                itemNode.getAttributes().setNamedItem(nameAttr);
                if (!hasResourceTag) {
                    Attr typeAttr;
                    Attr attr2 = typeAttr = document.createAttribute("type");
                    Intrinsics.checkExpressionValueIsNotNull((Object)attr2, (String)"typeAttr");
                    attr2.setValue(type);
                    itemNode.getAttributes().setNamedItem(typeAttr);
                }
                if (resourceType == ResourceType.STRING) {
                    Attr translatable;
                    Attr attr3 = translatable = document.createAttribute("translatable");
                    Intrinsics.checkExpressionValueIsNotNull((Object)attr3, (String)"translatable");
                    attr3.setValue("false");
                    itemNode.getAttributes().setNamedItem(translatable);
                }
                CharSequence charSequence = value.getValue();
                boolean bl5 = false;
                if (charSequence.length() > 0) {
                    itemNode.appendChild(document.createTextNode(value.getValue()));
                }
                rootNode.appendChild(itemNode);
            }
            try {
                object = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
            }
            catch (Throwable t) {
                object = XmlUtils.toXml((Node)document);
            }
            Object object4 = object;
            if (object4 == null) break block9;
            object = object4;
            boolean bl6 = false;
            boolean bl7 = false;
            Object it = object;
            boolean bl8 = false;
            Files.asCharSink((File)resFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)it);
        }
    }

    public ResValueGenerator(@NotNull File genFolder, @NotNull Map<ResValue.Key, ResValue> requests) {
        Intrinsics.checkParameterIsNotNull((Object)genFolder, (String)"genFolder");
        Intrinsics.checkParameterIsNotNull(requests, (String)"requests");
        this.requests = requests;
        this.folderPath = new File(genFolder, "values");
    }

    static {
        Companion = new Companion(null);
        ImmutableList immutableList = ImmutableList.of((Object)ResourceType.ARRAY, (Object)ResourceType.ATTR, (Object)ResourceType.BOOL, (Object)ResourceType.COLOR, (Object)ResourceType.STYLEABLE, (Object)ResourceType.DIMEN, (Object)ResourceType.FRACTION, (Object)ResourceType.INTEGER, (Object)ResourceType.PLURALS, (Object)ResourceType.STRING, (Object)ResourceType.STYLE);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of(\n      \u2026eType.STYLE\n            )");
        RESOURCES_WITH_TAGS = (List)immutableList;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/generators/ResValueGenerator$Companion;", "", "()V", "RESOURCES_WITH_TAGS", "", "Lcom/android/resources/ResourceType;", "RES_VALUE_FILENAME_XML", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

