/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.core.InternalBaseVariant;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.services.DslServices;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.core.AbstractProductFlavor;
import com.android.builder.core.DefaultVectorDrawablesOptions;
import com.android.builder.errors.IssueReporter;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.VectorDrawablesOptions;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\"\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0012\u0010\u0010\u001a\u00020'2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\f\u001a\u0004\u0018\u00010\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u000f\"\u0004\b\u001d\u0010\u0011\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/core/MergedFlavor;", "Lcom/android/builder/core/AbstractProductFlavor;", "Lcom/android/build/gradle/internal/core/InternalBaseVariant$MergedFlavor;", "name", "", "_applicationId", "Lorg/gradle/api/provider/Property;", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "(Ljava/lang/String;Lorg/gradle/api/provider/Property;Lcom/android/build/gradle/internal/services/DslServices;)V", "_vectorDrawables", "Lcom/android/builder/core/DefaultVectorDrawablesOptions;", "value", "applicationId", "getApplicationId", "()Ljava/lang/String;", "setApplicationId", "(Ljava/lang/String;)V", "vectorDrawables", "getVectorDrawables", "()Lcom/android/builder/core/DefaultVectorDrawablesOptions;", "", "versionCode", "getVersionCode", "()Ljava/lang/Integer;", "setVersionCode", "(Ljava/lang/Integer;)V", "versionName", "getVersionName", "setVersionName", "_initWith", "", "that", "Lcom/android/builder/model/BaseConfig;", "reportErrorWithWorkaround", "fieldName", "outputFieldName", "fieldValue", "", "Lcom/android/builder/model/ProductFlavor;", "Companion", "gradle-core"})
public final class MergedFlavor
extends AbstractProductFlavor
implements InternalBaseVariant.MergedFlavor {
    private DefaultVectorDrawablesOptions _vectorDrawables;
    private final Property<String> _applicationId;
    private final DslServices dslServices;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getApplicationId() {
        this.dslServices.getDeprecationReporter().reportDeprecatedApi("VariantProperties.getApplicationId()", "MergedFlavor.getApplicationId()", "https://d.android.com/r/tools/use-properties", DeprecationReporter.DeprecationTarget.USE_PROPERTIES);
        if (!this.dslServices.getProjectOptions().get(BooleanOption.ENABLE_LEGACY_API)) {
            this.dslServices.getIssueReporter().reportError(IssueReporter.Type.GENERIC, (Exception)new RuntimeException(StringsKt.trimIndent((String)("\n                                Access to deprecated legacy com.android.builder.model.ProductFlavor.getApplicationId() requires compatibility mode for Property values in new com.android.build.api.variant.VariantOutput.versionCode\n                                " + ComponentImpl.Companion + ".ENABLE_LEGACY_API\n                                "))));
            return null;
        }
        return (String)this._applicationId.get();
    }

    @Override
    public void setApplicationId(@Nullable String value) {
        this.setApplicationId(value);
    }

    @Override
    @NotNull
    public ProductFlavor setApplicationId(@Nullable String applicationId2) {
        this._applicationId.set((Object)applicationId2);
        return this;
    }

    @Override
    @NotNull
    public DefaultVectorDrawablesOptions getVectorDrawables() {
        return this._vectorDrawables;
    }

    @Override
    public void _initWith(@NotNull BaseConfig that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        super._initWith(that);
        if (that instanceof ProductFlavor) {
            DefaultVectorDrawablesOptions defaultVectorDrawablesOptions = DefaultVectorDrawablesOptions.copyOf((VectorDrawablesOptions)((ProductFlavor)that).getVectorDrawables());
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultVectorDrawablesOptions, (String)"DefaultVectorDrawablesOp\u2026yOf(that.vectorDrawables)");
            this._vectorDrawables = defaultVectorDrawablesOptions;
        }
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        return super.getVersionCode();
    }

    @Override
    public void setVersionCode(@Nullable Integer value) {
        this.reportErrorWithWorkaround("versionCode", "versionCodeOverride", value);
    }

    @Override
    @Nullable
    public String getVersionName() {
        return super.getVersionName();
    }

    @Override
    public void setVersionName(@Nullable String value) {
        this.reportErrorWithWorkaround("versionName", "versionNameOverride", value);
    }

    private final void reportErrorWithWorkaround(String fieldName, String outputFieldName, Object fieldValue) {
        String formattedFieldValue = fieldValue instanceof String ? "\"" + fieldValue + "\"" : String.valueOf(fieldValue);
        String message = StringsKt.trimMargin$default((String)(fieldName + " cannot be set on a mergedFlavor directly.\n                |" + outputFieldName + " can instead be set for variant outputs using the following syntax:\n                |android {\n                |    applicationVariants.all { variant ->\n                |        variant.outputs.each { output ->\n                |            output." + outputFieldName + " = " + formattedFieldValue + "\n                |        }\n                |    }\n                |}"), null, (int)1, null);
        IssueReporter.reportError$default((IssueReporter)this.dslServices.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message, null, null, (int)12, null);
    }

    public MergedFlavor(@NotNull String name2, @NotNull Property<String> _applicationId, @NotNull DslServices dslServices) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(_applicationId, (String)"_applicationId");
        Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
        super(name2);
        this._applicationId = _applicationId;
        this.dslServices = dslServices;
        this._vectorDrawables = new DefaultVectorDrawablesOptions();
    }

    @JvmStatic
    @NotNull
    public static final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull Property<String> applicationId2, @NotNull DslServices dslServices) {
        return Companion.clone(productFlavor, applicationId2, dslServices);
    }

    @JvmStatic
    @NotNull
    public static final MergedFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull Property<String> applicationId2, @NotNull DslServices dslServices) {
        return Companion.mergeFlavors(lowestPriority, flavors, applicationId2, dslServices);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J4\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/core/MergedFlavor$Companion;", "", "()V", "clone", "Lcom/android/build/gradle/internal/core/MergedFlavor;", "productFlavor", "Lcom/android/builder/model/ProductFlavor;", "applicationId", "Lorg/gradle/api/provider/Property;", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "mergeFlavors", "lowestPriority", "flavors", "", "gradle-core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MergedFlavor clone(@NotNull ProductFlavor productFlavor, @NotNull Property<String> applicationId2, @NotNull DslServices dslServices) {
            Intrinsics.checkParameterIsNotNull((Object)productFlavor, (String)"productFlavor");
            Intrinsics.checkParameterIsNotNull(applicationId2, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
            MergedFlavor mergedFlavor2 = new MergedFlavor(productFlavor.getName(), applicationId2, dslServices);
            mergedFlavor2._initWith((BaseConfig)productFlavor);
            return mergedFlavor2;
        }

        @JvmStatic
        @NotNull
        public final MergedFlavor mergeFlavors(@NotNull ProductFlavor lowestPriority, @NotNull List<? extends ProductFlavor> flavors, @NotNull Property<String> applicationId2, @NotNull DslServices dslServices) {
            Intrinsics.checkParameterIsNotNull((Object)lowestPriority, (String)"lowestPriority");
            Intrinsics.checkParameterIsNotNull(flavors, (String)"flavors");
            Intrinsics.checkParameterIsNotNull(applicationId2, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
            MergedFlavor mergedFlavor2 = this.clone(lowestPriority, applicationId2, dslServices);
            Iterator iterator = Lists.reverse(flavors).iterator();
            while (iterator.hasNext()) {
                ProductFlavor flavor;
                ProductFlavor productFlavor = flavor = (ProductFlavor)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"flavor");
                mergedFlavor2.mergeWithHigherPriorityFlavor(productFlavor);
            }
            String applicationIdSuffix = lowestPriority.getApplicationIdSuffix();
            String versionNameSuffix = lowestPriority.getVersionNameSuffix();
            for (ProductFlavor productFlavor : flavors) {
                applicationIdSuffix = AbstractProductFlavor.Companion.mergeApplicationIdSuffix(productFlavor.getApplicationIdSuffix(), applicationIdSuffix);
                versionNameSuffix = AbstractProductFlavor.Companion.mergeVersionNameSuffix(productFlavor.getVersionNameSuffix(), versionNameSuffix);
            }
            mergedFlavor2.setApplicationIdSuffix(applicationIdSuffix);
            mergedFlavor2.setVersionNameSuffix(versionNameSuffix);
            return mergedFlavor2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

