/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxBuildModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.services.CxxProcessServiceKt;
import com.android.build.gradle.tasks.ExternalNativeJsonGeneratorBase;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ.\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\b2\u001c\u0010\u001a\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u001d0\u001c\u0012\u0004\u0012\u00020\u001e0\u001bH\u0016J(\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00072\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\bH\u0016J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\r0'H\u0016J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\bH\u0016R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGeneratorBase;", "build", "Lcom/android/build/gradle/internal/cxx/model/CxxBuildModel;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "stats", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxBuildModel;Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "makeFile", "Ljava/io/File;", "getMakeFile", "()Ljava/io/File;", "nativeBuildSystem", "Lcom/android/build/gradle/tasks/NativeBuildSystem;", "getNativeBuildSystem", "()Lcom/android/build/gradle/tasks/NativeBuildSystem;", "ndkBuild", "", "getNdkBuild", "()Ljava/lang/String;", "executeProcess", "abi", "execOperation", "Lkotlin/Function1;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/ExecSpec;", "Lorg/gradle/process/ExecResult;", "getBaseArgs", "applicationMk", "removeJobsFlag", "", "getBuildCommand", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "getStlSharedObjectFiles", "", "Lcom/android/build/gradle/internal/core/Abi;", "processBuildOutput", "", "buildOutput", "abiConfig", "gradle"})
public final class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGeneratorBase {
    @Override
    public void processBuildOutput(@NotNull String buildOutput, @NotNull CxxAbiModel abiConfig) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buildOutput, (String)"buildOutput");
        Intrinsics.checkParameterIsNotNull((Object)abiConfig, (String)"abiConfig");
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        LoggingEnvironmentKt.infoln("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValueBuilder(this.getMakeFile(), this.getVariant().getModule().getModuleRootFolder()).setCommands(this.getBuildCommand(abiConfig, applicationMk, false), this.getBuildCommand(abiConfig, applicationMk, true) + " clean", this.getVariant().getVariantName(), buildOutput).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)nativeBuildConfigValue, (String)"NativeBuildConfigValueBu\u2026   )\n            .build()");
        NativeBuildConfigValue buildConfig = nativeBuildConfigValue;
        if (applicationMk.exists()) {
            Object[] objectArray = new Object[1];
            String string = applicationMk.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"applicationMk.absolutePath");
            objectArray[0] = string;
            LoggingEnvironmentKt.infoln("found application make file %s", objectArray);
            Collection<File> collection = buildConfig.buildFiles;
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            collection.add(applicationMk);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Path path = CxxAbiModelKt.getJsonFile(abiConfig).toPath();
        String string = actualResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"actualResult");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.UTF_8");
        Charset charset2 = charset;
        Path path2 = path;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        Files.write(path2, byArray2, new OpenOption[0]);
    }

    @Override
    @NotNull
    public ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        File applicationMk = new File(this.getMakeFile().getParent(), "Application.mk");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getNdkBuild()).addArgs(this.getBaseArgs(abi, applicationMk, false)).addArgs("APP_SHORT_COMMANDS=false").addArgs("LOCAL_SHORT_COMMANDS=false").addArgs("-B").addArgs("-n");
        return builder;
    }

    @Override
    @NotNull
    public String executeProcess(@NotNull CxxAbiModel abi, @NotNull Function1<? super Action<? super ExecSpec>, ? extends ExecResult> execOperation) throws ProcessException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        Intrinsics.checkParameterIsNotNull(execOperation, (String)"execOperation");
        return CxxProcessServiceKt.createProcessOutputJunction(abi.getVariant().getModule(), CxxAbiModelKt.getSoFolder(abi), "android_gradle_generate_ndk_build_json_" + abi.getAbi().getTag(), this.getProcessBuilder(abi), "").logStderrToInfo().executeAndReturnStdoutString(execOperation);
    }

    @Override
    @NotNull
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.NDK_BUILD;
    }

    @Override
    @NotNull
    public Map<Abi, File> getStlSharedObjectFiles() {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
        return hashMap;
    }

    private final String getNdkBuild() {
        String string;
        String tool = "ndk-build";
        if (ExternalNativeJsonGeneratorBase.Companion.isWindows()) {
            tool = tool + ".cmd";
        }
        File toolFile = new File(this.getNdkFolder(), tool);
        try {
            String string2 = toolFile.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toolFile.canonicalPath");
            string = string2;
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", e);
            String string3 = toolFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"toolFile.absolutePath");
            string = string3;
        }
        return string;
    }

    private final File getMakeFile() {
        return this.getMakefile().isDirectory() ? new File(this.getMakefile(), "Android.mk") : this.getMakefile();
    }

    private final List<String> getBaseArgs(CxxAbiModel abi, File applicationMk, boolean removeJobsFlag) {
        String string;
        boolean bl;
        List list;
        Object[] objectArray;
        String string2;
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List result = arrayList;
        result.add("NDK_PROJECT_PATH=null");
        result.add("APP_BUILD_SCRIPT=" + this.getMakeFile());
        if (applicationMk.exists()) {
            result.add("NDK_APPLICATION_MK=" + applicationMk.getAbsolutePath());
        }
        Collection collection = abi.getVariant().getPrefabPackageDirectoryList();
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            if (abi.getVariant().getModule().getNdkVersion().getMajor() < 21) {
                LoggingEnvironmentKt.warnln("Prefab packages cannot be automatically imported until NDK r21.", new Object[0]);
            }
            result.add("NDK_GRADLE_INJECTED_IMPORT_PATH=" + abi.getPrefabFolder().toString());
        }
        result.add("APP_ABI=" + abi.getAbi().getTag());
        result.add("NDK_ALL_ABIS=" + abi.getAbi().getTag());
        if (this.isDebuggable()) {
            result.add("NDK_DEBUG=1");
        } else {
            result.add("NDK_DEBUG=0");
        }
        result.add("APP_PLATFORM=android-" + abi.getAbiPlatformVersion());
        String ndkOut = new File(this.getObjFolder()).getParent();
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            String string3 = ndkOut;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ndkOut");
            ndkOut = StringsKt.replace$default((String)string3, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        result.add("NDK_OUT=" + ndkOut);
        result.add("NDK_LIBS_OUT=" + this.getSoFolder());
        for (String flag : this.getcFlags()) {
            object = StringCompanionObject.INSTANCE;
            string2 = "APP_CFLAGS+=%s";
            objectArray = new Object[]{flag};
            list = result;
            bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            list.add(string);
        }
        for (String flag : this.getCppFlags()) {
            object = StringCompanionObject.INSTANCE;
            string2 = "APP_CPPFLAGS+=%s";
            objectArray = new Object[]{flag};
            list = result;
            bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string2, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
            list.add(string);
        }
        boolean skipNextArgument = false;
        for (String argument : this.getBuildArguments()) {
            if (removeJobsFlag && Intrinsics.areEqual((Object)argument, (Object)"-j")) {
                skipNextArgument = true;
                continue;
            }
            if (removeJobsFlag && Intrinsics.areEqual((Object)argument, (Object)"--jobs")) {
                skipNextArgument = true;
                continue;
            }
            if (skipNextArgument) {
                skipNextArgument = false;
                continue;
            }
            if (removeJobsFlag && (StringsKt.startsWith$default((String)argument, (String)"-j", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)argument, (String)"--jobs=", (boolean)false, (int)2, null))) continue;
            result.add(argument);
        }
        return result;
    }

    private final String getBuildCommand(CxxAbiModel abi, File applicationMk, boolean removeJobsFlag) {
        return this.getNdkBuild() + " " + Joiner.on((String)" ").join((Iterable)this.getBaseArgs(abi, applicationMk, removeJobsFlag));
    }

    public NdkBuildExternalNativeJsonGenerator(@NotNull CxxBuildModel build2, @NotNull CxxVariantModel variant2, @NotNull List<? extends CxxAbiModel> abis, @NotNull GradleBuildVariant.Builder stats) {
        Intrinsics.checkParameterIsNotNull((Object)build2, (String)"build");
        Intrinsics.checkParameterIsNotNull((Object)variant2, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis, (String)"abis");
        Intrinsics.checkParameterIsNotNull((Object)stats, (String)"stats");
        super(build2, variant2, abis, stats);
        this.getStats().setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        if (this.getMakefile().isDirectory()) {
            LoggingEnvironmentKt.errorln("Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", this.getMakefile());
        } else if (!this.getMakefile().exists()) {
            LoggingEnvironmentKt.errorln("Gradle project ndkBuild.path is %s but that file doesn't exist", this.getMakefile());
        }
    }
}

