/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.VariantOutputConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.SdkComponentsKt;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.core.VariantType;
import com.android.builder.errors.DefaultIssueReporter;
import com.android.builder.errors.IssueReporter;
import com.android.repository.Revision;
import com.android.tools.lint.gradle.api.LintExecutionRequest;
import com.android.tools.lint.gradle.api.ReflectiveLintRunner;
import com.android.tools.lint.model.LintModelFactory;
import com.android.tools.lint.model.LintModelLintOptions;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class LintBaseTask
extends DefaultTask {
    public static final String LINT_CLASS_PATH = "lintClassPath";
    protected static final Logger LOG = Logging.getLogger(LintBaseTask.class);
    FileCollection lintClassPath;
    protected LintOptions lintOptions;
    protected File sdkHome;
    protected ToolingModelBuilderRegistry toolingRegistry;
    protected File reportsDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    public FileCollection getLintClassPath() {
        return this.lintClassPath;
    }

    @Internal(value="Temporary to suppress Gradle warnings (bug 135900510), may need more investigation")
    public LintOptions getLintOptions() {
        return this.lintOptions;
    }

    protected void runLint(LintBaseTaskDescriptor descriptor) {
        FileCollection lintClassPath = this.getLintClassPath();
        if (lintClassPath != null) {
            new ReflectiveLintRunner().runLint(this.getProject().getGradle(), (LintExecutionRequest)descriptor, lintClassPath.getFiles());
        }
    }

    private Revision getBuildToolsRevision() {
        return (Revision)((SdkComponentsBuildService)this.getSdkBuildService().get()).getBuildToolsRevisionProvider().get();
    }

    @Internal
    public abstract Property<SdkComponentsBuildService> getSdkBuildService();

    protected static void addModelArtifactsToInputs(ConfigurableFileCollection inputs, ComponentPropertiesImpl componentProperties) {
        inputs.from(new Object[]{() -> new ArtifactCollections(componentProperties, AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH).getAllCollections()});
        inputs.from(new Object[]{() -> new ArtifactCollections(componentProperties, AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH).getAllCollections()});
        if (componentProperties instanceof VariantPropertiesImpl) {
            VariantPropertiesImpl variantProperties = (VariantPropertiesImpl)componentProperties;
            for (VariantType variantType : VariantType.Companion.getTestComponents()) {
                ComponentPropertiesImpl testVariant = variantProperties.getTestComponents().get(variantType);
                if (testVariant == null) continue;
                LintBaseTask.addModelArtifactsToInputs(inputs, testVariant);
            }
        }
    }

    public static abstract class BaseCreationAction<T extends LintBaseTask>
    extends TaskCreationAction<T> {
        protected final GlobalScope globalScope;

        public BaseCreationAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        protected GlobalScope getGlobalScope() {
            return this.globalScope;
        }

        @Override
        public void configure(T lintTask) {
            lintTask.setGroup("verification");
            ((LintBaseTask)((Object)lintTask)).lintOptions = this.globalScope.getExtension().getLintOptions();
            ((LintBaseTask)((Object)lintTask)).sdkHome = SdkComponentsKt.getSdkDir(lintTask.getProject().getRootDir(), (IssueReporter)new DefaultIssueReporter((ILogger)LoggerWrapper.getLogger(LintBaseTask.class)));
            ((LintBaseTask)((Object)lintTask)).toolingRegistry = this.globalScope.getToolingRegistry();
            ((LintBaseTask)((Object)lintTask)).reportsDir = this.globalScope.getReportsDir();
            HasConfigurableValuesKt.setDisallowChanges(((LintBaseTask)((Object)lintTask)).getSdkBuildService(), BuildServicesKt.getBuildService(lintTask.getProject().getGradle().getSharedServices(), SdkComponentsBuildService.class));
            ((LintBaseTask)((Object)lintTask)).lintClassPath = this.globalScope.getProject().getConfigurations().getByName(LintBaseTask.LINT_CLASS_PATH);
        }
    }

    public static class VariantInputs
    implements com.android.tools.lint.gradle.api.VariantInputs {
        private final String name;
        private final Provider<? extends FileSystemLocation> mergedManifest;
        private final Provider<RegularFile> mergedManifestReport;
        private final FileCollection lintRuleJars;
        private final ConfigurableFileCollection allInputs;

        public VariantInputs(ComponentPropertiesImpl componentProperties) {
            GlobalScope globalScope = componentProperties.getGlobalScope();
            this.name = componentProperties.getName();
            this.allInputs = globalScope.getProject().files(new Object[0]);
            Object[] objectArray = new Object[1];
            FileCollection localLintJarCollection = globalScope.getLocalCustomLintChecks();
            objectArray[0] = localLintJarCollection;
            this.allInputs.from(objectArray);
            Object[] objectArray2 = new Object[1];
            FileCollection dependencyLintJarCollection = componentProperties.getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.LINT);
            objectArray2[0] = dependencyLintJarCollection;
            this.allInputs.from(objectArray2);
            this.lintRuleJars = globalScope.getProject().files(new Object[]{localLintJarCollection, dependencyLintJarCollection});
            ArtifactsImpl artifacts2 = componentProperties.getArtifacts();
            Provider<Directory> tmpMergedManifest = artifacts2.get(InternalArtifactType.PACKAGED_MANIFESTS.INSTANCE);
            if (!tmpMergedManifest.isPresent()) {
                tmpMergedManifest = artifacts2.get(InternalArtifactType.LIBRARY_MANIFEST.INSTANCE);
            }
            if (!tmpMergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest on: " + componentProperties.getVariantType());
            }
            this.mergedManifest = tmpMergedManifest;
            this.allInputs.from(new Object[]{this.mergedManifest});
            this.mergedManifestReport = artifacts2.get(InternalArtifactType.MANIFEST_MERGE_REPORT.INSTANCE);
            if (!this.mergedManifest.isPresent()) {
                throw new RuntimeException("VariantInputs initialized with no merged manifest report on: " + componentProperties.getVariantType());
            }
            this.allInputs.from(new Object[]{this.mergedManifestReport});
            this.allInputs.from(new Object[]{componentProperties.getArtifacts().getAllClasses()});
            LintBaseTask.addModelArtifactsToInputs(this.allInputs, componentProperties);
        }

        public FileCollection getAllInputs() {
            return this.allInputs;
        }

        public String getName() {
            return this.name;
        }

        public FileCollection getRuleJars() {
            return this.lintRuleJars;
        }

        public File getMergedManifest() {
            File file = ((FileSystemLocation)this.mergedManifest.get()).getAsFile();
            if (file.isFile()) {
                return file;
            }
            BuiltArtifactsImpl manifests = BuiltArtifactsLoaderImpl.loadFromDirectory(file);
            if (manifests == null || manifests.getElements().isEmpty()) {
                throw new RuntimeException("Can't find any manifest in folder: " + file);
            }
            Optional<String> mainManifest = manifests.getElements().stream().filter(buildOutput -> buildOutput.getOutputType() == VariantOutputConfiguration.OutputType.SINGLE).map(BuiltArtifact::getOutputFile).findFirst();
            if (mainManifest.isPresent()) {
                return new File(mainManifest.get());
            }
            Optional<String> universalSplit = manifests.getElements().stream().filter(output2 -> output2.getOutputType() == VariantOutputConfiguration.OutputType.UNIVERSAL).map(BuiltArtifact::getOutputFile).findFirst();
            return new File(universalSplit.orElseGet(() -> manifests.getElements().iterator().next().getOutputFile()));
        }

        public File getManifestMergeReport() {
            if (this.mergedManifestReport.isPresent()) {
                return ((RegularFile)this.mergedManifestReport.get()).getAsFile();
            }
            return null;
        }
    }

    protected abstract class LintBaseTaskDescriptor
    extends LintExecutionRequest {
        private final Cache<Pair<String, String>, List<File>> kotlinSourceFoldersCache = CacheBuilder.newBuilder().build();

        protected LintBaseTaskDescriptor() {
        }

        public File getSdkHome() {
            return LintBaseTask.this.sdkHome;
        }

        public ToolingModelBuilderRegistry getToolingRegistry() {
            return LintBaseTask.this.toolingRegistry;
        }

        public LintModelLintOptions getLintOptions() {
            if (LintBaseTask.this.lintOptions != null) {
                return LintModelFactory.getLintOptions((com.android.builder.model.LintOptions)LintBaseTask.this.lintOptions);
            }
            return null;
        }

        public File getReportsDir() {
            return LintBaseTask.this.reportsDir;
        }

        public Project getProject() {
            return LintBaseTask.this.getProject();
        }

        public Revision getBuildToolsRevision() {
            return LintBaseTask.this.getBuildToolsRevision();
        }

        public void warn(String message, Object ... args2) {
            LOG.warn(message, args2);
        }

        public String getGradlePluginVersion() {
            return Version.ANDROID_GRADLE_PLUGIN_VERSION;
        }

        private List<File> doFetchKotlinSourceFolders(String sourceSetName, Project project2) throws Exception {
            BaseExtension extension = (BaseExtension)project2.getExtensions().getByName("android");
            Object kotlinSourceSet = ((HasConvention)extension.getSourceSets().getByName(sourceSetName)).getConvention().getPlugins().get("kotlin");
            Method getSourceDirectorySet = kotlinSourceSet.getClass().getDeclaredMethod("getKotlin", new Class[0]);
            SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)getSourceDirectorySet.invoke(kotlinSourceSet, new Object[0]);
            return sourceDirectorySet.getSrcDirs().stream().filter(File::exists).collect(Collectors.toList());
        }

        private List<File> fetchKotlinSourceFolders(String sourceSetName, Project project2) {
            try {
                return (List)this.kotlinSourceFoldersCache.get((Object)Pair.of((Object)sourceSetName, (Object)project2.getPath()), () -> this.doFetchKotlinSourceFolders(sourceSetName, project2));
            }
            catch (Throwable e) {
                LintBaseTask.this.getLogger().warn("Unable to fetch kotlin source folders for source set " + sourceSetName, e);
                return Collections.emptyList();
            }
        }

        public List<File> getKotlinSourceFolders(String variantName, Project project2) {
            DomainObjectSet<ApplicationVariant> variants;
            if (project2 == null || !project2.getPlugins().hasPlugin("kotlin-android")) {
                return Collections.emptyList();
            }
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            BaseExtension extension = (BaseExtension)project2.getExtensions().getByName("android");
            if (extension instanceof AppExtension) {
                variants = ((AppExtension)extension).getApplicationVariants();
            } else if (extension instanceof LibraryExtension) {
                variants = ((LibraryExtension)extension).getLibraryVariants();
            } else {
                return Collections.emptyList();
            }
            variants.matching(it -> it.getName().equals(variantName)).forEach(variant2 -> variant2.getSourceSets().forEach(sourceProvider -> builder.addAll(this.fetchKotlinSourceFolders(sourceProvider.getName(), project2))));
            return builder.build().asList();
        }
    }
}

