/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.utils.DependencyInfo;
import com.android.builder.errors.IssueReporter;
import com.android.ide.common.repository.GradleVersion;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a<\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0001\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"pluginList", "", "Lcom/android/build/gradle/internal/utils/DependencyInfo;", "enforceMinimumVersionOfPlugin", "", "project", "Lorg/gradle/api/Project;", "pluginInfo", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "enforceMinimumVersionsOfPlugins", "getBuildSrcPlugins", "", "", "classLoader", "Ljava/lang/ClassLoader;", "visitDependency", "dependencyResult", "Lorg/gradle/api/artifacts/result/DependencyResult;", "parentPath", "dependencyInfo", "pathsToViolatingDeps", "", "visitedDependencies", "", "gradle"})
@JvmName(name="GradlePluginUtils")
public final class GradlePluginUtils {
    private static final List<DependencyInfo> pluginList;

    public static final void enforceMinimumVersionsOfPlugins(@NotNull Project project2, @NotNull IssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        project2.afterEvaluate((Action)new Action<Project>(issueReporter){
            final /* synthetic */ IssueReporter $issueReporter;

            public final void execute(Project it) {
                for (DependencyInfo plugin : GradlePluginUtils.access$getPluginList$p()) {
                    Project project2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it");
                    GradlePluginUtils.access$enforceMinimumVersionOfPlugin(project2, plugin, this.$issueReporter);
                }
            }
            {
                this.$issueReporter = issueReporter;
            }
        });
    }

    private static final void enforceMinimumVersionOfPlugin(Project project2, DependencyInfo pluginInfo, IssueReporter issueReporter) {
        ScriptHandler scriptHandler = project2.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
        Configuration buildScriptClasspath = scriptHandler.getConfigurations().getByName("classpath");
        boolean bl = false;
        List pathsToViolatingPlugins = new ArrayList();
        Configuration configuration2 = buildScriptClasspath;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"buildScriptClasspath");
        ResolvableDependencies resolvableDependencies = configuration2.getIncoming();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"buildScriptClasspath.incoming");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"buildScriptClasspath.incoming.resolutionResult");
        ResolvedComponentResult resolvedComponentResult = resolutionResult.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"buildScriptClasspath.inc\u2026ing.resolutionResult.root");
        for (DependencyResult dependency : resolvedComponentResult.getDependencies()) {
            String string;
            DependencyResult dependencyResult;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"dependency");
            Intrinsics.checkExpressionValueIsNotNull((Object)project2.getDisplayName(), (String)"project.displayName");
            List list = pathsToViolatingPlugins;
            DependencyInfo dependencyInfo = pluginInfo;
            boolean bl2 = false;
            Set set = new LinkedHashSet();
            GradlePluginUtils.visitDependency(dependencyResult, string, dependencyInfo, list, set);
        }
        Collection collection = pathsToViolatingPlugins;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            IssueReporter.reportError$default((IssueReporter)issueReporter, (IssueReporter.Type)IssueReporter.Type.THIRD_PARTY_GRADLE_PLUGIN_TOO_OLD, (String)("The Android Gradle plugin supports only " + pluginInfo.getDisplayName() + " Gradle plugin" + " version " + pluginInfo.getMinimumVersion() + " and higher.\n" + "The following dependencies do not satisfy the required version:\n" + CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new Object[]{pluginInfo.getDisplayName(), pluginInfo.getDependencyGroup(), pluginInfo.getDependencyName(), pluginInfo.getMinimumVersion(), CollectionsKt.joinToString$default((Iterable)pathsToViolatingPlugins, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null)}), (CharSequence)";", null, null, (int)0, null, null, (int)62, null), null, (int)8, null);
        }
    }

    @VisibleForTesting
    public static final void visitDependency(@NotNull DependencyResult dependencyResult, @NotNull String parentPath, @NotNull DependencyInfo dependencyInfo, @NotNull List<String> pathsToViolatingDeps, @NotNull Set<String> visitedDependencies) {
        String dependencyFullName;
        GradleVersion parsedVersion;
        ResolvedComponentResult dependency;
        Intrinsics.checkParameterIsNotNull((Object)dependencyResult, (String)"dependencyResult");
        Intrinsics.checkParameterIsNotNull((Object)parentPath, (String)"parentPath");
        Intrinsics.checkParameterIsNotNull((Object)dependencyInfo, (String)"dependencyInfo");
        Intrinsics.checkParameterIsNotNull(pathsToViolatingDeps, (String)"pathsToViolatingDeps");
        Intrinsics.checkParameterIsNotNull(visitedDependencies, (String)"visitedDependencies");
        boolean bl = dependencyResult instanceof ResolvedDependencyResult;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Expected " + ResolvedDependencyResult.class.getName() + " but found " + dependencyResult.getClass().getName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ResolvedComponentResult resolvedComponentResult = dependency = ((ResolvedDependencyResult)dependencyResult).getSelected();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedComponentResult, (String)"dependency");
        ModuleVersionIdentifier moduleVersionIdentifier = resolvedComponentResult.getModuleVersion();
        if (moduleVersionIdentifier == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionIdentifier, (String)"dependency.moduleVersion!!");
        ModuleVersionIdentifier moduleVersion = moduleVersionIdentifier;
        String group = moduleVersion.getGroup();
        String name2 = moduleVersion.getName();
        String version = moduleVersion.getVersion();
        String currentPath = parentPath + " -> " + group + ':' + name2 + ':' + version;
        if (Intrinsics.areEqual((Object)group, (Object)dependencyInfo.getDependencyGroup()) && Intrinsics.areEqual((Object)name2, (Object)dependencyInfo.getDependencyName()) && (parsedVersion = GradleVersion.tryParse((String)version)) != null && parsedVersion.compareTo(dependencyInfo.getMinimumVersion()) < 0) {
            pathsToViolatingDeps.add(currentPath);
        }
        if (visitedDependencies.contains(dependencyFullName = group + ':' + name2 + ':' + version)) {
            return;
        }
        visitedDependencies.add(dependencyFullName);
        Iterator iterator = dependency.getDependencies().iterator();
        while (iterator.hasNext()) {
            DependencyResult childDependency;
            DependencyResult dependencyResult2 = childDependency = (DependencyResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyResult2, (String)"childDependency");
            GradlePluginUtils.visitDependency(dependencyResult2, currentPath, dependencyInfo, pathsToViolatingDeps, visitedDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Set<String> getBuildSrcPlugins(@NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        Pattern pattern = Pattern.compile("META-INF/gradle-plugins/(.+)\\.properties");
        Enumeration<URL> urls = classLoader.getResources("META-INF/gradle-plugins");
        HashSet<String> buildSrcPlugins = new HashSet<String>();
        while (urls.hasMoreElements()) {
            URLConnection urlConnection;
            URL url = urls.nextElement();
            String string = url.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.toString()");
            if (!StringsKt.endsWith$default((String)string, (String)"buildSrc.jar!/META-INF/gradle-plugins", (boolean)false, (int)2, null) || !((urlConnection = url.openConnection()) instanceof JarURLConnection)) continue;
            Closeable closeable = ((JarURLConnection)urlConnection).getJarFile();
            boolean bl = false;
            Throwable throwable = null;
            try {
                JarFile jar = (JarFile)closeable;
                boolean bl2 = false;
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry entry;
                    JarEntry jarEntry = entry = jarEntries.nextElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"entry");
                    Matcher matcher = pattern.matcher(jarEntry.getName());
                    if (!matcher.matches()) continue;
                    buildSrcPlugins.add(matcher.group(1));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return buildSrcPlugins;
    }

    static {
        Object[] objectArray = new DependencyInfo[4];
        GradleVersion gradleVersion = GradleVersion.parse((String)"9.0.0-rc2");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion, (String)"GradleVersion.parse(\"9.0.0-rc2\")");
        objectArray[0] = new DependencyInfo("Butterknife", "com.jakewharton", "butterknife-gradle-plugin", gradleVersion);
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"1.28.0");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"GradleVersion.parse(\"1.28.0\")");
        objectArray[1] = new DependencyInfo("Crashlytics", "io.fabric.tools", "gradle", gradleVersion2);
        GradleVersion gradleVersion3 = GradleVersion.parse((String)"0.8.6");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion3, (String)"GradleVersion.parse(\"0.8.6\")");
        objectArray[2] = new DependencyInfo("Protobuf", "com.google.protobuf", "protobuf-gradle-plugin", gradleVersion3);
        GradleVersion gradleVersion4 = GradleVersion.parse((String)"1.3.10");
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion4, (String)"GradleVersion.parse(\"1.3.10\")");
        objectArray[3] = new DependencyInfo("Kotlin", "org.jetbrains.kotlin", "kotlin-gradle-plugin", gradleVersion4);
        pluginList = CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ List access$getPluginList$p() {
        return pluginList;
    }

    public static final /* synthetic */ void access$enforceMinimumVersionOfPlugin(Project project2, DependencyInfo pluginInfo, IssueReporter issueReporter) {
        GradlePluginUtils.enforceMinimumVersionOfPlugin(project2, pluginInfo, issueReporter);
    }
}

