/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.internal.component.AndroidTestCreationConfig;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "creationConfig", "Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;", "testApkDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "moduleName", "", "apkBundle", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/AndroidTestCreationConfig;Lorg/gradle/api/provider/Provider;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "isLibrary", "", "()Z", "getTestedApks", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "getTestedApksFromBundle", "gradle"})
public final class BundleTestDataImpl
extends AbstractTestDataImpl {
    private final String moduleName;
    private final FileCollection apkBundle;

    @Override
    public boolean isLibrary() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ImmutableList<File> getTestedApks(@NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (this.moduleName != null && deviceConfigProvider.getApiLevel() < 21) {
            logger.warning("Testing dynamic features on devices API < 21 is not currently supported.", new Object[0]);
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<File>()");
            return immutableList;
        }
        Path path = this.apkBundle.getSingleFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"apkBundle.singleFile.toPath()");
        Iterable $this$map$iv = BundleInstallUtils.getApkFiles(path, deviceConfigProvider, this.moduleName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            collection.add(file);
        }
        return GuavaKtxKt.toImmutableList((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public FileCollection getTestedApksFromBundle() {
        return this.apkBundle;
    }

    public BundleTestDataImpl(@NotNull AndroidTestCreationConfig creationConfig, @NotNull Provider<Directory> testApkDir, @Nullable String moduleName, @NotNull FileCollection apkBundle) {
        Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
        Intrinsics.checkParameterIsNotNull(testApkDir, (String)"testApkDir");
        Intrinsics.checkParameterIsNotNull((Object)apkBundle, (String)"apkBundle");
        super(creationConfig, creationConfig.getVariantSources(), testApkDir, null);
        this.moduleName = moduleName;
        this.apkBundle = apkBundle;
    }
}

