/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.builder.errors.EvalIssueException;
import java.io.IOException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

@CacheableTask
public abstract class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseModule;

    @Input
    public boolean getIsDynamicFeature() {
        return this.isDynamicFeature;
    }

    @Input
    public boolean getIsBaseModule() {
        return this.isBaseModule;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getConsumerProguardFiles();

    @Internal(value="only for task execution")
    public abstract DirectoryProperty getBuildDirectory();

    @Override
    public void doTaskAction() throws IOException {
        if (!this.isBaseModule) {
            ExportConsumerProguardFilesTask.checkProguardFiles(this.getBuildDirectory(), this.isDynamicFeature, this.getConsumerProguardFiles().getFiles(), errorMessage -> {
                throw new EvalIssueException(errorMessage);
            });
        }
        super.doTaskAction();
    }

    public static class CreationAction
    extends VariantTaskCreationAction<MergeConsumerProguardFilesTask, ComponentPropertiesImpl> {
        public CreationAction(ComponentPropertiesImpl componentProperties) {
            super(componentProperties);
        }

        @Override
        public String getName() {
            return this.computeTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<MergeConsumerProguardFilesTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, MergeFileTask::getOutputFile).withName("proguard.txt").on(InternalArtifactType.MERGED_CONSUMER_PROGUARD_FILE.INSTANCE);
        }

        @Override
        public void configure(MergeConsumerProguardFilesTask task) {
            super.configure(task);
            GlobalScope globalScope = ((ComponentPropertiesImpl)this.creationConfig).getGlobalScope();
            Project project2 = globalScope.getProject();
            task.isBaseModule = ((ComponentPropertiesImpl)this.creationConfig).getVariantType().isBaseModule();
            task.isDynamicFeature = ((ComponentPropertiesImpl)this.creationConfig).getVariantType().isDynamicFeature();
            task.getConsumerProguardFiles().from(new Object[]{((ComponentPropertiesImpl)this.creationConfig).getVariantScope().getConsumerProguardFilesForFeatures()});
            ConfigurableFileCollection inputFiles2 = project2.files(new Object[]{task.getConsumerProguardFiles(), ((ComponentPropertiesImpl)this.creationConfig).getArtifacts().get(InternalArtifactType.GENERATED_PROGUARD_FILE.INSTANCE)});
            task.setInputFiles((FileCollection)inputFiles2);
            HasConfigurableValuesKt.setDisallowChanges(task.getBuildDirectory(), task.getProject().getLayout().getBuildDirectory());
        }
    }
}

