/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.profile.TaskProfilingRecord;
import com.android.ide.common.workers.GradlePluginMBeans;
import com.android.ide.common.workers.ProfileMBean;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;

public class Blocks {
    public static <E extends Exception> void recordSpan(String projectName, String taskPath, GradleBuildProfileSpan.ExecutionType type, ThrowingBlock<E> block) throws E {
        ProfileMBean profileMBean = GradlePluginMBeans.INSTANCE.getProfileMBean(projectName);
        Instant before = TaskProfilingRecord.Companion.getClock().instant();
        block.invoke();
        Instant after = TaskProfilingRecord.Companion.getClock().instant();
        if (profileMBean != null) {
            profileMBean.registerSpan(taskPath, GradleBuildProfileSpan.newBuilder().setType(type).setThreadId(Thread.currentThread().getId()).setStartTimeInMs(before.toEpochMilli()).setDurationInMs(Duration.between(before, after).toMillis()));
        }
    }

    public static <T, E extends Exception> T recordSpan(String projectName, String taskPath, GradleBuildProfileSpan.ExecutionType type, ThrowingBlockWithReturn<T, E> block) throws E {
        ProfileMBean profileMBean = GradlePluginMBeans.INSTANCE.getProfileMBean(projectName);
        Instant before = Clock.systemDefaultZone().instant();
        T t = block.invoke();
        Instant after = TaskProfilingRecord.Companion.getClock().instant();
        if (profileMBean != null) {
            profileMBean.registerSpan(taskPath, GradleBuildProfileSpan.newBuilder().setType(type).setThreadId(Thread.currentThread().getId()).setStartTimeInMs(before.toEpochMilli()).setDurationInMs(Duration.between(before, after).toMillis()));
        }
        return t;
    }

    @FunctionalInterface
    public static interface ThrowingBlock<E extends Exception> {
        public void invoke() throws E;
    }

    @FunctionalInterface
    public static interface ThrowingBlockWithReturn<T, E extends Exception> {
        public T invoke() throws E;
    }
}

