/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.utils.PathUtils;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "profileDir", "Ljava/nio/file/Path;", "close", "", "collectProjectInfo", "project", "Lorg/gradle/api/Project;", "projectEvaluated", "gradle", "Lorg/gradle/api/invocation/Gradle;", "Parameters", "RegistrationAction"})
public abstract class ProfileCleanupBuildService
implements BuildService<Parameters>,
AutoCloseable {
    private Path profileDir;

    @Override
    public void close() {
        ProfilerInitializer.unregister(this.profileDir);
    }

    public final void projectEvaluated(@NotNull Gradle gradle) {
        Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
        gradle.allprojects((Action)new Action<Project>(this){
            final /* synthetic */ ProfileCleanupBuildService this$0;

            public final void execute(Project it) {
                Project project2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"it");
                ProfileCleanupBuildService.access$collectProjectInfo(this.this$0, project2);
            }
            {
                this.this$0 = profileCleanupBuildService;
            }
        });
        if (((Parameters)this.getParameters()).getProfileDir().getOrNull() != null) {
            this.profileDir = gradle.getRootProject().file(((Parameters)this.getParameters()).getProfileDir().get()).toPath();
        } else if (Intrinsics.areEqual((Object)((Boolean)((Parameters)this.getParameters()).getEnableJsonProfile().get()), (Object)true)) {
            Project project2 = gradle.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"gradle.rootProject");
            this.profileDir = project2.getBuildDir().toPath().resolve("android-profile");
        }
        if (this.profileDir != null) {
            Path path = this.profileDir;
            if (path == null) {
                Intrinsics.throwNpe();
            }
            Path extraChromeTracePath = path.resolve("extra_chrome_trace");
            try {
                PathUtils.deleteRecursivelyIfExists((Path)extraChromeTracePath);
            }
            catch (IOException e) {
                Logging.getLogger(ProfileCleanupBuildService.class).warn("Cannot extra Chrome trace directory " + extraChromeTracePath + ". The generated" + "Chrome trace file may contain stale data.", (Throwable)e);
            }
        }
    }

    private final void collectProjectInfo(Project project2) {
        GradleBuildProject.Builder analyticsProject = ProcessProfileWriter.getProject((String)project2.getPath());
        project2.getPlugins().all((Action)new Action<Plugin<Object>>(analyticsProject){
            final /* synthetic */ GradleBuildProject.Builder $analyticsProject;

            public final void execute(@NotNull Plugin<?> plugin) {
                Intrinsics.checkParameterIsNotNull(plugin, (String)"plugin");
                this.$analyticsProject.addPlugin(AnalyticsUtil.toProto(plugin));
            }
            {
                this.$analyticsProject = builder;
            }
        });
    }

    public static final /* synthetic */ void access$collectProjectInfo(ProfileCleanupBuildService $this, Project project2) {
        $this.collectProjectInfo(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "enableJsonProfile", "Lorg/gradle/api/provider/Property;", "", "getEnableJsonProfile", "()Lorg/gradle/api/provider/Property;", "profileDir", "", "getProfileDir", "gradle"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getProfileDir();

        @NotNull
        public Property<Boolean> getEnableJsonProfile();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService;", "Lcom/android/build/gradle/internal/profile/ProfileCleanupBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "profileDir", "", "enableJsonProfile", "", "(Lorg/gradle/api/Project;Ljava/lang/String;Z)V", "configure", "", "parameters", "gradle"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<ProfileCleanupBuildService, Parameters> {
        private final String profileDir;
        private final boolean enableJsonProfile;

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            parameters.getProfileDir().set((Object)this.profileDir);
            parameters.getEnableJsonProfile().set((Object)this.enableJsonProfile);
        }

        public RegistrationAction(@NotNull Project project2, @Nullable String profileDir, boolean enableJsonProfile) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            super(project2, ProfileCleanupBuildService.class);
            this.profileDir = profileDir;
            this.enableJsonProfile = enableJsonProfile;
        }
    }
}

