/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.internal.core.MergedOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MergedNdkConfig
implements CoreNdkOptions,
MergedOptions<CoreNdkOptions> {
    private String moduleName;
    private String cFlags;
    private List<String> ldLibs;
    private final Set<String> abiFilters = new HashSet<String>(0);
    private String stl;
    private Integer jobs;
    private String debugSymbolLevel;

    @Override
    public void reset() {
        this.moduleName = null;
        this.cFlags = null;
        this.ldLibs = null;
        this.abiFilters.clear();
        this.debugSymbolLevel = null;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getcFlags() {
        return this.cFlags;
    }

    @Override
    public List<String> getLdLibs() {
        return this.ldLibs;
    }

    @Override
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Override
    public String getStl() {
        return this.stl;
    }

    @Override
    public Integer getJobs() {
        return this.jobs;
    }

    @Override
    public String getDebugSymbolLevel() {
        return this.debugSymbolLevel;
    }

    public NdkOptions.DebugSymbolLevel getDebugSymbolLevelEnum() {
        NdkOptions.DebugSymbolLevel debugSymbolLevelOrNull = (NdkOptions.DebugSymbolLevel)((Object)NdkOptions.DEBUG_SYMBOL_LEVEL_CONVERTER.convert((Object)this.debugSymbolLevel));
        return debugSymbolLevelOrNull == null ? NdkOptions.DebugSymbolLevel.NONE : debugSymbolLevelOrNull;
    }

    @Override
    public void append(CoreNdkOptions ndkConfig) {
        if (ndkConfig.getModuleName() != null) {
            this.moduleName = ndkConfig.getModuleName();
        }
        if (ndkConfig.getStl() != null) {
            this.stl = ndkConfig.getStl();
        }
        if (ndkConfig.getJobs() != null) {
            this.jobs = ndkConfig.getJobs();
        }
        if (ndkConfig.getDebugSymbolLevel() != null) {
            this.debugSymbolLevel = ndkConfig.getDebugSymbolLevel();
        }
        this.abiFilters.addAll(ndkConfig.getAbiFilters());
        if (this.cFlags == null) {
            this.cFlags = ndkConfig.getcFlags();
        } else if (ndkConfig.getcFlags() != null && !ndkConfig.getcFlags().isEmpty()) {
            this.cFlags = this.cFlags + " " + ndkConfig.getcFlags();
        }
        if (ndkConfig.getLdLibs() != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Lists.newArrayListWithCapacity((int)ndkConfig.getLdLibs().size());
            }
            this.ldLibs.addAll(ndkConfig.getLdLibs());
        }
    }
}

