/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.internal.component.BaseCreationConfig;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0007J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00150\u0014H\u0002R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Ljava/io/File;", "fakeOutputDir", "getFakeOutputDir", "()Ljava/io/File;", "featureTransitiveDeps", "Lorg/gradle/api/artifacts/ArtifactCollection;", "doTaskAction", "", "getFeatureTransitiveDepsFiles", "Lorg/gradle/api/file/FileCollection;", "updateLibraryMap", "", "file", "projectPath", "", "map", "", "", "CreationAction", "gradle"})
public abstract class CheckMultiApkLibrariesTask
extends NonIncrementalTask {
    private ArtifactCollection featureTransitiveDeps;
    @NotNull
    private File fakeOutputDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureTransitiveDepsFiles() {
        ArtifactCollection artifactCollection = this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"featureTransitiveDeps.artifactFiles");
        return fileCollection2;
    }

    @OutputDirectory
    @NotNull
    public final File getFakeOutputDir() {
        File file = this.fakeOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        }
        return file;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doTaskAction() {
        var2_1 = false;
        map = new LinkedHashMap<K, V>();
        found = false;
        v0 = this.featureTransitiveDeps;
        if (v0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        var4_3 = v0.iterator();
        while (var4_3.hasNext()) {
            v1 = artifact = (ResolvedArtifactResult)var4_3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"artifact");
            v2 = v1.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"artifact.id");
            if (!(v2.getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                v3 = new StringBuilder();
                v4 = artifact.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"artifact.id");
                v5 = v4.getComponentIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"artifact.id.componentIdentifier");
                throw (Throwable)new GradleException(v3.append(v5.getDisplayName()).append(" is not a Gradle project.").toString());
            }
            v6 = artifact.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"artifact.id");
            v7 = v6.getComponentIdentifier();
            if (v7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            }
            projectPath = ((ProjectComponentIdentifier)v7).getProjectPath();
            v8 = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"artifact.file");
            if (!v8.isFile()) continue;
            if (found) ** GOTO lbl-1000
            v9 = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"artifact.file");
            v10 = projectPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"projectPath");
            if (this.updateLibraryMap(v9, v10, map)) lbl-1000:
            // 2 sources

            {
                v11 = true;
            } else {
                v11 = false;
            }
            found = v11;
        }
        if (found) {
            output = new StringBuilder();
            var6_6 = MapsKt.toSortedMap((Map)map);
            var7_7 = false;
            var5_5 = var6_6.entrySet().iterator();
            while (var5_5.hasNext()) {
                var8_9 = var4_3 = var5_5.next();
                var9_10 = false;
                var6_6 = (String)var8_9.getKey();
                var8_9 = var4_3;
                var9_10 = false;
                projectPaths = (List)var8_9.getValue();
                if (projectPaths.size() <= 1) continue;
                v12 = projectPaths;
                Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"projectPaths");
                output.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)v12), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null)).append(" all package the same library [" + (String)library + "].\n");
            }
            output.append("\nMultiple APKs packaging the same library can cause runtime errors.\nPlacing each of the above libraries in its own dynamic feature and adding that\nfeature as a dependency of modules requiring it will resolve this issue.\nLibraries that are always used together can be combined into a single feature\nmodule to be imported by their dependents. If a library is required by all\nfeature modules it can be added to the base module instead.");
            throw (Throwable)new GradleException(output.toString());
        }
    }

    private final boolean updateLibraryMap(File file, String projectPath, Map<String, List<String>> map) {
        boolean found = false;
        Iterator iterator = Files.readLines((File)file, (Charset)Charsets.UTF_8).iterator();
        while (iterator.hasNext()) {
            String library;
            String string = library = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"library");
            String libraryWithoutVariant = StringsKt.substringBeforeLast$default((String)string, (String)"::", null, (int)2, null);
            if (map.containsKey(libraryWithoutVariant)) {
                found = true;
                List<String> list = map.get(libraryWithoutVariant);
                if (list != null) {
                    list.add(projectPath);
                }
                continue;
            }
            map.put(libraryWithoutVariant, CollectionsKt.mutableListOf((Object[])new String[]{projectPath}));
        }
        return found;
    }

    public static final /* synthetic */ ArtifactCollection access$getFeatureTransitiveDeps$p(CheckMultiApkLibrariesTask $this) {
        ArtifactCollection artifactCollection = $this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
        }
        return artifactCollection;
    }

    public static final /* synthetic */ File access$getFakeOutputDir$p(CheckMultiApkLibrariesTask $this) {
        File file = $this.fakeOutputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        }
        return file;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/api/component/impl/ComponentPropertiesImpl;", "componentProperties", "(Lcom/android/build/api/component/impl/ComponentPropertiesImpl;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckMultiApkLibrariesTask, ComponentPropertiesImpl> {
        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("check", "Libraries");
        }

        @Override
        @NotNull
        public Class<CheckMultiApkLibrariesTask> getType() {
            return CheckMultiApkLibrariesTask.class;
        }

        @Override
        public void configure(@NotNull CheckMultiApkLibrariesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ArtifactCollection artifactCollection = ((ComponentPropertiesImpl)this.creationConfig).getVariantDependencies().getArtifactCollection(AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"creationConfig.variantDe\u2026IES\n                    )");
            task.featureTransitiveDeps = artifactCollection;
            File file = FileUtils.join((File)((ComponentPropertiesImpl)this.creationConfig).getGlobalScope().getIntermediatesDir(), (String[])new String[]{"check-libraries", ((ComponentPropertiesImpl)this.creationConfig).getDirName()});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtils.join(\n        \u2026ame\n                    )");
            task.fakeOutputDir = file;
        }

        public CreationAction(@NotNull ComponentPropertiesImpl componentProperties) {
            Intrinsics.checkParameterIsNotNull((Object)componentProperties, (String)"componentProperties");
            super((BaseCreationConfig)componentProperties, false);
        }
    }
}

