/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.profile;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.profile.GradleAnalyticsEnvironment;
import com.android.build.gradle.internal.profile.ProfileAgent;
import com.android.build.gradle.internal.profile.ProfileCleanupBuildService;
import com.android.build.gradle.internal.profile.RecordingBuildListener;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.tools.analytics.Environment;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;

public final class ProfilerInitializer {
    public static final String PROFILE_DIRECTORY = "android-profile";
    private static final DateTimeFormatter PROFILE_FILE_NAME = DateTimeFormatter.ofPattern("'profile-'yyyy-MM-dd-HH-mm-ss-SSS'.rawproto'", Locale.US);
    private static final Object lock = new Object();
    private static volatile RecordingBuildListener recordingBuildListener;
    private static volatile Gradle gradle;
    private static volatile GradleAnalyticsEnvironment gradleAnalyticsEnvironment;

    private ProfilerInitializer() {
    }

    public static RecordingBuildListener getListener() {
        return recordingBuildListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordingBuildListener init(Project project2, ProjectOptions projectOptions) {
        Object object = lock;
        synchronized (object) {
            if (recordingBuildListener != null) {
                return recordingBuildListener;
            }
            gradleAnalyticsEnvironment = new GradleAnalyticsEnvironment(project2.getProviders());
            ProcessProfileWriterFactory.initialize((File)project2.getRootProject().getProjectDir(), (String)project2.getGradle().getGradleVersion(), (ILogger)new LoggerWrapper(project2.getLogger()), (boolean)projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON), (Environment)gradleAnalyticsEnvironment);
            recordingBuildListener = new RecordingBuildListener(project2.getName(), (ProfileRecordWriter)ProcessProfileWriter.get());
            gradle = project2.getGradle();
            project2.getGradle().getTaskGraph().addTaskExecutionListener((TaskExecutionListener)recordingBuildListener);
        }
        ProfileCleanupBuildService profileCleanupBuildService = (ProfileCleanupBuildService)new ProfileCleanupBuildService.RegistrationAction(project2, projectOptions.get(StringOption.PROFILE_OUTPUT_DIR), projectOptions.get(BooleanOption.ENABLE_PROFILE_JSON)).execute().get();
        project2.getGradle().projectsEvaluated(profileCleanupBuildService::projectEvaluated);
        return recordingBuildListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregister(Path profileDir) {
        Object object = lock;
        synchronized (object) {
            ProfileAgent.INSTANCE.unregister();
            if (recordingBuildListener != null) {
                Objects.requireNonNull(gradle).getTaskGraph().removeTaskExecutionListener((TaskExecutionListener)Objects.requireNonNull(recordingBuildListener));
                recordingBuildListener = null;
                gradle = null;
                Objects.requireNonNull(gradleAnalyticsEnvironment).releaseProviderFactory();
                gradleAnalyticsEnvironment = null;
                Path profileFile = profileDir == null ? null : profileDir.resolve(PROFILE_FILE_NAME.format(LocalDateTime.now()));
                ProcessProfileWriterFactory.shutdownAndMaybeWrite(profileFile);
            }
        }
    }
}

