/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.cxx.caching.CachingEnvironmentKt;
import com.android.build.gradle.internal.cxx.caching.ThreadCachingEnvironment;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorKey;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.cxx.configure.SdkSourceProperties;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughDeduplicatingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.InvalidUserDataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u001a2\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a`\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u001a&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\bH\u0007\u001a\u0012\u0010\u0017\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0019\u001a\u00020\bH\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"ANDROID_GRADLE_PLUGIN_FIXED_DEFAULT_NDK_VERSION", "", "findNdkPathImpl", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "userSettings", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorKey;", "getNdkSourceProperties", "Lkotlin/Function1;", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/configure/SdkSourceProperties;", "sdkHandler", "Lcom/android/build/gradle/internal/SdkHandler;", "ndkVersionFromDsl", "ndkPathFromDsl", "ndkDirProperty", "sdkFolder", "ndkVersionedFolderNames", "", "getNdkFolderParsedRevision", "Lcom/android/repository/Revision;", "ndkDirFolder", "getNdkVersionInfo", "ndkRoot", "getNdkVersionOrDefault", "getNdkVersionedFolders", "ndkVersionRoot", "logUserInputs", "", "parseRevision", "version", "stripPreviewFromRevision", "revision", "gradle"})
public final class NdkLocatorKt {
    @NotNull
    public static final String ANDROID_GRADLE_PLUGIN_FIXED_DEFAULT_NDK_VERSION = "21.1.6352462";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final NdkLocatorRecord findNdkPathImpl(NdkLocatorKey userSettings, Function1<? super File, SdkSourceProperties> getNdkSourceProperties, SdkHandler sdkHandler2) {
        Object ndkPathFolder;
        boolean bl = false;
        boolean bl2 = false;
        NdkLocatorKey $this$with = userSettings;
        boolean bl3 = false;
        NdkLocatorKt.logUserInputs(userSettings);
        Function1<File, Revision> $fun$getNdkFolderRevision$1 = new Function1<File, Revision>(userSettings, getNdkSourceProperties, sdkHandler2){
            final /* synthetic */ NdkLocatorKey $userSettings$inlined;
            final /* synthetic */ Function1 $getNdkSourceProperties$inlined;
            final /* synthetic */ SdkHandler $sdkHandler$inlined;
            {
                this.$userSettings$inlined = ndkLocatorKey;
                this.$getNdkSourceProperties$inlined = function1;
                this.$sdkHandler$inlined = sdkHandler2;
                super(1);
            }

            @Nullable
            public final Revision invoke(@NotNull File ndkDirFolder) {
                Intrinsics.checkParameterIsNotNull((Object)ndkDirFolder, (String)"ndkDirFolder");
                return NdkLocatorKt.getNdkFolderParsedRevision(ndkDirFolder, (Function1<? super File, SdkSourceProperties>)this.$getNdkSourceProperties$inlined);
            }
        };
        Revision revision = NdkLocatorKt.parseRevision(NdkLocatorKt.getNdkVersionOrDefault($this$with.getNdkVersionFromDsl()));
        if (revision == null) {
            return null;
        }
        Revision revisionFromNdkVersion = revision;
        CharSequence charSequence = $this$with.getNdkPathFromDsl();
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ndkPathFolder = new File($this$with.getNdkPathFromDsl());
            Revision revisionFromNdkPath = $fun$getNdkFolderRevision$1.invoke((File)ndkPathFolder);
            if (revisionFromNdkPath == null) {
                LoggingEnvironmentKt.errorln("Location specified by android.ndkPath (" + $this$with.getNdkPathFromDsl() + ") did not contain " + "a valid NDK and couldn't be used", new Object[0]);
                return null;
            }
            CharSequence charSequence2 = $this$with.getNdkDirProperty();
            boolean bl6 = false;
            boolean bl7 = false;
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                LoggingEnvironmentKt.errorln("Both android.ndkPath and ndk.dir in local.properties are set", new Object[0]);
                return null;
            }
            charSequence2 = $this$with.getNdkVersionFromDsl();
            bl6 = false;
            bl7 = false;
            if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) && Intrinsics.areEqual((Object)revisionFromNdkVersion, (Object)revisionFromNdkPath) ^ true) {
                LoggingEnvironmentKt.errorln("android.ndkVersion is [" + revisionFromNdkVersion + "] " + "but android.ndkPath " + ndkPathFolder + " refers to a different version " + '[' + revisionFromNdkPath + "].", new Object[0]);
                return null;
            }
            return new NdkLocatorRecord((File)ndkPathFolder, revisionFromNdkPath);
        }
        ndkPathFolder = $this$with.getNdkDirProperty();
        boolean revisionFromNdkPath = false;
        bl5 = false;
        if (!(ndkPathFolder == null || StringsKt.isBlank((CharSequence)ndkPathFolder))) {
            File ndkDirFolder = new File($this$with.getNdkDirProperty());
            Revision revision2 = $fun$getNdkFolderRevision$1.invoke(ndkDirFolder);
            if (revision2 != null) {
                NdkLocatorRecord ndkLocatorRecord;
                if (Intrinsics.areEqual((Object)revision2, (Object)revisionFromNdkVersion) ^ true && $this$with.getNdkVersionFromDsl() != null) {
                    LoggingEnvironmentKt.errorln("NDK from ndk.dir at " + ndkDirFolder + " had version [" + revision2 + "] " + "which disagrees with android.ndkVersion [" + revisionFromNdkVersion + ']', new Object[0]);
                    return null;
                }
                NdkLocatorRecord resolutionWithNdkDir = new NdkLocatorRecord(ndkDirFolder, revision2);
                LoggingEnvironmentKt.infoln("Checking whether deleting ndk.dir and setting " + "android.ndkVersion to [" + revision2 + "] would result in the same NDK", new Object[0]);
                AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(null, "ndk.dir delete check", true, 1, null);
                boolean bl8 = false;
                Throwable throwable = null;
                try {
                    PassThroughPrefixingLoggingEnvironment it = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
                    boolean bl9 = false;
                    NdkLocatorRecord resolutionWithoutNdkDir = NdkLocatorKt.findNdkPathImpl(NdkLocatorKey.copy$default(userSettings, revision2.toString(), null, null, null, null, 26, null), getNdkSourceProperties, null);
                    if (Intrinsics.areEqual((Object)resolutionWithoutNdkDir, (Object)resolutionWithNdkDir)) {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to " + '[' + revision2 + "] would result in the same NDK.", new Object[0]);
                    } else {
                        LoggingEnvironmentKt.infoln("Deleting ndk.dir and setting android.ndkVersion to " + '[' + revision2 + "] would *not* result in the same NDK.", new Object[0]);
                    }
                    ndkLocatorRecord = resolutionWithoutNdkDir;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                NdkLocatorRecord resolutionWithoutNdkDir = ndkLocatorRecord;
                if (Intrinsics.areEqual((Object)resolutionWithNdkDir, (Object)resolutionWithoutNdkDir)) {
                    LoggingEnvironmentKt.warnln("NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please delete ndk.dir from local.properties and set android.ndkVersion " + "to [" + revision2 + "] in all native modules in the project. " + "https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                if (resolutionWithoutNdkDir == null) {
                    LoggingEnvironmentKt.warnln("NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. Please use android.ndkVersion or android.ndkPath in build.gradle to specify the NDK to use. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                    return resolutionWithNdkDir;
                }
                LoggingEnvironmentKt.warnln("NDK was located by using ndk.dir property. This method is deprecated and will be removed in a future release. If you delete ndk.dir from local.properties and set android.ndkVersion to " + '[' + revision2 + "] then NDK at " + resolutionWithoutNdkDir.getNdk() + " will be " + "used. https://developer.android.com/r/studio-ui/ndk-dir", new Object[0]);
                return resolutionWithNdkDir;
            }
            LoggingEnvironmentKt.errorln("Location specified by ndk.dir (" + $this$with.getNdkDirProperty() + ") did not contain a valid " + "NDK and couldn't be used", new Object[0]);
            return null;
        }
        if ($this$with.getSdkFolder() != null) {
            File versionedNdkPath = new File(new File($this$with.getSdkFolder(), "ndk"), String.valueOf(revisionFromNdkVersion));
            Revision sideBySideRevision = $fun$getNdkFolderRevision$1.invoke(versionedNdkPath);
            if (sideBySideRevision != null) {
                return new NdkLocatorRecord(versionedNdkPath, sideBySideRevision);
            }
            File ndkBundlePath = new File($this$with.getSdkFolder(), "ndk-bundle");
            Revision bundleRevision = $fun$getNdkFolderRevision$1.invoke(ndkBundlePath);
            if (bundleRevision != null && Intrinsics.areEqual((Object)bundleRevision, (Object)revisionFromNdkVersion)) {
                return new NdkLocatorRecord(ndkBundlePath, bundleRevision);
            }
        }
        if (sdkHandler2 == null) {
            return null;
        }
        LoggingEnvironmentKt.infoln("No NDK was found. Trying to download it now.", new Object[0]);
        File downloaded = sdkHandler2.installNdk(revisionFromNdkVersion);
        if (downloaded != null) {
            LoggingEnvironmentKt.infoln("NDK " + revisionFromNdkVersion + " was downloaded to " + downloaded + ". Using that.", new Object[0]);
            return new NdkLocatorRecord(downloaded, revisionFromNdkVersion);
        }
        throw (Throwable)new InvalidUserDataException("NDK not configured. Download it with SDK manager. Preferred NDK version is '21.1.6352462'. ");
    }

    @Nullable
    public static final Revision getNdkFolderParsedRevision(@NotNull File ndkDirFolder, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties) {
        Intrinsics.checkParameterIsNotNull((Object)ndkDirFolder, (String)"ndkDirFolder");
        Intrinsics.checkParameterIsNotNull(getNdkSourceProperties, (String)"getNdkSourceProperties");
        SdkSourceProperties properties = (SdkSourceProperties)getNdkSourceProperties.invoke((Object)ndkDirFolder);
        if (properties == null) {
            LoggingEnvironmentKt.infoln("Folder " + ndkDirFolder + " does not exist. Ignoring.", new Object[0]);
            return null;
        }
        String packageRevision = properties.getValue(SdkSourceProperties.Companion.SdkSourceProperty.SDK_PKG_REVISION);
        if (packageRevision == null) {
            LoggingEnvironmentKt.errorln("Folder " + ndkDirFolder + " has no Pkg.Revision in source.properties. Ignoring.", new Object[0]);
            return null;
        }
        return NdkLocatorKt.parseRevision(packageRevision);
    }

    private static final void logUserInputs(NdkLocatorKey userSettings) {
        boolean bl = false;
        boolean bl2 = false;
        NdkLocatorKey $this$with = userSettings;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder().append("android.ndkVersion from module build.gradle is [");
        String string = $this$with.getNdkVersionFromDsl();
        if (string == null) {
            string = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder.append(string).append(']').toString(), new Object[0]);
        StringBuilder stringBuilder2 = new StringBuilder().append("android.ndkPath from module build.gradle is ");
        String string2 = $this$with.getNdkPathFromDsl();
        if (string2 == null) {
            string2 = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder2.append(string2).toString(), new Object[0]);
        StringBuilder stringBuilder3 = new StringBuilder().append("ndk.dir in local.properties is ");
        String string3 = $this$with.getNdkDirProperty();
        if (string3 == null) {
            string3 = "not set";
        }
        LoggingEnvironmentKt.infoln(stringBuilder3.append(string3).toString(), new Object[0]);
        LoggingEnvironmentKt.infoln("Not considering ANDROID_NDK_HOME because support was removed after deprecation period.", new Object[0]);
        if ($this$with.getSdkFolder() != null) {
            File sxsRoot;
            LoggingEnvironmentKt.infoln("sdkFolder is " + $this$with.getSdkFolder(), new Object[0]);
            File file = sxsRoot = FileUtils.join((File)$this$with.getSdkFolder(), (String[])new String[]{"ndk"});
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sxsRoot");
            if (!file.isDirectory()) {
                LoggingEnvironmentKt.infoln("NDK side-by-side folder from sdkFolder " + sxsRoot + " does not exist", new Object[0]);
            }
        } else {
            LoggingEnvironmentKt.infoln("sdkFolder is not set", new Object[0]);
        }
    }

    private static final String getNdkVersionOrDefault(String ndkVersionFromDsl) {
        String string;
        CharSequence charSequence = ndkVersionFromDsl;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            LoggingEnvironmentKt.infoln("Because no explicit NDK was requested, the default version [21.1.6352462] for this Android Gradle Plugin will be used", new Object[0]);
            string = ANDROID_GRADLE_PLUGIN_FIXED_DEFAULT_NDK_VERSION;
        } else {
            string = ndkVersionFromDsl;
        }
        return string;
    }

    private static final Revision parseRevision(String version) {
        try {
            Revision revision = Revision.parseRevision((String)version);
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(version)");
            Revision revision2 = NdkLocatorKt.stripPreviewFromRevision(revision);
            if (revision2.toIntArray(true).length < 3) {
                LoggingEnvironmentKt.errorln("Specified NDK version [" + version + "] does not have " + "enough precision. Use major.minor.micro in version.", new Object[0]);
                return null;
            }
            return revision2;
        }
        catch (NumberFormatException e) {
            LoggingEnvironmentKt.errorln("Requested NDK version '" + version + "' could not be parsed", new Object[0]);
            return null;
        }
    }

    @VisibleForTesting
    @Nullable
    public static final SdkSourceProperties getNdkVersionInfo(@NotNull File ndkRoot) {
        Intrinsics.checkParameterIsNotNull((Object)ndkRoot, (String)"ndkRoot");
        if (!ndkRoot.exists()) {
            return null;
        }
        File sourceProperties = new File(ndkRoot, "source.properties");
        if (!sourceProperties.exists()) {
            File releaseTxt = FilesKt.resolve((File)ndkRoot, (String)"RELEASE.TXT");
            if (releaseTxt.exists()) {
                LoggingEnvironmentKt.errorln("NDK at " + ndkRoot + " is not supported (pre-r11)", new Object[0]);
                return null;
            }
            LoggingEnvironmentKt.errorln("NDK at " + ndkRoot + " did not have a source.properties file", new Object[0]);
            return null;
        }
        return SdkSourceProperties.Companion.fromInstallFolder(ndkRoot);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<String> getNdkVersionedFolders(@NotNull File ndkVersionRoot) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)ndkVersionRoot, (String)"ndkVersionRoot");
        if (!ndkVersionRoot.isDirectory()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        String[] stringArray = ndkVersionRoot.list();
        if (stringArray == null) {
            Intrinsics.throwNpe();
        }
        String[] $this$filter$iv = stringArray;
        boolean $i$f$filter = false;
        String[] stringArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var6_7 = $this$filterTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var6_7[j];
            boolean bl = false;
            if (!new File(ndkVersionRoot, (String)it).isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Revision stripPreviewFromRevision(Revision revision) {
        Revision revision2;
        int[] parts = revision.toIntArray(false);
        switch (parts.length) {
            case 1: {
                revision2 = new Revision(parts[0]);
                break;
            }
            case 2: {
                revision2 = new Revision(parts[0], parts[1]);
                break;
            }
            default: {
                revision2 = new Revision(parts[0], parts[1], parts[2]);
            }
        }
        return revision2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public static final NdkLocatorRecord findNdkPathImpl(@Nullable String ndkVersionFromDsl, @Nullable String ndkPathFromDsl, @Nullable String ndkDirProperty, @Nullable File sdkFolder2, @NotNull List<String> ndkVersionedFolderNames, @NotNull Function1<? super File, SdkSourceProperties> getNdkSourceProperties, @Nullable SdkHandler sdkHandler2) {
        NdkLocatorRecord ndkLocatorRecord;
        String baseName$iv;
        Intrinsics.checkParameterIsNotNull(ndkVersionedFolderNames, (String)"ndkVersionedFolderNames");
        Intrinsics.checkParameterIsNotNull(getNdkSourceProperties, (String)"getNdkSourceProperties");
        NdkLocatorKey key = new NdkLocatorKey(ndkVersionFromDsl, ndkPathFromDsl, ndkDirProperty, sdkFolder2, ndkVersionedFolderNames);
        boolean $i$f$cache = false;
        String string = baseName$iv = NdkLocatorRecord.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"baseName");
        NdkLocatorRecord prior$iv = ThreadCachingEnvironment.Companion.readInCurrentEnvironment(key, string, NdkLocatorRecord.class);
        if (prior$iv != null) {
            ndkLocatorRecord = prior$iv;
        } else {
            AutoCloseable autoCloseable = new PassThroughDeduplicatingLoggingEnvironment();
            boolean bl = false;
            Throwable throwable = null;
            PassThroughDeduplicatingLoggingEnvironment logger$iv = (PassThroughDeduplicatingLoggingEnvironment)autoCloseable;
            boolean bl2 = false;
            try {
                NdkLocatorRecord ndkLocatorRecord2;
                boolean bl3 = false;
                AutoCloseable autoCloseable2 = new PassThroughDeduplicatingLoggingEnvironment();
                boolean bl4 = false;
                Throwable throwable2 = null;
                try {
                    PassThroughDeduplicatingLoggingEnvironment it = (PassThroughDeduplicatingLoggingEnvironment)autoCloseable2;
                    boolean bl5 = false;
                    ndkLocatorRecord2 = NdkLocatorKt.findNdkPathImpl(key, getNdkSourceProperties, sdkHandler2);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                NdkLocatorRecord computed$iv = ndkLocatorRecord2;
                ThreadCachingEnvironment.Companion.writeInCurrentEnvironment(key, CachingEnvironmentKt.snakeCase(baseName$iv), computed$iv, logger$iv.getRecord(), NdkLocatorRecord.class);
                NdkLocatorRecord ndkLocatorRecord3 = computed$iv;
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                ndkLocatorRecord = ndkLocatorRecord3;
            }
            catch (Exception e$iv) {
                try {
                    try {
                        ThreadCachingEnvironment.Companion.writeFailureInCurrentEnvironment(key, CachingEnvironmentKt.snakeCase(baseName$iv), e$iv, logger$iv.getRecord(), NdkLocatorRecord.class);
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    throw throwable5;
                }
            }
        }
        return ndkLocatorRecord;
    }
}

