/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.InstallableVariant;
import com.android.build.gradle.internal.api.AndroidArtifactVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.services.BaseServices;
import com.android.build.gradle.internal.variant.ApkVariantData;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class InstallableVariantImpl
extends AndroidArtifactVariantImpl
implements InstallableVariant {
    protected InstallableVariantImpl(ComponentPropertiesImpl componentProperties, BaseServices services2, ReadOnlyObjectProvider immutableObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        super(componentProperties, services2, immutableObjectProvider, outputs);
    }

    @Override
    public abstract ApkVariantData getVariantData();

    @Override
    public DefaultTask getInstall() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getInstallProvider()", "variantOutput.getInstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (this.componentProperties.getTaskContainer().getInstallTask() != null) {
            return (DefaultTask)this.componentProperties.getTaskContainer().getInstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getInstallProvider() {
        return this.componentProperties.getTaskContainer().getInstallTask();
    }

    @Override
    public DefaultTask getUninstall() {
        this.services.getDeprecationReporter().reportDeprecatedApi("variantOutput.getUninstallProvider()", "variantOutput.getUninstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (this.componentProperties.getTaskContainer().getUninstallTask() != null) {
            return (DefaultTask)this.componentProperties.getTaskContainer().getUninstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getUninstallProvider() {
        return this.componentProperties.getTaskContainer().getUninstallTask();
    }

    @Incubating
    public Provider<FileCollection> getFinalArtifact(Artifact<? extends FileSystemLocation> artifactType) {
        return this.componentProperties.getGlobalScope().getProject().getProviders().provider(() -> this.componentProperties.getServices().fileCollection(this.componentProperties.getArtifacts().get((InternalArtifactType)artifactType)));
    }
}

