/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.component.impl.ComponentPropertiesImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.component.impl.TestComponentPropertiesImpl;
import com.android.build.api.dsl.PrefabPackagingOptions;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.LibraryVariantPropertiesImpl;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.cxx.gradle.generator.ExternalNativeJsonGenerator;
import com.android.build.gradle.internal.dependency.ConfigurationVariantMapping;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.GenerateEmptyResourceFilesTask;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AarMetadataTask;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesDir;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesJar;
import com.android.build.gradle.internal.tasks.BundleLibraryJavaRes;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.PrefabModuleTaskData;
import com.android.build.gradle.internal.tasks.PrefabPackageTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessLibraryManifest;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.errors.IssueReporter;
import com.android.builder.profile.Recorder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;

public class LibraryTaskManager
extends TaskManager<LibraryVariantImpl, LibraryVariantPropertiesImpl> {
    public LibraryTaskManager(List<ComponentInfo<LibraryVariantImpl, LibraryVariantPropertiesImpl>> variants, List<ComponentInfo<TestComponentImpl<? extends TestComponentPropertiesImpl>, TestComponentPropertiesImpl>> testComponents, boolean hasFlavors, GlobalScope globalScope, BaseExtension extension, Recorder recorder) {
        super(variants, testComponents, hasFlavors, globalScope, extension, recorder);
    }

    @Override
    protected void doCreateTasksForVariant(ComponentInfo<LibraryVariantImpl, LibraryVariantPropertiesImpl> variant2, List<ComponentInfo<LibraryVariantImpl, LibraryVariantPropertiesImpl>> allVariants) {
        LibraryVariantPropertiesImpl libVariantProperties = variant2.getProperties();
        BuildFeatureValues buildFeatures = libVariantProperties.getBuildFeatures();
        this.createAnchorTasks(libVariantProperties);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(libVariantProperties));
        this.createDependencyStreams(libVariantProperties);
        if (buildFeatures.getAndroidResources()) {
            this.createGenerateResValuesTask(libVariantProperties);
        } else {
            if (this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
                this.getLogger().error("Disabling resource processing in resource namespace aware modules is not supported currently.");
            }
            this.taskFactory.register(new GenerateEmptyResourceFilesTask.CreateAction(libVariantProperties));
        }
        this.taskFactory.register(new CheckManifest.CreationAction(libVariantProperties));
        this.taskFactory.register(new ProcessLibraryManifest.CreationAction(libVariantProperties));
        this.createRenderscriptTask(libVariantProperties);
        if (buildFeatures.getAndroidResources()) {
            this.createMergeResourcesTasks(libVariantProperties);
            this.createCompileLibraryResourcesTask(libVariantProperties);
        }
        this.createShaderTask(libVariantProperties);
        this.createMergeAssetsTask(libVariantProperties);
        this.createLibraryAssetsTask(libVariantProperties);
        this.createBuildConfigTask(libVariantProperties);
        if (buildFeatures.getAndroidResources()) {
            this.createProcessResTask(libVariantProperties, null, TaskManager.MergeType.PACKAGE, this.globalScope.getProjectBaseName());
            if (!libVariantProperties.getVariantDslInfo().isDebuggable() && !this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
                this.createVerifyLibraryResTask(libVariantProperties);
            }
            this.registerLibraryRClassTransformStream(libVariantProperties);
        }
        this.createProcessJavaResTask(libVariantProperties);
        this.createAidlTask(libVariantProperties);
        this.createDataBindingTasksIfNecessary(libVariantProperties);
        this.createMlkitTask(libVariantProperties);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(libVariantProperties);
        this.addJavacClassesStream(libVariantProperties);
        TaskManager.setJavaCompilerTask(javacTask, libVariantProperties);
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(libVariantProperties));
        this.createExternalNativeBuildJsonGenerators(libVariantProperties);
        this.createExternalNativeBuildTasks(libVariantProperties);
        this.createMergeJniLibFoldersTasks(libVariantProperties);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(libVariantProperties));
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(libVariantProperties));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(libVariantProperties));
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(libVariantProperties));
        this.createPrefabTasks(libVariantProperties);
        if (libVariantProperties.getServices().getProjectOptions().get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(libVariantProperties));
        }
        boolean instrumented = libVariantProperties.getVariantDslInfo().isTestCoverageEnabled();
        TransformManager transformManager = libVariantProperties.getTransformManager();
        if (instrumented) {
            this.createJacocoTask(libVariantProperties);
        }
        List<Transform> customTransforms = this.extension.getTransforms();
        List<List<Object>> customTransformsDependencies = this.extension.getTransformsDependencies();
        IssueReporter issueReporter = libVariantProperties.getServices().getIssueReporter();
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
            if (!difference.isEmpty()) {
                String scopes = difference.toString();
                issueReporter.reportError(IssueReporter.Type.GENERIC, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes));
            }
            List<Object> deps = customTransformsDependencies.get(i2);
            transformManager.addTransform(this.taskFactory, libVariantProperties, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(libVariantProperties.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(libVariantProperties, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
        this.taskFactory.register(new BundleLibraryClassesDir.CreationAction(libVariantProperties));
        this.taskFactory.register(new BundleLibraryJavaRes.CreationAction(libVariantProperties));
        this.taskFactory.register(new ZipMergingTask.CreationAction(libVariantProperties));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectOnlyCreationAction(libVariantProperties, InternalArtifactType.LIBRARY_JNI.INSTANCE));
        this.createMergeJavaResTask(libVariantProperties);
        this.maybeCreateJavaCodeShrinkerTask(libVariantProperties);
        this.taskFactory.register(new LibraryAarJarsTask.CreationAction(libVariantProperties));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectAndLocalJarsCreationAction(libVariantProperties, InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI.INSTANCE));
        this.taskFactory.register(new AarMetadataTask.CreationAction(libVariantProperties));
        this.createLintTasks(libVariantProperties, allVariants);
        this.createBundleTask(libVariantProperties);
    }

    private void registerLibraryRClassTransformStream(VariantPropertiesImpl variantProperties) {
        if (!variantProperties.getBuildFeatures().getAndroidResources()) {
            return;
        }
        QualifiedContent.Scope scopeType = variantProperties.getVariantScope().getCodeShrinker() != null ? QualifiedContent.Scope.PROJECT : QualifiedContent.Scope.PROVIDED_ONLY;
        ConfigurableFileCollection compileRClass = this.project.files(new Object[]{variantProperties.getArtifacts().get(InternalArtifactType.COMPILE_R_CLASS_JAR.INSTANCE)});
        variantProperties.getTransformManager().addStream(OriginalStream.builder(this.project, "compile-only-r-class").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)scopeType).setFileCollection((FileCollection)compileRClass).build());
    }

    private void createBundleTask(VariantPropertiesImpl variantProperties) {
        TaskProvider<BundleAar> bundle = this.taskFactory.register(new BundleAar.CreationAction(variantProperties));
        TaskFactoryUtils.dependsOn(variantProperties.getTaskContainer().getAssembleTask(), bundle);
        VariantDependencies variantDependencies = variantProperties.getVariantDependencies();
        AdhocComponentWithVariants component2 = this.globalScope.getComponentFactory().adhoc(variantProperties.getName());
        Configuration apiPub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.API_PUBLICATION);
        Configuration runtimePub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION);
        component2.addVariantsFromConfiguration(apiPub, (Action)new ConfigurationVariantMapping("compile", false));
        component2.addVariantsFromConfiguration(runtimePub, (Action)new ConfigurationVariantMapping("runtime", false));
        this.project.getComponents().add((Object)component2);
        AdhocComponentWithVariants allVariants = (AdhocComponentWithVariants)this.project.getComponents().findByName("all");
        if (allVariants == null) {
            allVariants = this.globalScope.getComponentFactory().adhoc("all");
            this.project.getComponents().add((Object)allVariants);
        }
        Configuration allApiPub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.ALL_API_PUBLICATION);
        allVariants.addVariantsFromConfiguration(allApiPub, (Action)new ConfigurationVariantMapping("compile", true));
        Configuration allRuntimePub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.ALL_RUNTIME_PUBLICATION);
        allVariants.addVariantsFromConfiguration(allRuntimePub, (Action)new ConfigurationVariantMapping("runtime", true));
        if (this.extension.getDefaultPublishConfig().equals(variantProperties.getName())) {
            VariantHelper.setupArchivesConfig(this.project, variantDependencies.getRuntimeClasspath());
            this.project.getArtifacts().add("default", bundle);
        }
    }

    @Override
    protected void createDependencyStreams(ComponentPropertiesImpl componentProperties) {
        super.createDependencyStreams(componentProperties);
        componentProperties.getTransformManager().addStream(OriginalStream.builder(this.project, "local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(componentProperties.getVariantScope().getLocalPackagedJars()).build());
    }

    private void createMergeResourcesTasks(VariantPropertiesImpl variantProperties) {
        ImmutableSet flags = variantProperties.getGlobalScope().getExtension().getAaptOptions().getNamespaced() ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES}) : Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
        MergeResourceCallback callback = new MergeResourceCallback(variantProperties);
        this.basicCreateMergeResourcesTask(variantProperties, TaskManager.MergeType.PACKAGE, variantProperties.getPaths().getIntermediateDir((Artifact<Directory>)InternalArtifactType.PACKAGED_RES.INSTANCE), false, false, false, (ImmutableSet<MergeResources.Flag>)flags, callback);
        this.createMergeResourcesTask(variantProperties, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
    }

    private void createCompileLibraryResourcesTask(VariantPropertiesImpl variantProperties) {
        if (variantProperties.getVariantScope().isPrecompileDependenciesResourcesEnabled()) {
            this.taskFactory.register(new CompileLibraryResourcesTask.CreationAction(variantProperties));
        }
    }

    @Override
    protected void postJavacCreation(ComponentPropertiesImpl componentProperties) {
        ConfigurableFileCollection files2 = componentProperties.getServices().fileCollection(componentProperties.getArtifacts().get(InternalArtifactType.JAVAC.INSTANCE), componentProperties.getVariantData().getAllPreJavacGeneratedBytecode(), componentProperties.getVariantData().getAllPostJavacGeneratedBytecode());
        componentProperties.getArtifacts().appendToAllClasses((FileCollection)files2);
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(componentProperties, AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
    }

    public void createLibraryAssetsTask(VariantPropertiesImpl variantProperties) {
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(variantProperties));
    }

    public void createPrefabTasks(LibraryVariantPropertiesImpl variantProperties) {
        if (!variantProperties.getBuildFeatures().getPrefabPublishing()) {
            return;
        }
        Provider<ExternalNativeJsonGenerator> generator = variantProperties.getTaskContainer().getExternalNativeJsonGenerator();
        if (generator == null) {
            return;
        }
        LibraryExtension extension = (LibraryExtension)this.globalScope.getExtension();
        ArrayList modules = Lists.newArrayList();
        for (PrefabPackagingOptions options : extension.getPrefab()) {
            String name2 = options.getName();
            if (name2 == null) {
                throw new InvalidUserDataException("prefab modules must specify a name");
            }
            File headers = null;
            if (options.getHeaders() != null) {
                headers = this.project.getLayout().getProjectDirectory().dir(options.getHeaders()).getAsFile();
            }
            modules.add(new PrefabModuleTaskData(name2, headers, options.getLibraryName()));
        }
        if (!modules.isEmpty()) {
            TaskProvider<PrefabPackageTask> packageTask = this.taskFactory.register(new PrefabPackageTask.CreationAction(modules, ((ExternalNativeJsonGenerator)generator.get()).getVariant(), ((ExternalNativeJsonGenerator)generator.get()).getAbis(), variantProperties));
            ((PrefabPackageTask)packageTask.get()).dependsOn(new Object[]{variantProperties.getTaskContainer().getExternalNativeBuildTask()});
        }
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentPropertiesImpl componentProperties, QualifiedContent.ContentType contentType) {
        Preconditions.checkArgument((contentType == QualifiedContent.DefaultContentType.RESOURCES || contentType == ExtendedContentType.NATIVE_LIBS ? 1 : 0) != 0, (Object)"contentType must be RESOURCES or NATIVE_LIBS");
        if (componentProperties.getVariantType().isTestComponent()) {
            if (contentType == QualifiedContent.DefaultContentType.RESOURCES) {
                return TransformManager.SCOPE_FULL_PROJECT_WITH_LOCAL_JARS;
            }
            return TransformManager.SCOPE_FULL_PROJECT;
        }
        if (contentType == QualifiedContent.DefaultContentType.RESOURCES) {
            return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
        }
        return TransformManager.PROJECT_ONLY;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    public void createVerifyLibraryResTask(VariantPropertiesImpl variantProperties) {
        TaskProvider<VerifyLibraryResourcesTask> verifyLibraryResources = this.taskFactory.register(new VerifyLibraryResourcesTask.CreationAction(variantProperties));
        TaskFactoryUtils.dependsOn(variantProperties.getTaskContainer().getAssembleTask(), verifyLibraryResources);
    }

    @Override
    protected void configureGlobalLintTask() {
        super.configureGlobalLintTask();
        for (LibraryVariantPropertiesImpl variant2 : this.variantPropertiesList) {
            variant2.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR.INSTANCE, this.globalScope.getGlobalArtifacts());
        }
    }

    private static class MergeResourceCallback
    implements TaskProviderCallback<MergeResources> {
        private final VariantPropertiesImpl variantProperties;

        private MergeResourceCallback(VariantPropertiesImpl variantProperties) {
            this.variantProperties = variantProperties;
        }

        @Override
        public void handleProvider(TaskProvider<MergeResources> taskProvider) {
            this.variantProperties.getArtifacts().setInitialProvider(taskProvider, MergeResources::getPublicFile).withName("public.txt").on(InternalArtifactType.PUBLIC_RES.INSTANCE);
        }
    }
}

