/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.configure;

import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010(\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b+J\n\u0010,\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u0016H\u0002J\b\u0010/\u001a\u00020\u0010H\u0002J\u000f\u00100\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b1J\u000e\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\u0003J4\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u00162\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00160\b2\u0006\u00108\u001a\u00020\u0003J?\u00109\u001a\u00020\u00002\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00160\b2\u0012\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0<0;2\u0006\u0010=\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b>JE\u0010?\u001a\u00020\u00002\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00160\b2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00030A2\u0012\u0010B\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0<0;H\u0000\u00a2\u0006\u0002\bDJ-\u0010E\u001a\u00020\u00002\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u00160\b2\b\u0010F\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\bGJ\r\u0010H\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bIJ\u0018\u0010J\u001a\u00020\u00102\u0006\u0010K\u001a\u00020\u00162\u0006\u0010L\u001a\u00020\u0016H\u0002J\u0014\u0010M\u001a\u00020\u0010*\u00020\u00162\u0006\u0010N\u001a\u00020\u0016H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\u0004R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0018\"\u0004\b#\u0010\u001aR\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006O"}, d2={"Lcom/android/build/gradle/internal/cxx/configure/CmakeSearchContext;", "", "cmakeVersionFromDsl", "", "(Ljava/lang/String;)V", "getCmakeVersionFromDsl", "()Ljava/lang/String;", "error", "Lkotlin/Function1;", "", "getError", "()Lkotlin/jvm/functions/Function1;", "firstError", "getFirstError", "setFirstError", "requestDownloadFromAndroidStudio", "", "getRequestDownloadFromAndroidStudio", "()Z", "setRequestDownloadFromAndroidStudio", "(Z)V", "requestedCmakeVersion", "Lcom/android/repository/Revision;", "getRequestedCmakeVersion", "()Lcom/android/repository/Revision;", "setRequestedCmakeVersion", "(Lcom/android/repository/Revision;)V", "resultCmakeInstallFolder", "Ljava/io/File;", "getResultCmakeInstallFolder", "()Ljava/io/File;", "setResultCmakeInstallFolder", "(Ljava/io/File;)V", "resultCmakeVersion", "getResultCmakeVersion", "setResultCmakeVersion", "unsuitableCmakeReasons", "", "getUnsuitableCmakeReasons", "()Ljava/util/List;", "checkForCmakeVersionAdequatePrecision", "checkForCmakeVersionAdequatePrecision$gradle", "checkForCmakeVersionTooLow", "checkForCmakeVersionTooLow$gradle", "cmakeVersionFromDslNoPlus", "convertSdkVersionToCmakeVersion", "version", "dslVersionHasPlus", "issueVersionNotFoundError", "issueVersionNotFoundError$gradle", "recordUnsuitableCmakeMessage", "message", "tryAcceptFoundCmake", "candidateCmakeInstallFolder", "candidateVersion", "cmakeVersionGetter", "locationTag", "tryFindInPath", "environmentPaths", "Lkotlin/Function0;", "", "tag", "tryFindInPath$gradle", "tryLocalRepositoryPackages", "downloader", "Ljava/util/function/Consumer;", "repositoryPackages", "Lcom/android/repository/api/LocalPackage;", "tryLocalRepositoryPackages$gradle", "tryPathFromLocalProperties", "pathFromLocalProperties", "tryPathFromLocalProperties$gradle", "useDefaultCmakeVersionIfNecessary", "useDefaultCmakeVersionIfNecessary$gradle", "versionEquals", "left", "right", "satisfies", "requested", "gradle"})
final class CmakeSearchContext {
    @Nullable
    private File resultCmakeInstallFolder;
    @Nullable
    private Revision resultCmakeVersion;
    @NotNull
    public Revision requestedCmakeVersion;
    @Nullable
    private String firstError;
    @NotNull
    private final List<String> unsuitableCmakeReasons;
    private boolean requestDownloadFromAndroidStudio;
    @NotNull
    private final Function1<String, Unit> error;
    @Nullable
    private final String cmakeVersionFromDsl;

    @Nullable
    public final File getResultCmakeInstallFolder() {
        return this.resultCmakeInstallFolder;
    }

    public final void setResultCmakeInstallFolder(@Nullable File file) {
        this.resultCmakeInstallFolder = file;
    }

    @Nullable
    public final Revision getResultCmakeVersion() {
        return this.resultCmakeVersion;
    }

    public final void setResultCmakeVersion(@Nullable Revision revision) {
        this.resultCmakeVersion = revision;
    }

    @NotNull
    public final Revision getRequestedCmakeVersion() {
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        return revision;
    }

    public final void setRequestedCmakeVersion(@NotNull Revision revision) {
        Intrinsics.checkParameterIsNotNull((Object)revision, (String)"<set-?>");
        this.requestedCmakeVersion = revision;
    }

    @Nullable
    public final String getFirstError() {
        return this.firstError;
    }

    public final void setFirstError(@Nullable String string) {
        this.firstError = string;
    }

    @NotNull
    public final List<String> getUnsuitableCmakeReasons() {
        return this.unsuitableCmakeReasons;
    }

    public final boolean getRequestDownloadFromAndroidStudio() {
        return this.requestDownloadFromAndroidStudio;
    }

    public final void setRequestDownloadFromAndroidStudio(boolean bl) {
        this.requestDownloadFromAndroidStudio = bl;
    }

    @NotNull
    public final Function1<String, Unit> getError() {
        return this.error;
    }

    private final String cmakeVersionFromDslNoPlus() {
        if (this.cmakeVersionFromDsl == null) {
            return null;
        }
        return StringsKt.trimEnd((String)this.cmakeVersionFromDsl, (char[])new char[]{'+'});
    }

    private final boolean dslVersionHasPlus() {
        if (this.cmakeVersionFromDsl == null) {
            return false;
        }
        return StringsKt.endsWith$default((CharSequence)this.cmakeVersionFromDsl, (char)'+', (boolean)false, (int)2, null);
    }

    private final boolean versionEquals(Revision left, Revision right) {
        return left.compareTo(right, Revision.PreviewComparison.IGNORE) == 0;
    }

    private final boolean satisfies(@NotNull Revision $this$satisfies, Revision requested) {
        return this.dslVersionHasPlus() && $this$satisfies.compareTo(requested, Revision.PreviewComparison.IGNORE) >= 0 || this.versionEquals($this$satisfies, requested);
    }

    public final void tryAcceptFoundCmake(@NotNull File candidateCmakeInstallFolder, @NotNull Revision candidateVersion, @NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull String locationTag) {
        Intrinsics.checkParameterIsNotNull((Object)candidateCmakeInstallFolder, (String)"candidateCmakeInstallFolder");
        Intrinsics.checkParameterIsNotNull((Object)candidateVersion, (String)"candidateVersion");
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkParameterIsNotNull((Object)locationTag, (String)"locationTag");
        if (this.dslVersionHasPlus()) {
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            if (!this.satisfies(candidateVersion, revision)) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(candidateVersion).append("' found ").append(locationTag).append(" could not satisfy requested version ").append('\'');
                Revision revision2 = this.requestedCmakeVersion;
                if (revision2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                this.recordUnsuitableCmakeMessage(stringBuilder.append(revision2).append("' because it was lower.").toString());
                return;
            }
        } else {
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            if (!this.versionEquals(revision, candidateVersion)) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(candidateVersion).append("' found ").append(locationTag).append(" did not match requested version ").append('\'');
                Revision revision3 = this.requestedCmakeVersion;
                if (revision3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                this.recordUnsuitableCmakeMessage(stringBuilder.append(revision3).append("'.").toString());
                return;
            }
        }
        try {
            if (cmakeVersionGetter.invoke((Object)candidateCmakeInstallFolder) != null) {
                this.recordUnsuitableCmakeMessage("CMake '" + candidateVersion + "' found " + locationTag + " could not execute --version.");
                return;
            }
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Could not execute cmake at '" + candidateCmakeInstallFolder + "' to get version. Skipping.", new Object[0]);
        }
        if (this.resultCmakeVersion == null) {
            LoggingEnvironmentKt.infoln("- CMake found " + locationTag + " at '" + candidateCmakeInstallFolder + "' had " + "version '" + candidateVersion + '\'', new Object[0]);
            this.resultCmakeVersion = candidateVersion;
            this.resultCmakeInstallFolder = candidateCmakeInstallFolder;
        } else {
            Revision revision = this.resultCmakeVersion;
            if (revision == null) {
                Intrinsics.throwNpe();
            }
            if (candidateVersion.compareTo(revision) > 0) {
                LoggingEnvironmentKt.infoln("- CMake found " + locationTag + " at '" + candidateCmakeInstallFolder + "' had " + "version '" + candidateVersion + "' and replaces version '" + this.resultCmakeVersion + "' " + "found earlier", new Object[0]);
                this.resultCmakeVersion = candidateVersion;
                this.resultCmakeInstallFolder = candidateCmakeInstallFolder;
            } else {
                LoggingEnvironmentKt.infoln("- CMake found and skipped " + locationTag + " '" + candidateCmakeInstallFolder + "' which had " + "version '" + candidateVersion + "' which was lower than or equal to a " + "version found earlier.", new Object[0]);
            }
        }
    }

    public final void recordUnsuitableCmakeMessage(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        LoggingEnvironmentKt.infoln(message, new Object[0]);
        Collection collection = this.unsuitableCmakeReasons;
        String string = "- " + message;
        boolean bl = false;
        collection.add(string);
    }

    @NotNull
    public final CmakeSearchContext useDefaultCmakeVersionIfNecessary$gradle() {
        Revision revision;
        String cmakeVersionFromDslNoPlus = this.cmakeVersionFromDslNoPlus();
        CmakeSearchContext cmakeSearchContext = this;
        if (cmakeVersionFromDslNoPlus == null) {
            LoggingEnvironmentKt.infoln("No CMake version was specified in build.gradle. Using default version " + CmakeLocatorKt.getDefaultCmakeVersion() + '.', new Object[0]);
            Revision revision2 = CmakeLocatorKt.getDefaultCmakeVersion();
            revision = revision2;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"defaultCmakeVersion");
        } else {
            Revision revision3;
            CmakeSearchContext cmakeSearchContext2 = cmakeSearchContext;
            try {
                cmakeSearchContext = cmakeSearchContext2;
                revision3 = Revision.parseRevision((String)cmakeVersionFromDslNoPlus);
            }
            catch (NumberFormatException numberFormatException) {
                cmakeSearchContext = cmakeSearchContext2;
                LoggingEnvironmentKt.errorln("CMake version '" + this.cmakeVersionFromDsl + "' is not formatted correctly.", new Object[0]);
                revision3 = CmakeLocatorKt.getDefaultCmakeVersion();
            }
            Revision revision4 = revision3;
            revision = revision4;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision4, (String)"try {\n                Re\u2026makeVersion\n            }");
        }
        cmakeSearchContext.requestedCmakeVersion = revision;
        return this;
    }

    @NotNull
    public final CmakeSearchContext checkForCmakeVersionTooLow$gradle() {
        block8: {
            block7: {
                Revision revision = this.requestedCmakeVersion;
                if (revision == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision.getMajor() < 3) break block7;
                Revision revision2 = this.requestedCmakeVersion;
                if (revision2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision2.getMajor() != 3) break block8;
                Revision revision3 = this.requestedCmakeVersion;
                if (revision3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (revision3.getMinor() >= 6) break block8;
            }
            StringBuilder stringBuilder = new StringBuilder().append("CMake version '");
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            LoggingEnvironmentKt.errorln(stringBuilder.append(revision).append("' is too low. Use 3.7.0 or higher.").toString(), new Object[0]);
            Revision revision4 = CmakeLocatorKt.getDefaultCmakeVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision4, (String)"defaultCmakeVersion");
            this.requestedCmakeVersion = revision4;
        }
        return this;
    }

    @NotNull
    public final CmakeSearchContext checkForCmakeVersionAdequatePrecision$gradle() {
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        if (revision.toIntArray(true).length < 3) {
            StringBuilder stringBuilder = new StringBuilder().append("CMake version '");
            Revision revision2 = this.requestedCmakeVersion;
            if (revision2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            LoggingEnvironmentKt.errorln(stringBuilder.append(revision2).append("' does not have enough precision. Use major.minor.micro in version.").toString(), new Object[0]);
            Revision revision3 = CmakeLocatorKt.getDefaultCmakeVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision3, (String)"defaultCmakeVersion");
            this.requestedCmakeVersion = revision3;
        }
        return this;
    }

    @NotNull
    public final CmakeSearchContext tryPathFromLocalProperties$gradle(@NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @Nullable File pathFromLocalProperties) {
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        boolean bl = this.resultCmakeInstallFolder == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (pathFromLocalProperties == null) {
            return this;
        }
        File binDir = new File(pathFromLocalProperties, "bin");
        Revision version = (Revision)cmakeVersionGetter.invoke((Object)binDir);
        if (version == null) {
            LoggingEnvironmentKt.errorln("Could not get version from cmake.dir path '" + pathFromLocalProperties + "'.", new Object[0]);
            return this;
        }
        if (this.cmakeVersionFromDsl == null) {
            LoggingEnvironmentKt.infoln("- Found CMake '" + version + "' via cmake.dir='" + pathFromLocalProperties + "'.", new Object[0]);
            this.resultCmakeInstallFolder = pathFromLocalProperties;
            this.resultCmakeVersion = version;
        } else {
            this.tryAcceptFoundCmake(pathFromLocalProperties, version, cmakeVersionGetter, "from cmake.dir");
            if (this.resultCmakeInstallFolder == null) {
                StringBuilder stringBuilder = new StringBuilder().append("CMake '").append(version).append("' found via cmake.dir='").append(pathFromLocalProperties).append("' does not match ").append("requested version '");
                Revision revision = this.requestedCmakeVersion;
                if (revision == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                LoggingEnvironmentKt.errorln(stringBuilder.append(revision).append("'.").toString(), new Object[0]);
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CmakeSearchContext tryLocalRepositoryPackages$gradle(@NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Consumer<String> downloader, @NotNull Function0<? extends List<? extends LocalPackage>> repositoryPackages) {
        Object v11;
        block13: {
            void messageVersion;
            Pair pair;
            Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
            Intrinsics.checkParameterIsNotNull(downloader, (String)"downloader");
            Intrinsics.checkParameterIsNotNull(repositoryPackages, (String)"repositoryPackages");
            if (this.resultCmakeInstallFolder != null) {
                return this;
            }
            LoggingEnvironmentKt.infoln("Trying to locate CMake in local SDK repository.", new Object[0]);
            Iterable $this$onEach$iv = (Iterable)repositoryPackages.invoke();
            boolean $i$f$onEach = false;
            Iterable iterable = $this$onEach$iv;
            boolean bl = false;
            boolean bl2 = false;
            Iterable $this$apply$iv = iterable;
            boolean bl3 = false;
            for (Object element$iv : $this$apply$iv) {
                LocalPackage pkg = (LocalPackage)element$iv;
                boolean bl4 = false;
                File file = pkg.getLocation();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"pkg.location");
                Revision revision = pkg.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"pkg.version");
                this.tryAcceptFoundCmake(file, this.convertSdkVersionToCmakeVersion(revision), cmakeVersionGetter, "in SDK");
            }
            if (this.resultCmakeInstallFolder != null) {
                return this;
            }
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            Revision revision2 = CmakeLocatorKt.getForkCmakeReportedVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"forkCmakeReportedVersion");
            if (this.versionEquals(revision, revision2)) {
                pair = new Pair((Object)CmakeLocatorKt.access$getForkCmakeSdkVersionRevision$p(), (Object)"3.6.4111459");
            } else {
                Revision revision3 = CmakeLocatorKt.getDefaultCmakeVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)revision3, (String)"defaultCmakeVersion");
                Revision revision4 = this.requestedCmakeVersion;
                if (revision4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                }
                if (this.satisfies(revision3, revision4)) {
                    pair = new Pair((Object)CmakeLocatorKt.getDefaultCmakeVersion(), (Object)CmakeLocatorKt.access$getDEFAULT_CMAKE_SDK_DOWNLOAD_VERSION$p());
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Requested CMake version ");
                    Revision revision5 = this.requestedCmakeVersion;
                    if (revision5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
                    }
                    LoggingEnvironmentKt.infoln(stringBuilder.append(revision5).append(" was not satisfied by ").append("default version ").append(CmakeLocatorKt.getDefaultCmakeVersion()).append(" for this Android Gradle Plugin").toString(), new Object[0]);
                    return this;
                }
            }
            iterable = pair;
            $this$onEach$iv = (Revision)iterable.component1();
            String sdkDownloadVersion = (String)iterable.component2();
            LoggingEnvironmentKt.infoln("- Downloading '" + messageVersion + "'.", new Object[0]);
            downloader.accept(sdkDownloadVersion);
            Iterable iterable2 = (Iterable)repositoryPackages.invoke();
            bl2 = false;
            Iterable iterable3 = iterable2;
            boolean bl5 = false;
            for (Object t : iterable3) {
                LocalPackage it = (LocalPackage)t;
                boolean bl6 = false;
                Revision revision6 = it.getVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)revision6, (String)"it.version");
                void v10 = messageVersion;
                Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"messageVersion");
                if (!this.versionEquals(revision6, (Revision)v10)) continue;
                v11 = t;
                break block13;
            }
            v11 = null;
        }
        LocalPackage res = v11;
        if (res != null) {
            File file = res.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"res.location");
            Revision revision = res.getVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"res.version");
            this.tryAcceptFoundCmake(file, this.convertSdkVersionToCmakeVersion(revision), cmakeVersionGetter, "in SDK after download");
        }
        if (this.resultCmakeInstallFolder == null) {
            this.requestDownloadFromAndroidStudio = true;
        }
        return this;
    }

    private final Revision convertSdkVersionToCmakeVersion(Revision version) {
        if (Intrinsics.areEqual((Object)version, (Object)CmakeLocatorKt.access$getForkCmakeSdkVersionRevision$p())) {
            Revision revision = CmakeLocatorKt.getForkCmakeReportedVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"forkCmakeReportedVersion");
            return revision;
        }
        return version;
    }

    @NotNull
    public final CmakeSearchContext tryFindInPath$gradle(@NotNull Function1<? super File, ? extends Revision> cmakeVersionGetter, @NotNull Function0<? extends List<? extends File>> environmentPaths, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull(cmakeVersionGetter, (String)"cmakeVersionGetter");
        Intrinsics.checkParameterIsNotNull(environmentPaths, (String)"environmentPaths");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (this.resultCmakeInstallFolder != null) {
            return this;
        }
        LoggingEnvironmentKt.infoln("Trying to locate CMake " + tag + '.', new Object[0]);
        boolean found = false;
        for (File cmakeFolder2 : (List)environmentPaths.invoke()) {
            try {
                File cmakeInstallPath;
                Revision version;
                if ((Revision)cmakeVersionGetter.invoke((Object)cmakeFolder2) == null) {
                    continue;
                }
                if (found) {
                    LoggingEnvironmentKt.infoln("- CMake " + version + " was found " + tag + " at " + cmakeFolder2 + " after" + " another version. Ignoring it.", new Object[0]);
                    continue;
                }
                File file = cmakeInstallPath = cmakeFolder2.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"cmakeInstallPath");
                this.tryAcceptFoundCmake(file, version, cmakeVersionGetter, tag);
                found = true;
            }
            catch (IOException e) {
                LoggingEnvironmentKt.warnln("Could not execute cmake at '" + cmakeFolder2 + "' to get version. Skipping.", new Object[0]);
            }
        }
        return this;
    }

    @Nullable
    public final File issueVersionNotFoundError$gradle() {
        String unsuitableCMakes;
        String string;
        if (this.resultCmakeInstallFolder != null && !this.requestDownloadFromAndroidStudio) {
            return this.resultCmakeInstallFolder;
        }
        if (this.unsuitableCmakeReasons.isEmpty()) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(CmakeLocatorKt.access$getNewline$p());
            Iterable iterable = this.unsuitableCmakeReasons;
            String string2 = CmakeLocatorKt.access$getNewline$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"newline");
            string = unsuitableCMakes = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
        }
        if (this.firstError != null) {
            throw (Throwable)new RuntimeException(this.firstError + unsuitableCMakes);
        }
        if (this.dslVersionHasPlus()) {
            StringBuilder stringBuilder = new StringBuilder().append("CMake '");
            Revision revision = this.requestedCmakeVersion;
            if (revision == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
            }
            throw (Throwable)new RuntimeException(stringBuilder.append(revision).append("' or higher was not found in ").append("PATH or by cmake.dir property.").append(unsuitableCMakes).toString());
        }
        StringBuilder stringBuilder = new StringBuilder().append("CMake '");
        Revision revision = this.requestedCmakeVersion;
        if (revision == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"requestedCmakeVersion");
        }
        throw (Throwable)new RuntimeException(stringBuilder.append(revision).append("' was not found in ").append("PATH or by cmake.dir property.").append(unsuitableCMakes).toString());
    }

    @Nullable
    public final String getCmakeVersionFromDsl() {
        return this.cmakeVersionFromDsl;
    }

    public CmakeSearchContext(@Nullable String cmakeVersionFromDsl) {
        List list;
        this.cmakeVersionFromDsl = cmakeVersionFromDsl;
        CmakeSearchContext cmakeSearchContext = this;
        boolean bl = false;
        cmakeSearchContext.unsuitableCmakeReasons = list = (List)new ArrayList();
        this.error = (Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CmakeSearchContext this$0;

            public final void invoke(@NotNull String message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                if (this.this$0.getFirstError() == null) {
                    this.this$0.setFirstError(message);
                }
                LoggingEnvironmentKt.errorln(message, new Object[0]);
            }
            {
                this.this$0 = cmakeSearchContext;
                super(1);
            }
        };
    }
}

