/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.BuildAuthorSpecifiedDefaultsFlavorComparator;
import com.android.build.gradle.internal.variant.DefaultBuildTypeComparator;
import com.android.build.gradle.internal.variant.DefaultFlavorComparator;
import com.android.build.gradle.internal.variant.VariantInputModel;
import com.android.build.gradle.internal.variant.VariantModel;
import com.android.build.gradle.internal.variant.VariantModelImpl;
import com.android.builder.errors.IssueReporter;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u001bH\u0002R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/variant/VariantModelImpl;", "Lcom/android/build/gradle/internal/variant/VariantModel;", "inputs", "Lcom/android/build/gradle/internal/variant/VariantInputModel;", "testBuilderTypeProvider", "Lkotlin/Function0;", "", "variantManager", "Lcom/android/build/gradle/internal/VariantManager;", "issueHandler", "Lcom/android/builder/errors/IssueReporter;", "(Lcom/android/build/gradle/internal/variant/VariantInputModel;Lkotlin/jvm/functions/Function0;Lcom/android/build/gradle/internal/VariantManager;Lcom/android/builder/errors/IssueReporter;)V", "defaultVariant", "getDefaultVariant", "()Ljava/lang/String;", "getInputs", "()Lcom/android/build/gradle/internal/variant/VariantInputModel;", "variants", "", "Lcom/android/build/gradle/internal/scope/VariantScope;", "getVariants", "()Ljava/util/List;", "computeDefaultVariant", "finalizeDefaultVariantDsl", "", "getBuildAuthorSpecifiedDefaultBuildType", "getBuildAuthorSpecifiedDefaultFlavors", "", "gradle"})
public final class VariantModelImpl
implements VariantModel {
    @NotNull
    private final VariantInputModel inputs;
    private final Function0<String> testBuilderTypeProvider;
    private final VariantManager variantManager;
    private final IssueReporter issueHandler;

    @Override
    @NotNull
    public List<VariantScope> getVariants() {
        List<VariantScope> list = this.variantManager.getVariantScopes();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"variantManager.variantScopes");
        return list;
    }

    @Override
    @Nullable
    public String getDefaultVariant() {
        return this.computeDefaultVariant();
    }

    private final String computeDefaultVariant() {
        VariantScope defaultVariantScope2;
        this.finalizeDefaultVariantDsl();
        if (this.getVariants().isEmpty()) {
            return null;
        }
        String chosenBuildType = this.getBuildAuthorSpecifiedDefaultBuildType();
        Map<String, String> chosenFlavors = this.getBuildAuthorSpecifiedDefaultFlavors();
        String string = (String)this.testBuilderTypeProvider.invoke();
        if (string == null) {
            string = "debug";
        }
        String fallbackDefaultBuildType = string;
        Comparator comparator = new BuildAuthorSpecifiedDefaultBuildTypeComparator(chosenBuildType).thenComparing(new BuildAuthorSpecifiedDefaultsFlavorComparator(chosenFlavors)).thenComparing(new DefaultBuildTypeComparator(fallbackDefaultBuildType)).thenComparing(new DefaultFlavorComparator());
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"BuildAuthorSpecifiedDefa\u2026efaultFlavorComparator())");
        Comparator preferredDefaultVariantScopeComparator = comparator;
        VariantScope variantScope = defaultVariantScope2 = (VariantScope)SequencesKt.minWith((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getVariants()), (Function1)computeDefaultVariant.defaultVariantScope.1.INSTANCE), preferredDefaultVariantScopeComparator);
        return variantScope != null ? variantScope.getName() : null;
    }

    private final void finalizeDefaultVariantDsl() {
        for (BuildTypeData buildTypeData : this.getInputs().getBuildTypes().values()) {
            BuildType buildType = buildTypeData.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType, (String)"buildTypeData.buildType");
            buildType.getIsDefaultProp().finalizeValue();
        }
        for (ProductFlavorData productFlavorData : this.getInputs().getProductFlavors().values()) {
            Object t = productFlavorData.getProductFlavor();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"productFlavorData.productFlavor");
            ((ProductFlavor)t).getIsDefaultProp().finalizeValue();
        }
    }

    private final String getBuildAuthorSpecifiedDefaultBuildType() {
        List buildTypesMarkedAsDefault = new ArrayList(1);
        for (BuildTypeData buildType : this.getInputs().getBuildTypes().values()) {
            BuildType buildType2 = buildType.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType2, (String)"buildType.buildType");
            Object object = buildType2.getIsDefaultProp().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"buildType.buildType.isDefaultProp.get()");
            if (!((Boolean)object).booleanValue()) continue;
            BuildType buildType3 = buildType.getBuildType();
            Intrinsics.checkExpressionValueIsNotNull((Object)buildType3, (String)"buildType.buildType");
            String string = buildType3.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildType.buildType.name");
            buildTypesMarkedAsDefault.add(string);
        }
        CollectionsKt.sort((List)buildTypesMarkedAsDefault);
        if (buildTypesMarkedAsDefault.size() > 1) {
            IssueReporter.reportWarning$default((IssueReporter)this.issueHandler, (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_BUILD_TYPE_DEFAULT, (String)("Ambiguous default build type: '" + Joiner.on((String)"', '").join((Iterable)buildTypesMarkedAsDefault) + "'.\n" + "Please only set `isDefault = true` for one build type."), (String)Joiner.on((char)',').join((Iterable)buildTypesMarkedAsDefault), null, (int)8, null);
        }
        return buildTypesMarkedAsDefault.isEmpty() ? null : (String)buildTypesMarkedAsDefault.get(0);
    }

    private final Map<String, String> getBuildAuthorSpecifiedDefaultFlavors() {
        ArrayListMultimap userDefaults = ArrayListMultimap.create();
        for (ProductFlavorData<ProductFlavor> flavor : this.getInputs().getProductFlavors().values()) {
            String dimension;
            ProductFlavor productFlavor;
            Intrinsics.checkExpressionValueIsNotNull((Object)flavor.getProductFlavor(), (String)"flavor.productFlavor");
            if (productFlavor.getDimension() == null) {
                Intrinsics.throwNpe();
            }
            Object object = productFlavor.getIsDefaultProp().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"productFlavor.isDefaultProp.get()");
            if (!((Boolean)object).booleanValue()) continue;
            userDefaults.put((Object)dimension, (Object)productFlavor.getName());
        }
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (String dimension : userDefaults.keySet()) {
            List userDefault;
            List list = userDefault = userDefaults.get((Object)dimension);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"userDefault");
            CollectionsKt.sort((List)list);
            Collection collection = userDefault;
            boolean bl = false;
            if (!collection.isEmpty()) {
                defaults.put((Object)dimension, userDefault.get(0));
            }
            if (userDefault.size() <= 1) continue;
            IssueReporter.reportWarning$default((IssueReporter)this.issueHandler, (IssueReporter.Type)IssueReporter.Type.AMBIGUOUS_PRODUCT_FLAVOR_DEFAULT, (String)("Ambiguous default product flavors for flavor dimension '" + dimension + "': '" + Joiner.on((String)"', '").join((Iterable)userDefault) + "'.\nPlease only set `isDefault = true` for one product flavor in each flavor dimension."), (String)dimension, null, (int)8, null);
        }
        ImmutableMap immutableMap = defaults.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"defaults.build()");
        return (Map)immutableMap;
    }

    @Override
    @NotNull
    public VariantInputModel getInputs() {
        return this.inputs;
    }

    public VariantModelImpl(@NotNull VariantInputModel inputs, @NotNull Function0<String> testBuilderTypeProvider, @NotNull VariantManager variantManager, @NotNull IssueReporter issueHandler) {
        Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(testBuilderTypeProvider, (String)"testBuilderTypeProvider");
        Intrinsics.checkParameterIsNotNull((Object)variantManager, (String)"variantManager");
        Intrinsics.checkParameterIsNotNull((Object)issueHandler, (String)"issueHandler");
        this.inputs = inputs;
        this.testBuilderTypeProvider = testBuilderTypeProvider;
        this.variantManager = variantManager;
        this.issueHandler = issueHandler;
    }
}

