/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.gradle.internal.dependency.L8DexDesugarLibTransformKt;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.utils.DesugarLibConfigExtractor;
import com.android.build.gradle.internal.utils.DesugarLibUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ArtifactAttributes;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DESUGAR_LIB_CONFIG", "", "DESUGAR_LIB_CONFIG_FILE", "DESUGAR_LIB_DEX", "getArtifactCollection", "Lorg/gradle/api/file/FileCollection;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "getDesugarLibConfig", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "getDesugarLibConfigFromTransform", "getDesugarLibConfiguration", "getDesugarLibDexFromTransform", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "minSdkVersion", "", "getDesugarLibJarFromMaven", "registerDesugarLibConfigTransform", "", "gradle"})
@JvmName(name="DesugarLibUtils")
public final class DesugarLibUtils {
    private static final String DESUGAR_LIB_CONFIG_FILE = "desugar.json";
    @NotNull
    public static final String DESUGAR_LIB_DEX = "_internal-desugar-lib-dex";
    @NotNull
    public static final String DESUGAR_LIB_CONFIG = "_internal-desugar-lib-config";

    @NotNull
    public static final FileCollection getDesugarLibJarFromMaven(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Configuration configuration2 = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getArtifactCollection(configuration2);
    }

    @NotNull
    public static final FileCollection getDesugarLibDexFromTransform(@NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        if (!variantScope.isCoreLibraryDesugaringEnabled()) {
            GlobalScope globalScope = variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            ConfigurableFileCollection configurableFileCollection = globalScope.getProject().files(new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"variantScope.globalScope.project.files()");
            return (FileCollection)configurableFileCollection;
        }
        GlobalScope globalScope = variantScope.getGlobalScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
        Project project2 = globalScope.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"variantScope.globalScope.project");
        Configuration configuration2 = DesugarLibUtils.getDesugarLibConfiguration(project2);
        return DesugarLibUtils.getDesugarLibDexFromTransform(configuration2, variantScope.getVariantDslInfo().getMinSdkVersionWithTargetDeviceApi().getFeatureLevel());
    }

    @NotNull
    public static final Provider<String> getDesugarLibConfig(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration2 = (Configuration)object;
        DesugarLibUtils.registerDesugarLibConfigTransform(project2);
        Provider provider = DesugarLibUtils.getDesugarLibConfigFromTransform(configuration2).getElements().map((Transformer)getDesugarLibConfig.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"getDesugarLibConfigFromT\u2026oString()\n        }\n    }");
        return provider;
    }

    private static final Configuration getDesugarLibConfiguration(Project project2) {
        Object object = project2.getConfigurations().findByName("coreLibraryDesugaring");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.configurations.f\u2026ORE_LIBRARY_DESUGARING)!!");
        Configuration configuration2 = (Configuration)object;
        if (configuration2.getDependencies().isEmpty()) {
            throw (Throwable)new RuntimeException("coreLibraryDesugaring configuration contains no dependencies. If you intend to enable core library desugaring, please add dependencies to coreLibraryDesugaring configuration.");
        }
        return configuration2;
    }

    private static final FileCollection getDesugarLibDexFromTransform(Configuration configuration2, int minSdkVersion) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(minSdkVersion){
            final /* synthetic */ int $minSdkVersion;

            public final void execute(ArtifactView.ViewConfiguration config2) {
                config2.attributes((Action)new Action<AttributeContainer>(this){
                    final /* synthetic */ getDesugarLibDexFromTransform.1 this$0;

                    public final void execute(AttributeContainer it) {
                        it.attribute(ArtifactAttributes.ARTIFACT_FORMAT, (Object)"_internal-desugar-lib-dex");
                        it.attribute(L8DexDesugarLibTransformKt.getATTR_L8_MIN_SDK(), (Object)String.valueOf(this.this$0.$minSdkVersion));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$minSdkVersion = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026String())\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getDesugarLibConfigFromTransform(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getDesugarLibConfigFromTransform.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final FileCollection getArtifactCollection(Configuration configuration2) {
        ArtifactView artifactView = configuration2.getIncoming().artifactView((Action)getArtifactCollection.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"configuration.incoming.a\u2026        )\n        }\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"configuration.incoming.a\u2026        }\n    }.artifacts");
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"configuration.incoming.a\u2026}.artifacts.artifactFiles");
        return fileCollection2;
    }

    private static final void registerDesugarLibConfigTransform(Project project2) {
        project2.getDependencies().registerTransform(DesugarLibConfigExtractor.class, (Action)registerDesugarLibConfigTransform.1.INSTANCE);
    }
}

