/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.BaseAppModuleExtension;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IntegrityConfigParser;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.ParseIntegrityConfigTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.bundle.AppIntegrityConfigOuterClass;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "appIntegrityConfigProto", "Lorg/gradle/api/file/RegularFileProperty;", "getAppIntegrityConfigProto", "()Lorg/gradle/api/file/RegularFileProperty;", "integrityConfigDir", "Lorg/gradle/api/file/DirectoryProperty;", "getIntegrityConfigDir", "()Lorg/gradle/api/file/DirectoryProperty;", "doTaskAction", "", "CreationAction", "Params", "ParseIntegrityConfigRunnable", "gradle"})
public abstract class ParseIntegrityConfigTask
extends NonIncrementalTask {
    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getIntegrityConfigDir();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getAppIntegrityConfigProto();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTaskAction() {
        Closeable closeable = (Closeable)this.getWorkerFacadeWithWorkers();
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            Directory directory2 = (Directory)this.getIntegrityConfigDir().getOrNull();
            File file = directory2 != null ? directory2.getAsFile() : null;
            Object object = this.getAppIntegrityConfigProto().getAsFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"appIntegrityConfigProto.asFile.get()");
            it.submit(ParseIntegrityConfigRunnable.class, (Serializable)new Params(file, (File)object));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "Ljava/io/Serializable;", "integrityConfigDir", "Ljava/io/File;", "appIntegrityConfigProto", "(Ljava/io/File;Ljava/io/File;)V", "getAppIntegrityConfigProto", "()Ljava/io/File;", "getIntegrityConfigDir", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle"})
    public static final class Params
    implements Serializable {
        @Nullable
        private final File integrityConfigDir;
        @NotNull
        private final File appIntegrityConfigProto;

        @Nullable
        public final File getIntegrityConfigDir() {
            return this.integrityConfigDir;
        }

        @NotNull
        public final File getAppIntegrityConfigProto() {
            return this.appIntegrityConfigProto;
        }

        public Params(@Nullable File integrityConfigDir, @NotNull File appIntegrityConfigProto) {
            Intrinsics.checkParameterIsNotNull((Object)appIntegrityConfigProto, (String)"appIntegrityConfigProto");
            this.integrityConfigDir = integrityConfigDir;
            this.appIntegrityConfigProto = appIntegrityConfigProto;
        }

        @Nullable
        public final File component1() {
            return this.integrityConfigDir;
        }

        @NotNull
        public final File component2() {
            return this.appIntegrityConfigProto;
        }

        @NotNull
        public final Params copy(@Nullable File integrityConfigDir, @NotNull File appIntegrityConfigProto) {
            Intrinsics.checkParameterIsNotNull((Object)appIntegrityConfigProto, (String)"appIntegrityConfigProto");
            return new Params(integrityConfigDir, appIntegrityConfigProto);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, File file2, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.integrityConfigDir;
            }
            if ((n & 2) != 0) {
                file2 = params.appIntegrityConfigProto;
            }
            return params.copy(file, file2);
        }

        @NotNull
        public String toString() {
            return "Params(integrityConfigDir=" + this.integrityConfigDir + ", appIntegrityConfigProto=" + this.appIntegrityConfigProto + ")";
        }

        public int hashCode() {
            File file = this.integrityConfigDir;
            File file2 = this.appIntegrityConfigProto;
            return (file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.integrityConfigDir, (Object)params.integrityConfigDir) || !Intrinsics.areEqual((Object)this.appIntegrityConfigProto, (Object)params.appIntegrityConfigProto)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @VisibleForTesting
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$ParseIntegrityConfigRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;", "(Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$Params;)V", "loadXML", "Lorg/w3c/dom/Document;", "xmlFile", "Ljava/io/File;", "run", "", "storeProto", "configProto", "Lcom/android/bundle/AppIntegrityConfigOuterClass$AppIntegrityConfig;", "output", "gradle"})
    public static final class ParseIntegrityConfigRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            File file = this.params.getIntegrityConfigDir();
            if (file != null) {
                File file2 = file;
                boolean bl = false;
                boolean bl2 = false;
                File it = file2;
                boolean bl3 = false;
                if (!it.isDirectory()) {
                    throw (Throwable)new FileNotFoundException("Could not find directory " + it.getAbsolutePath());
                }
                Document doc = this.loadXML(FilesKt.resolve((File)it, (String)"IntegrityConfig.xml"));
                AppIntegrityConfigOuterClass.AppIntegrityConfig configProto = new IntegrityConfigParser(doc).parseConfig();
                this.storeProto(configProto, this.params.getAppIntegrityConfigProto());
            } else {
                ParseIntegrityConfigRunnable parseIntegrityConfigRunnable = this;
                boolean bl = false;
                boolean bl4 = false;
                ParseIntegrityConfigRunnable $this$run = parseIntegrityConfigRunnable;
                boolean bl5 = false;
                Files.deleteIfExists($this$run.params.getAppIntegrityConfigProto().toPath());
            }
        }

        private final Document loadXML(File xmlFile) {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(xmlFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"documentBuilder.parse(xmlFile)");
            return document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void storeProto(AppIntegrityConfigOuterClass.AppIntegrityConfig configProto, File output2) {
            Closeable closeable = Files.newOutputStream(output2.toPath(), new OpenOption[0]);
            boolean bl = false;
            Throwable throwable = null;
            try {
                OutputStream outputStream = (OutputStream)closeable;
                boolean bl2 = false;
                configProto.writeTo(outputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @Inject
        public ParseIntegrityConfigRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/ParseIntegrityConfigTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "getIntegrityConfigFolder", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<ParseIntegrityConfigTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("parse", "IntegrityConfig");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026arse\", \"IntegrityConfig\")");
            return string;
        }

        @Override
        @NotNull
        public Class<ParseIntegrityConfigTask> getType() {
            return ParseIntegrityConfigTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends ParseIntegrityConfigTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesFile((ArtifactType)InternalArtifactType.APP_INTEGRITY_CONFIG.INSTANCE, taskProvider, (Function1)ParseIntegrityConfigTask$CreationAction$handleProvider$1.INSTANCE, "AppIntegrityConfig.pb");
        }

        @Override
        public void configure(@NotNull ParseIntegrityConfigTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.getIntegrityConfigDir().set(this.getIntegrityConfigFolder());
        }

        private final Provider<? extends Directory> getIntegrityConfigFolder() {
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            BaseExtension baseExtension = globalScope.getExtension();
            if (baseExtension == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.dsl.BaseAppModuleExtension");
            }
            return (Provider)((BaseAppModuleExtension)baseExtension).getBundle().getIntegrityConfigDir();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

