/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.api.dsl.BuildFeatures;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import javax.inject.Inject;

public class DataBindingOptions
implements com.android.builder.model.DataBindingOptions {
    private final BuildFeatures features;
    private final ProjectOptions projectOptions;
    private final DslScope dslScope;
    private String version;
    private boolean addDefaultAdapters = true;
    private boolean enabledForTests = false;

    @Inject
    public DataBindingOptions(BuildFeatures features, ProjectOptions projectOptions, DslScope dslScope) {
        this.features = features;
        this.projectOptions = projectOptions;
        this.dslScope = dslScope;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public boolean isEnabled() {
        this.dslScope.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.dataBinding", "android.dataBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        Boolean bool = this.features.getDataBinding();
        if (bool != null) {
            return bool;
        }
        return this.projectOptions.get(BooleanOption.BUILD_FEATURE_DATABINDING);
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        this.dslScope.getDeprecationReporter().reportDeprecatedUsage("android.buildFeatures.dataBinding", "android.dataBinding.enabled", DeprecationReporter.DeprecationTarget.VERSION_5_0);
        this.features.setDataBinding(Boolean.valueOf(enabled));
    }

    public boolean getAddDefaultAdapters() {
        return this.addDefaultAdapters;
    }

    public void setAddDefaultAdapters(boolean addDefaultAdapters) {
        this.addDefaultAdapters = addDefaultAdapters;
    }

    public boolean isEnabledForTests() {
        return this.enabledForTests;
    }

    public void setEnabledForTests(boolean enabledForTests) {
        this.enabledForTests = enabledForTests;
    }
}

