/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.PlatformComponents;
import com.android.build.gradle.internal.PlatformToolsComponents;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.build.gradle.internal.SdkType;
import com.android.build.gradle.internal.SupportToolsComponents;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u000256B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017J\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u0004\u0018\u00010\bJ\b\u0010\"\u001a\u0004\u0018\u00010\u0017J\u0012\u0010#\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019J\b\u0010'\u001a\u0004\u0018\u00010\u0017J\b\u0010(\u001a\u0004\u0018\u00010\u0017J\b\u0010)\u001a\u0004\u0018\u00010\u0017J\b\u0010*\u001a\u0004\u0018\u00010\u0017J\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0019J\b\u0010,\u001a\u0004\u0018\u00010-J\n\u0010.\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\u000f2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\bH\u0002J\u0006\u00102\u001a\u00020\nJ\u0006\u00103\u001a\u000204R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy;", "", "sdkLocationSourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "platformTargetHashSupplier", "Ljava/util/function/Supplier;", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "(Lcom/android/build/gradle/internal/SdkLocationSourceSet;Ljava/util/function/Supplier;Ljava/util/function/Supplier;ZLcom/android/builder/errors/IssueReporter;)V", "components", "Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "getComponents", "()Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "components$delegate", "Lkotlin/Lazy;", "checkBuildToolsRevision", "revision", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreLambaStubs", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "loadSdkComponents", "targetHash", "buildToolRevision", "loadedSuccessfully", "reset", "", "Companion", "DirectLoadComponents", "gradle"})
public final class SdkDirectLoadingStrategy {
    private final Lazy components$delegate;
    private final SdkLocationSourceSet sdkLocationSourceSet;
    private final Supplier<String> platformTargetHashSupplier;
    private final Supplier<Revision> buildToolRevisionSupplier;
    private final boolean useAndroidX;
    private final IssueReporter issueReporter;
    private static final ConcurrentHashMap<Revision, Optional<BuildToolInfo>> buildToolsCache;
    private static final ConcurrentHashMap<String, Optional<PlatformComponents>> platformCache;
    public static final Companion Companion;

    private final DirectLoadComponents getComponents() {
        Lazy lazy = this.components$delegate;
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DirectLoadComponents)lazy.getValue();
    }

    private final synchronized DirectLoadComponents init() {
        String string = this.platformTargetHashSupplier.get();
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String targetHash = string;
        Revision revision = this.buildToolRevisionSupplier.get();
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Revision revision2 = revision;
        Revision buildToolRevision = sdkDirectLoadingStrategy.checkBuildToolsRevision(revision2);
        return this.loadSdkComponents(targetHash, buildToolRevision);
    }

    private final DirectLoadComponents loadSdkComponents(String targetHash, Revision buildToolRevision) {
        boolean bl;
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
        if (sdkLocation.getType() == SdkType.MISSING) {
            return null;
        }
        File file = sdkLocation.getDirectory();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File sdkDirectory = file;
        PlatformToolsComponents platformTools = PlatformToolsComponents.Companion.build$gradle(sdkDirectory);
        SupportToolsComponents supportTools = SupportToolsComponents.Companion.build$gradle(sdkDirectory, targetHash);
        ConcurrentMap $this$getOrPut$iv = buildToolsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(buildToolRevision);
        if (object == null) {
            boolean bl2 = false;
            Optional<BuildToolInfo> optional = Optional.ofNullable(SdkParsingUtilsKt.buildBuildTools(sdkDirectory, buildToolRevision));
            boolean bl3 = false;
            bl = false;
            Optional<BuildToolInfo> default$iv = optional;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(buildToolRevision, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BuildToolInfo buildTools = ((Optional)object).orElse(null);
        ConcurrentMap $this$getOrPut$iv2 = platformCache;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv2.get(targetHash);
        if (object2 == null) {
            boolean bl5 = false;
            Optional<PlatformComponents> optional = Optional.ofNullable(PlatformComponents.Companion.build$gradle(sdkDirectory, targetHash));
            bl = false;
            boolean bl6 = false;
            Optional<PlatformComponents> default$iv = optional;
            boolean bl7 = false;
            object2 = $this$getOrPut$iv2.putIfAbsent(targetHash, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        PlatformComponents platform = ((Optional)object2).orElse(null);
        if (platformTools == null || supportTools == null || buildTools == null || platform == null) {
            return null;
        }
        return new DirectLoadComponents(platformTools, supportTools, buildTools, platform);
    }

    private final Revision checkBuildToolsRevision(Revision revision) {
        if (revision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.";
            Object[] objectArray = new Object[]{revision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION};
            IssueReporter.Type type = IssueReporter.Type.BUILD_TOOLS_TOO_LOW;
            IssueReporter issueReporter = this.issueReporter;
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            IssueReporter.reportWarning$default((IssueReporter)issueReporter, (IssueReporter.Type)type, (String)string3, (String)ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString(), null, (int)8, null);
            Revision revision2 = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION");
            return revision2;
        }
        return revision;
    }

    public final boolean loadedSuccessfully() {
        return this.getComponents() != null;
    }

    @Nullable
    public final File getAdbExecutable() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatformTools$gradle()) != null ? ((PlatformToolsComponents)object).getAdbExecutable$gradle() : null;
    }

    @Nullable
    public final File getAnnotationsJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getSupportTools$gradle()) != null ? ((SupportToolsComponents)object).getAnnotationsJar$gradle() : null;
    }

    @Nullable
    public final File getAidlFramework() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getAidlFramework$gradle() : null;
    }

    @Nullable
    public final File getAndroidJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getAndroidJar$gradle() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getAdditionalLibraries$gradle() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getOptionalLibraries$gradle() : null;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getTargetPlatformVersion$gradle() : null;
    }

    @Nullable
    public final List<File> getTargetBootClasspath() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle()) != null ? ((PlatformComponents)object).getTargetBootClasspath$gradle() : null;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        DirectLoadComponents directLoadComponents = this.getComponents();
        return directLoadComponents != null ? directLoadComponents.getBuildToolInfo$gradle() : null;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo != null ? buildToolInfo.getRevision() : null;
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component));
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    public final void reset() {
        Companion.clearCaches();
    }

    public SdkDirectLoadingStrategy(@NotNull SdkLocationSourceSet sdkLocationSourceSet, @NotNull Supplier<String> platformTargetHashSupplier, @NotNull Supplier<Revision> buildToolRevisionSupplier, boolean useAndroidX, @NotNull IssueReporter issueReporter) {
        Intrinsics.checkParameterIsNotNull((Object)sdkLocationSourceSet, (String)"sdkLocationSourceSet");
        Intrinsics.checkParameterIsNotNull(platformTargetHashSupplier, (String)"platformTargetHashSupplier");
        Intrinsics.checkParameterIsNotNull(buildToolRevisionSupplier, (String)"buildToolRevisionSupplier");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
        this.issueReporter = issueReporter;
        this.components$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectLoadComponents>(this){
            final /* synthetic */ SdkDirectLoadingStrategy this$0;

            @Nullable
            public final DirectLoadComponents invoke() {
                return SdkDirectLoadingStrategy.access$init(this.this$0);
            }
            {
                this.this$0 = sdkDirectLoadingStrategy;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        buildToolsCache = new ConcurrentHashMap();
        platformCache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ DirectLoadComponents access$init(SdkDirectLoadingStrategy $this) {
        return $this.init();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "", "platformTools", "Lcom/android/build/gradle/internal/PlatformToolsComponents;", "supportTools", "Lcom/android/build/gradle/internal/SupportToolsComponents;", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "platform", "Lcom/android/build/gradle/internal/PlatformComponents;", "(Lcom/android/build/gradle/internal/PlatformToolsComponents;Lcom/android/build/gradle/internal/SupportToolsComponents;Lcom/android/sdklib/BuildToolInfo;Lcom/android/build/gradle/internal/PlatformComponents;)V", "getBuildToolInfo$gradle", "()Lcom/android/sdklib/BuildToolInfo;", "getPlatform$gradle", "()Lcom/android/build/gradle/internal/PlatformComponents;", "getPlatformTools$gradle", "()Lcom/android/build/gradle/internal/PlatformToolsComponents;", "getSupportTools$gradle", "()Lcom/android/build/gradle/internal/SupportToolsComponents;", "gradle"})
    private static final class DirectLoadComponents {
        @NotNull
        private final PlatformToolsComponents platformTools;
        @NotNull
        private final SupportToolsComponents supportTools;
        @NotNull
        private final BuildToolInfo buildToolInfo;
        @NotNull
        private final PlatformComponents platform;

        @NotNull
        public final PlatformToolsComponents getPlatformTools$gradle() {
            return this.platformTools;
        }

        @NotNull
        public final SupportToolsComponents getSupportTools$gradle() {
            return this.supportTools;
        }

        @NotNull
        public final BuildToolInfo getBuildToolInfo$gradle() {
            return this.buildToolInfo;
        }

        @NotNull
        public final PlatformComponents getPlatform$gradle() {
            return this.platform;
        }

        public DirectLoadComponents(@NotNull PlatformToolsComponents platformTools, @NotNull SupportToolsComponents supportTools, @NotNull BuildToolInfo buildToolInfo, @NotNull PlatformComponents platform) {
            Intrinsics.checkParameterIsNotNull((Object)platformTools, (String)"platformTools");
            Intrinsics.checkParameterIsNotNull((Object)supportTools, (String)"supportTools");
            Intrinsics.checkParameterIsNotNull((Object)buildToolInfo, (String)"buildToolInfo");
            Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
            this.platformTools = platformTools;
            this.supportTools = supportTools;
            this.buildToolInfo = buildToolInfo;
            this.platform = platform;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$Companion;", "", "()V", "buildToolsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/repository/Revision;", "Ljava/util/Optional;", "Lcom/android/sdklib/BuildToolInfo;", "platformCache", "", "Lcom/android/build/gradle/internal/PlatformComponents;", "clearCaches", "", "gradle"})
    public static final class Companion {
        @VisibleForTesting
        public final synchronized void clearCaches() {
            buildToolsCache.clear();
            platformCache.clear();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

