/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BootClasspathBuilder;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.GenerateTestConfig;
import com.android.builder.core.LibraryRequest;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

@CacheableTask
public class AndroidUnitTest
extends Test
implements VariantAwareTask {
    private String variantName;
    private GenerateTestConfig.TestConfigInputs testConfigInputs;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String name) {
        this.variantName = name;
    }

    @Nested
    @Optional
    public GenerateTestConfig.TestConfigInputs getTestConfigInputs() {
        return this.testConfigInputs;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<AndroidUnitTest> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("test");
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void configure(AndroidUnitTest task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            TestVariantData variantData = (TestVariantData)scope.getVariantData();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
            boolean includeAndroidResources = scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().isIncludeAndroidResources();
            boolean useRelativePathInTestConfig = scope.getGlobalScope().getProjectOptions().get(BooleanOption.USE_RELATIVE_PATH_IN_TEST_CONFIG);
            task.systemProperty("java.awt.headless", "true");
            task.setGroup("verification");
            task.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
            task.setTestClassesDirs(scope.getArtifacts().getAllClasses());
            task.setClasspath((FileCollection)this.computeClasspath(includeAndroidResources));
            if (includeAndroidResources) {
                task.testConfigInputs = new GenerateTestConfig.TestConfigInputs(scope);
            }
            TestTaskReports testTaskReports = task.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination(new File(scope.getGlobalScope().getTestResultsFolder(), task.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination(new File(scope.getGlobalScope().getTestReportFolder(), task.getName()));
            scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(task);
            task.getOutputs().doNotCacheIf("AndroidUnitTest task is not yet cacheable when includeAndroidResources=true and android.testConfig.useRelativePath=false", thisTask -> includeAndroidResources && !useRelativePathInTestConfig);
        }

        private ConfigurableFileCollection computeClasspath(boolean includeAndroidResources) {
            VariantScope scope = this.getVariantScope();
            GlobalScope globalScope = scope.getGlobalScope();
            BuildArtifactsHolder artifacts2 = scope.getArtifacts();
            ConfigurableFileCollection collection = scope.getGlobalScope().getProject().files(new Object[0]);
            if (includeAndroidResources) {
                collection.from(new Object[]{artifacts2.getFinalProduct(InternalArtifactType.UNIT_TEST_CONFIG_DIRECTORY.INSTANCE)});
            }
            collection.from(new Object[]{artifacts2.getAllClasses()});
            collection.from(new Object[]{artifacts2.getFinalProduct(InternalArtifactType.JAVA_RES.INSTANCE)});
            collection.from(new Object[]{scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)});
            collection.from(new Object[]{scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JAVA_RES)});
            if (!globalScope.getExtension().getAaptOptions().getNamespaced() && !globalScope.getProjectOptions().get(BooleanOption.GENERATE_R_JAVA)) {
                collection.from(new Object[]{scope.getRJarForUnitTests()});
            }
            collection.from(new Object[]{this.getAdditionalAndRequestedOptionalLibraries(scope.getGlobalScope())});
            collection.from(new Object[]{scope.getGlobalScope().getMockableJarArtifact()});
            return collection;
        }

        private ConfigurableFileCollection getAdditionalAndRequestedOptionalLibraries(GlobalScope globalScope) {
            return globalScope.getProject().files(new Object[]{() -> BootClasspathBuilder.INSTANCE.computeAdditionalAndRequestedOptionalLibraries((List)globalScope.getSdkComponents().getAdditionalLibrariesProvider().get(), (List)globalScope.getSdkComponents().getOptionalLibrariesProvider().get(), false, (List<LibraryRequest>)ImmutableList.copyOf(globalScope.getExtension().getLibraryRequests()), globalScope.getDslScope().getIssueReporter())});
        }
    }
}

