/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;

public abstract class UninstallTask
extends NonIncrementalTask {
    private BaseVariantData variant;
    private int mTimeOutInMs = 0;
    private Provider<File> adbExecutableProvider;

    public UninstallTask() {
        this.getOutputs().upToDateWhen(task -> {
            this.getLogger().debug("Uninstall task is always run.");
            return false;
        });
    }

    @Override
    protected void doTaskAction() throws DeviceException, ExecutionException {
        Logger logger = this.getLogger();
        String applicationId = this.variant.getApplicationId();
        logger.info("Uninstalling app: {}", (Object)applicationId);
        LoggerWrapper iLogger = new LoggerWrapper(this.getLogger());
        ConnectedDeviceProvider deviceProvider = new ConnectedDeviceProvider((File)this.adbExecutableProvider.get(), this.getTimeOutInMs(), (ILogger)iLogger);
        deviceProvider.use(() -> this.lambda$doTaskAction$1((DeviceProvider)deviceProvider, applicationId, iLogger, logger));
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getAdbExe() {
        return (File)this.adbExecutableProvider.get();
    }

    @Internal(value="This task is always executed")
    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant2) {
        this.variant = variant2;
    }

    @Input
    public int getTimeOutInMs() {
        return this.mTimeOutInMs;
    }

    public void setTimeOutInMs(int timeoutInMs) {
        this.mTimeOutInMs = timeoutInMs;
    }

    private /* synthetic */ Object lambda$doTaskAction$1(DeviceProvider deviceProvider, String applicationId, ILogger iLogger, Logger logger) throws Exception {
        List devices = deviceProvider.getDevices();
        for (DeviceConnector device : devices) {
            device.uninstallPackage(applicationId, this.getTimeOutInMs(), iLogger);
            logger.lifecycle("Uninstalling {} (from {}:{}) from device '{}' ({}).", new Object[]{applicationId, this.getProject().getName(), this.variant.getVariantConfiguration().getFullName(), device.getName(), device.getSerialNumber()});
        }
        int n = devices.size();
        logger.quiet("Uninstalled {} from {} device{}.", new Object[]{applicationId, n, n == 1 ? "" : "s"});
        return null;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<UninstallTask> {
        public CreationAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return StringHelper.appendCapitalized((String)"uninstall", (String)this.getVariantScope().getVariantConfiguration().getFullName());
        }

        @Override
        public Class<UninstallTask> getType() {
            return UninstallTask.class;
        }

        @Override
        public void configure(UninstallTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.setVariant(scope.getVariantData());
            task.setDescription("Uninstalls the " + scope.getVariantData().getDescription() + ".");
            task.setGroup("Install");
            task.setTimeOutInMs(scope.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs());
            task.adbExecutableProvider = scope.getGlobalScope().getSdkComponents().getAdbExecutableProvider();
        }

        @Override
        public void handleProvider(TaskProvider<? extends UninstallTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().setUninstallTask(taskProvider);
        }
    }
}

