/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.stripping.SymbolStripExecutableFinder;
import com.android.build.gradle.internal.dsl.PackagingOptions;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsDelegate;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u001c\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0014J\u0016\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0007R,\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask;", "Lcom/android/build/gradle/internal/tasks/IncrementalTask;", "()V", "<set-?>", "", "", "excludePatterns", "getExcludePatterns", "()Ljava/util/List;", "incremental", "", "getIncremental", "()Z", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputDir", "getOutputDir", "stripToolFinderProvider", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/cxx/stripping/SymbolStripExecutableFinder;", "doFullTaskAction", "", "doIncrementalTaskAction", "changedInputs", "", "Ljava/io/File;", "Lcom/android/ide/common/resources/FileStatus;", "getStripExecutablesMap", "Lcom/android/build/gradle/internal/core/Abi;", "CreationAction", "gradle"})
public abstract class StripDebugSymbolsTask
extends IncrementalTask {
    @NotNull
    private List<String> excludePatterns;
    private Provider<SymbolStripExecutableFinder> stripToolFinderProvider;

    @Classpath
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Input
    @NotNull
    public final List<String> getExcludePatterns() {
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        return list;
    }

    @Input
    @Optional
    @Nullable
    public final Map<Abi, File> getStripExecutablesMap() {
        Map map;
        Object object = this.getInputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        FluentIterable fluentIterable = FileUtils.getAllFiles((File)((Directory)object).getAsFile());
        Intrinsics.checkExpressionValueIsNotNull((Object)fluentIterable, (String)"FileUtils.getAllFiles(inputDir.get().asFile)");
        if (fluentIterable.isEmpty()) {
            map = null;
        } else {
            Provider<SymbolStripExecutableFinder> provider = this.stripToolFinderProvider;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
            }
            map = MapsKt.toSortedMap(((SymbolStripExecutableFinder)provider.get()).getStripExecutables());
        }
        return map;
    }

    @Override
    protected boolean getIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() {
        WorkerExecutorFacade workerExecutorFacade = this.getWorkerFacadeWithThreads(false);
        Object object = this.getInputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir.get().asFile");
        Object object2 = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputDir.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir.get().asFile");
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        Provider<SymbolStripExecutableFinder> provider = this.stripToolFinderProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        new StripDebugSymbolsDelegate(workerExecutorFacade, file, file2, list, provider, new GradleProcessExecutor(this.getProject()), null).run();
    }

    @Override
    protected void doIncrementalTaskAction(@NotNull Map<File, ? extends FileStatus> changedInputs) {
        Intrinsics.checkParameterIsNotNull(changedInputs, (String)"changedInputs");
        WorkerExecutorFacade workerExecutorFacade = this.getWorkerFacadeWithThreads(false);
        Object object = this.getInputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputDir.get().asFile");
        Object object2 = this.getOutputDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"outputDir.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"outputDir.get().asFile");
        List<String> list = this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        Provider<SymbolStripExecutableFinder> provider = this.stripToolFinderProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        new StripDebugSymbolsDelegate(workerExecutorFacade, file, file2, list, provider, new GradleProcessExecutor(this.getProject()), changedInputs).run();
    }

    public static final /* synthetic */ List access$getExcludePatterns$p(StripDebugSymbolsTask $this) {
        List<String> list = $this.excludePatterns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"excludePatterns");
        }
        return list;
    }

    public static final /* synthetic */ Provider access$getStripToolFinderProvider$p(StripDebugSymbolsTask $this) {
        Provider<SymbolStripExecutableFinder> provider = $this.stripToolFinderProvider;
        if (provider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripToolFinderProvider");
        }
        return provider;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/StripDebugSymbolsTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<StripDebugSymbolsTask> {
        @Override
        @NotNull
        public String getName() {
            String string = this.getVariantScope().getTaskName("strip", "DebugSymbols");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName(\"strip\", \"DebugSymbols\")");
            return string;
        }

        @Override
        @NotNull
        public Class<StripDebugSymbolsTask> getType() {
            return StripDebugSymbolsTask.class;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<? extends StripDebugSymbolsTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.getVariantScope().getArtifacts().producesDir((ArtifactType<Directory>)((ArtifactType)InternalArtifactType.STRIPPED_NATIVE_LIBS.INSTANCE), BuildArtifactsHolder.OperationType.APPEND, taskProvider, (Function1)StripDebugSymbolsTask$CreationAction$handleProvider$1.INSTANCE, "out");
        }

        @Override
        public void configure(@NotNull StripDebugSymbolsTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            this.getVariantScope().getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.MERGED_NATIVE_LIBS.INSTANCE, (Property)task.getInputDir());
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            BaseExtension baseExtension = globalScope.getExtension();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseExtension, (String)"variantScope.globalScope.extension");
            PackagingOptions packagingOptions = baseExtension.getPackagingOptions();
            Intrinsics.checkExpressionValueIsNotNull((Object)packagingOptions, (String)"variantScope.globalScope\u2026xtension.packagingOptions");
            Set<String> set = packagingOptions.getDoNotStrip();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"variantScope.globalScope\u2026ckagingOptions.doNotStrip");
            task.excludePatterns = CollectionsKt.sorted((Iterable)set);
            GlobalScope globalScope2 = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"variantScope.globalScope");
            task.stripToolFinderProvider = globalScope2.getSdkComponents().getStripExecutableFinderProvider();
        }

        public CreationAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            super(variantScope);
        }
    }
}

