/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

public class AndroidReportTask
extends DefaultTask
implements AndroidTestTask {
    private final List<AndroidTestTask> subTasks = Lists.newArrayList();
    private ReportType reportType;
    private boolean ignoreFailures;
    private boolean testFailed;
    private Supplier<File> reportsDir;
    private Supplier<File> resultsDir;

    @OutputDirectory
    public File getReportsDir() {
        return this.reportsDir.get();
    }

    public void setReportsDir(Supplier<File> reportsDir) {
        this.reportsDir = TaskInputHelper.memoize(reportsDir);
    }

    @Override
    @OutputDirectory
    public File getResultsDir() {
        return this.resultsDir.get();
    }

    public void setResultsDir(Supplier<File> resultsDir) {
        this.resultsDir = TaskInputHelper.memoize(resultsDir);
    }

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.testFailed;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType2) {
        this.reportType = reportType2;
    }

    public void addTask(AndroidTestTask task) {
        this.subTasks.add(task);
        this.dependsOn(new Object[]{task});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getResultsDirectories() {
        return this.subTasks.stream().map(AndroidTestTask::getResultsDir).collect(Collectors.toList());
    }

    public void setWillRun() {
        for (AndroidTestTask task : this.subTasks) {
            task.setIgnoreFailures(true);
        }
    }

    @TaskAction
    public void createReport() throws IOException {
        File resultsOutDir = this.resultsDir.get();
        File reportOutDir = this.reportsDir.get();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        FileUtils.cleanOutputDir((File)reportOutDir);
        this.copyResults(resultsOutDir);
        TestReport report2 = new TestReport(this.reportType, resultsOutDir, reportOutDir);
        report2.generateReport();
        for (AndroidTestTask task : this.subTasks) {
            if (!task.getTestFailed()) continue;
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
                break;
            }
            throw new GradleException(message);
        }
    }

    private void copyResults(File reportOutDir) throws IOException {
        List<File> resultDirectories = this.getResultsDirectories();
        for (File directory : resultDirectories) {
            FileUtils.copyDirectory((File)directory, (File)reportOutDir);
        }
    }

    public static class CreationAction
    extends TaskCreationAction<AndroidReportTask> {
        private final GlobalScope scope;
        private final TaskKind taskKind;

        public CreationAction(GlobalScope scope, TaskKind taskKind) {
            this.scope = scope;
            this.taskKind = taskKind;
        }

        @Override
        public String getName() {
            return (this.taskKind == TaskKind.CONNECTED ? "connected" : "device") + "AndroidTest";
        }

        @Override
        public Class<AndroidReportTask> getType() {
            return AndroidReportTask.class;
        }

        @Override
        public void configure(AndroidReportTask task) {
            task.setGroup("verification");
            task.setDescription(this.taskKind == TaskKind.CONNECTED ? "Installs and runs instrumentation tests for all flavors on connected devices." : "Installs and runs instrumentation tests using all Device Providers.");
            task.setReportType(ReportType.MULTI_FLAVOR);
            String defaultReportsDir = this.scope.getReportsDir().getAbsolutePath() + "/" + "androidTests";
            String defaultResultsDir = this.scope.getOutputsDir().getAbsolutePath() + "/" + "androidTest-results";
            String subfolderName = this.taskKind == TaskKind.CONNECTED ? "/connected/" : "/devices/";
            task.resultsDir = TaskInputHelper.memoize(() -> {
                String dir = this.scope.getExtension().getTestOptions().getResultsDir();
                String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                return this.scope.getProject().file((Object)(rootLocation + subfolderName + "all"));
            });
            task.reportsDir = TaskInputHelper.memoize(() -> {
                String dir = this.scope.getExtension().getTestOptions().getReportDir();
                String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                return this.scope.getProject().file((Object)(rootLocation + subfolderName + "all"));
            });
        }

        public static enum TaskKind {
            CONNECTED,
            DEVICE_PROVIDER;

        }
    }
}

