/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.cxx.logging.ErrorsAreFatalThreadLoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class ExternalNativeBuildTask
extends NonIncrementalTask {
    private Provider<ExternalNativeJsonGenerator> generator;
    private String ndkVersionFromDsl;
    public static final String BUILD_TARGETS_PLACEHOLDER = "{LIST_OF_TARGETS_TO_BUILD}";

    @Override
    protected void doTaskAction() throws BuildCommandException, IOException {
        try (ErrorsAreFatalThreadLoggingEnvironment ignore = new ErrorsAreFatalThreadLoggingEnvironment();){
            this.buildImpl();
        }
    }

    @VisibleForTesting
    static boolean isAcceptableNdkVersionFromDsl(String ndkVersionFromDsl) {
        if (Strings.isNullOrEmpty((String)ndkVersionFromDsl)) {
            return true;
        }
        if (ndkVersionFromDsl.trim().isEmpty()) {
            return true;
        }
        int dotCount = ndkVersionFromDsl.length() - ndkVersionFromDsl.replace(".", "").length();
        return dotCount == 2;
    }

    private void buildImpl() throws BuildCommandException, IOException {
        LoggingEnvironmentKt.infoln("starting build", new Object[0]);
        Preconditions.checkNotNull((Object)this.getVariantName());
        LoggingEnvironmentKt.infoln("reading expected JSONs", new Object[0]);
        List<NativeBuildConfigValueMini> miniConfigs = this.getNativeBuildConfigValueMinis();
        LoggingEnvironmentKt.infoln("done reading expected JSONs", new Object[0]);
        if (!ExternalNativeBuildTask.isAcceptableNdkVersionFromDsl(this.ndkVersionFromDsl)) {
            LoggingEnvironmentKt.errorln("Specified android.ndkVersion '%s' does not have correct precision. Use major.minor.micro in version.", this.ndkVersionFromDsl);
            return;
        }
        Set<String> targets = ((ExternalNativeJsonGenerator)this.generator.get()).variant.getBuildTargetSet();
        if (targets.isEmpty()) {
            LoggingEnvironmentKt.infoln("executing build commands for targets that produce .so files or executables", new Object[0]);
        } else {
            this.verifyTargetsExist(miniConfigs);
        }
        ArrayList buildSteps = Lists.newArrayList();
        for (int miniConfigIndex = 0; miniConfigIndex < miniConfigs.size(); ++miniConfigIndex) {
            NativeBuildConfigValueMini config2 = miniConfigs.get(miniConfigIndex);
            LoggingEnvironmentKt.infoln("evaluate miniconfig", new Object[0]);
            if (config2.libraries.isEmpty()) {
                LoggingEnvironmentKt.infoln("no libraries", new Object[0]);
                continue;
            }
            List<NativeLibraryValueMini> librariesToBuild = this.findLibrariesToBuild(config2);
            if (librariesToBuild.isEmpty()) {
                LoggingEnvironmentKt.infoln("no libraries to build", new Object[0]);
                continue;
            }
            if (!Strings.isNullOrEmpty((String)config2.buildTargetsCommand)) {
                List artifactNames = librariesToBuild.stream().filter(library -> library.artifactName != null).map(library -> library.artifactName).sorted().distinct().collect(Collectors.toList());
                String buildTargetsCommand = ExternalNativeBuildTask.substituteBuildTargetsCommand(config2.buildTargetsCommand, artifactNames);
                buildSteps.add(new BuildStep(buildTargetsCommand, librariesToBuild, ((ExternalNativeJsonGenerator)this.generator.get()).getNativeBuildConfigurationsJsons().get(miniConfigIndex).getParentFile()));
                LoggingEnvironmentKt.infoln("about to build targets " + String.join((CharSequence)", ", artifactNames), new Object[0]);
                continue;
            }
            for (NativeLibraryValueMini libraryValue : librariesToBuild) {
                assert (libraryValue.buildCommand != null);
                buildSteps.add(new BuildStep(libraryValue.buildCommand, libraryValue, ((ExternalNativeJsonGenerator)this.generator.get()).getNativeBuildConfigurationsJsons().get(miniConfigIndex).getParentFile()));
                LoggingEnvironmentKt.infoln("about to build %s", libraryValue.buildCommand);
            }
        }
        this.executeProcessBatch(buildSteps);
        LoggingEnvironmentKt.infoln("check expected build outputs", new Object[0]);
        for (NativeBuildConfigValueMini config2 : miniConfigs) {
            for (String library2 : config2.libraries.keySet()) {
                NativeLibraryValueMini libraryValue;
                libraryValue = config2.libraries.get(library2);
                Preconditions.checkNotNull((Object)libraryValue);
                Preconditions.checkNotNull((Object)libraryValue.output);
                Preconditions.checkState((!Strings.isNullOrEmpty((String)libraryValue.artifactName) ? 1 : 0) != 0);
                if (!targets.isEmpty() && !targets.contains(libraryValue.artifactName) || buildSteps.stream().noneMatch(step -> ((BuildStep)step).libraries.contains(libraryValue))) continue;
                if (!libraryValue.output.exists()) {
                    throw new GradleException(String.format("Expected output file at %s for target %s but there was none", libraryValue.output, libraryValue.artifactName));
                }
                if (libraryValue.abi == null) {
                    throw new GradleException("Expected NativeLibraryValue to have non-null abi");
                }
                Abi abi = Abi.getByName(libraryValue.abi);
                if (abi == null) {
                    throw new RuntimeException(String.format("Unknown ABI seen %s", libraryValue.abi));
                }
                File expectedOutputFile = FileUtils.join((File)((ExternalNativeJsonGenerator)this.generator.get()).variant.getObjFolder(), (String[])new String[]{abi.getTag(), libraryValue.output.getName()});
                if (FileUtils.isSameFile((File)libraryValue.output, (File)expectedOutputFile)) continue;
                LoggingEnvironmentKt.infoln("external build set its own library output location for '%s', copy to expected location", libraryValue.output.getName());
                if (expectedOutputFile.getParentFile().mkdirs()) {
                    LoggingEnvironmentKt.infoln("created folder %s", expectedOutputFile.getParentFile());
                }
                LoggingEnvironmentKt.infoln("copy file %s to %s", libraryValue.output, expectedOutputFile);
                Files.copy((File)libraryValue.output, (File)expectedOutputFile);
            }
        }
        if (!this.getStlSharedObjectFiles().isEmpty()) {
            LoggingEnvironmentKt.infoln("copy STL shared object files", new Object[0]);
            for (Abi abi : this.getStlSharedObjectFiles().keySet()) {
                File stlSharedObjectFile = (File)Preconditions.checkNotNull((Object)this.getStlSharedObjectFiles().get((Object)abi));
                File objAbi = FileUtils.join((File)((ExternalNativeJsonGenerator)this.generator.get()).variant.getObjFolder(), (String[])new String[]{abi.getTag(), stlSharedObjectFile.getName()});
                if (!objAbi.getParentFile().isDirectory()) {
                    LoggingEnvironmentKt.infoln("didn't copy STL file to %s because that folder wasn't created by the build ", objAbi.getParentFile());
                    continue;
                }
                LoggingEnvironmentKt.infoln("copy file %s to %s", stlSharedObjectFile, objAbi);
                Files.copy((File)stlSharedObjectFile, (File)objAbi);
            }
        }
        LoggingEnvironmentKt.infoln("build complete", new Object[0]);
    }

    private static String substituteBuildTargetsCommand(String buildTargetsCommand, List<String> artifactNames) {
        return buildTargetsCommand.replace(BUILD_TARGETS_PLACEHOLDER, String.join((CharSequence)" ", artifactNames));
    }

    private void verifyTargetsExist(List<NativeBuildConfigValueMini> miniConfigs) {
        Set<String> targets = ((ExternalNativeJsonGenerator)this.generator.get()).variant.getBuildTargetSet();
        LoggingEnvironmentKt.infoln("executing build commands for targets: '%s'", Joiner.on((String)", ").join(targets));
        HashSet matchingTargets = Sets.newHashSet();
        HashSet unmatchedTargets = Sets.newHashSet();
        for (NativeBuildConfigValueMini config2 : miniConfigs) {
            for (NativeLibraryValueMini libraryValue : config2.libraries.values()) {
                if (targets.contains(libraryValue.artifactName)) {
                    matchingTargets.add(libraryValue.artifactName);
                    continue;
                }
                unmatchedTargets.add(libraryValue.artifactName);
            }
        }
        for (String target : targets) {
            if (matchingTargets.contains(target)) continue;
            throw new GradleException(String.format("Unexpected native build target %s. Valid values are: %s", target, Joiner.on((String)", ").join((Iterable)unmatchedTargets)));
        }
    }

    private List<NativeLibraryValueMini> findLibrariesToBuild(NativeBuildConfigValueMini config2) {
        ArrayList librariesToBuild = Lists.newArrayList();
        Set<String> targets = ((ExternalNativeJsonGenerator)this.generator.get()).variant.getBuildTargetSet();
        block8: for (NativeLibraryValueMini libraryValue : config2.libraries.values()) {
            LoggingEnvironmentKt.infoln("evaluate library %s (%s)", libraryValue.artifactName, libraryValue.abi);
            if (!targets.isEmpty() && !targets.contains(libraryValue.artifactName)) {
                LoggingEnvironmentKt.infoln("not building target %s because it isn't in targets set", libraryValue.artifactName);
                continue;
            }
            if (Strings.isNullOrEmpty((String)config2.buildTargetsCommand) && Strings.isNullOrEmpty((String)libraryValue.buildCommand)) {
                LoggingEnvironmentKt.infoln("not building target %s because there was no buildCommand for the target, nor a buildTargetsCommand for the config", libraryValue.artifactName);
                continue;
            }
            if (targets.isEmpty()) {
                String extension;
                if (libraryValue.output == null) {
                    LoggingEnvironmentKt.infoln("not building target %s because no targets are specified and library build output file is null", libraryValue.artifactName);
                    continue;
                }
                switch (extension = Files.getFileExtension((String)libraryValue.output.getName())) {
                    case "so": {
                        LoggingEnvironmentKt.infoln("building target library %s because no targets are specified.", libraryValue.artifactName);
                        break;
                    }
                    case "": {
                        LoggingEnvironmentKt.infoln("building target executable %s because no targets are specified.", libraryValue.artifactName);
                        break;
                    }
                    default: {
                        LoggingEnvironmentKt.infoln("not building target %s because the type cannot be determined.", libraryValue.artifactName);
                        continue block8;
                    }
                }
            }
            librariesToBuild.add(libraryValue);
        }
        return librariesToBuild;
    }

    private List<NativeBuildConfigValueMini> getNativeBuildConfigValueMinis() throws IOException {
        if (this.getStats().getNativeBuildConfigCount() == 0) {
            return AndroidBuildGradleJsons.getNativeBuildMiniConfigs(((ExternalNativeJsonGenerator)this.generator.get()).getNativeBuildConfigurationsJsons(), this.getStats());
        }
        return AndroidBuildGradleJsons.getNativeBuildMiniConfigs(((ExternalNativeJsonGenerator)this.generator.get()).getNativeBuildConfigurationsJsons(), null);
    }

    private void executeProcessBatch(List<BuildStep> buildSteps) throws BuildCommandException, IOException {
        Logger logger = this.getLogger();
        GradleProcessExecutor processExecutor = new GradleProcessExecutor(this.getProject());
        for (BuildStep buildStep : buildSteps) {
            String logFileSuffix;
            List tokens = StringHelper.tokenizeCommandLineToEscaped((String)buildStep.buildCommand);
            ProcessInfoBuilder processBuilder = new ProcessInfoBuilder();
            processBuilder.setExecutable((String)tokens.get(0));
            for (int i2 = 1; i2 < tokens.size(); ++i2) {
                processBuilder.addArgs((String)tokens.get(i2));
            }
            LoggingEnvironmentKt.infoln("%s", processBuilder);
            if (buildStep.libraries.size() > 1) {
                logFileSuffix = "targets";
                List targetNames = buildStep.libraries.stream().map(library -> library.artifactName + "_" + library.abi).collect(Collectors.toList());
                logger.lifecycle(String.format("Build multiple targets %s", String.join((CharSequence)" ", targetNames)));
            } else {
                Preconditions.checkElementIndex((int)0, (int)buildStep.libraries.size());
                logFileSuffix = ((NativeLibraryValueMini)((BuildStep)buildStep).libraries.get((int)0)).artifactName + "_" + ((NativeLibraryValueMini)((BuildStep)buildStep).libraries.get((int)0)).abi;
                this.getLogger().lifecycle(String.format("Build %s", logFileSuffix));
            }
            ProcessOutputJunctionKt.createProcessOutputJunction(buildStep.outputFolder, "android_gradle_build_" + logFileSuffix, processBuilder, logger, processExecutor, "").logStderrToInfo().logStdoutToInfo().execute();
        }
    }

    public File getObjFolder() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).getObjFolder();
    }

    public File getSoFolder() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).getSoFolder();
    }

    private Map<Abi, File> getStlSharedObjectFiles() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).getStlSharedObjectFiles();
    }

    private GradleBuildVariant.Builder getStats() {
        return ((ExternalNativeJsonGenerator)this.generator.get()).stats;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<ExternalNativeBuildTask> {
        private final Provider<ExternalNativeJsonGenerator> generator;
        private final TaskProvider<? extends Task> generateTask;

        public CreationAction(Provider<ExternalNativeJsonGenerator> generator, TaskProvider<? extends Task> generateTask, VariantScope scope) {
            super(scope);
            this.generator = generator;
            this.generateTask = generateTask;
        }

        @Override
        public String getName() {
            return this.getVariantScope().getTaskName("externalNativeBuild");
        }

        @Override
        public Class<ExternalNativeBuildTask> getType() {
            return ExternalNativeBuildTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<? extends ExternalNativeBuildTask> taskProvider) {
            super.handleProvider(taskProvider);
            this.getVariantScope().getTaskContainer().getExternalNativeBuildTasks().add(taskProvider);
            this.getVariantScope().getTaskContainer().setExternalNativeBuildTask(taskProvider);
        }

        @Override
        public void configure(ExternalNativeBuildTask task) {
            super.configure(task);
            VariantScope scope = this.getVariantScope();
            task.dependsOn(new Object[]{this.generateTask, scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.JNI)});
            task.generator = this.generator;
            task.ndkVersionFromDsl = scope.getGlobalScope().getExtension().getNdkVersion();
        }
    }

    private static class BuildStep {
        private String buildCommand;
        private List<NativeLibraryValueMini> libraries;
        private File outputFolder;

        BuildStep(String buildCommand, NativeLibraryValueMini library, File outputFolder) {
            this(buildCommand, Lists.newArrayList((Object[])new NativeLibraryValueMini[]{library}), outputFolder);
        }

        BuildStep(String buildCommand, List<NativeLibraryValueMini> libraries, File outputFolder) {
            this.buildCommand = buildCommand;
            this.libraries = libraries;
            this.outputFolder = outputFolder;
        }
    }
}

