/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant2;

import com.android.build.api.dsl.model.BuildType;
import com.android.build.api.dsl.model.ProductFlavor;
import com.android.build.api.dsl.model.ProductFlavorOrVariant;
import com.android.build.api.dsl.model.VariantProperties;
import com.android.build.api.dsl.variant.AndroidTestVariant;
import com.android.build.api.dsl.variant.UnitTestVariant;
import com.android.build.api.dsl.variant.Variant;
import com.android.build.api.sourcesets.AndroidSourceSet;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.build.gradle.internal.api.dsl.extensions.BaseExtension2;
import com.android.build.gradle.internal.api.dsl.extensions.VariantOrExtensionPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.model.BuildTypeImpl;
import com.android.build.gradle.internal.api.dsl.model.BuildTypeOrVariantImpl;
import com.android.build.gradle.internal.api.dsl.model.ProductFlavorOrVariantImpl;
import com.android.build.gradle.internal.api.dsl.model.VariantPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.variant.CommonVariantPropertiesImpl;
import com.android.build.gradle.internal.api.dsl.variant.SealableVariant;
import com.android.build.gradle.internal.api.sourcesets.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.variant2.DimensionData;
import com.android.build.gradle.internal.variant2.DslModelDataImpl;
import com.android.build.gradle.internal.variant2.FlavorCombination;
import com.android.build.gradle.internal.variant2.VariantBuilder;
import com.android.build.gradle.internal.variant2.VariantBuilderKt;
import com.android.build.gradle.internal.variant2.VariantDispatchImpl;
import com.android.build.gradle.internal.variant2.VariantFactory2;
import com.android.build.gradle.internal.variant2.VariantFilterImpl;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020$H\u0002J*\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u001eH\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020,0\u0018H\u0002J\u001a\u0010/\u001a\u0002002\u0006\u0010-\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0006\u00101\u001a\u000200J\u0016\u00102\u001a\u00020 2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0018H\u0002J\u0016\u00105\u001a\u00020$2\f\u00103\u001a\b\u0012\u0004\u0012\u0002060\u0018H\u0002R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0000X\u0088\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00067"}, d2={"Lcom/android/build/gradle/internal/variant2/VariantBuilder;", "E", "Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;", "", "dslModelData", "Lcom/android/build/gradle/internal/variant2/DslModelDataImpl;", "extension", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lcom/android/build/gradle/internal/variant2/DslModelDataImpl;Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "_shims", "", "Lcom/android/build/api/dsl/variant/Variant;", "_variants", "", "Lcom/android/build/gradle/internal/api/dsl/variant/SealableVariant;", "Lcom/android/build/gradle/internal/api/dsl/extensions/BaseExtension2;", "generated", "", "shims", "", "getShims", "()Ljava/util/Collection;", "variants", "", "getVariants", "()Ljava/util/List;", "cloneBuildTypeOrVariant", "Lcom/android/build/gradle/internal/api/dsl/model/BuildTypeOrVariantImpl;", "that", "Lcom/android/build/api/dsl/model/BuildType;", "cloneProductFlavorOrVariant", "Lcom/android/build/gradle/internal/api/dsl/model/ProductFlavorOrVariantImpl;", "cloneVariantOrExtensionProperties", "Lcom/android/build/gradle/internal/api/dsl/extensions/VariantOrExtensionPropertiesImpl;", "cloneVariantProperties", "Lcom/android/build/gradle/internal/api/dsl/model/VariantPropertiesImpl;", "computeCommonVariantPropertiesImpl", "Lcom/android/build/gradle/internal/api/dsl/variant/CommonVariantPropertiesImpl;", "variantType", "Lcom/android/builder/core/VariantType;", "variantName", "", "flavorCombo", "Lcom/android/build/gradle/internal/variant2/FlavorCombination;", "buildType", "computeFlavorCombo", "createVariant", "", "generateVariants", "mergeProductFlavorOrVariant", "items", "Lcom/android/build/api/dsl/model/ProductFlavorOrVariant;", "mergeVariantProperties", "Lcom/android/build/api/dsl/model/VariantProperties;", "gradle"})
public final class VariantBuilder<E extends BaseExtension2> {
    private boolean generated;
    private final List<SealableVariant> _variants;
    private final Map<Variant, Variant> _shims;
    private final DslModelDataImpl<E> dslModelData;
    private final E extension;
    private final DslScope dslScope;

    @NotNull
    public final List<SealableVariant> getVariants() {
        if (!this.generated) {
            throw (Throwable)new RuntimeException("VariantBuilder.generateVariants() not called");
        }
        return this._variants;
    }

    @NotNull
    public final Collection<Variant> getShims() {
        if (!this.generated) {
            throw (Throwable)new RuntimeException("VariantBuilder.generateVariants() not called");
        }
        return this._shims.values();
    }

    public final void generateVariants() {
        List<FlavorCombination> flavorCombinations = this.computeFlavorCombo();
        if (flavorCombinations.isEmpty()) {
            Iterator iterator = this.dslModelData.getBuildTypes().iterator();
            while (iterator.hasNext()) {
                BuildType buildType;
                BuildType buildType2 = buildType = (BuildType)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)buildType2, (String)"buildType");
                this.createVariant(buildType2, null);
            }
        } else {
            for (BuildType buildType : this.dslModelData.getBuildTypes()) {
                for (FlavorCombination flavorCombo : flavorCombinations) {
                    BuildType buildType3 = buildType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)buildType3, (String)"buildType");
                    this.createVariant(buildType3, flavorCombo);
                }
            }
        }
        this.generated = true;
    }

    private final List<FlavorCombination> computeFlavorCombo() {
        List flavorDimensions = this.extension.getFlavorDimensions();
        if (this.dslModelData.getProductFlavors().isEmpty()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        if (flavorDimensions.isEmpty()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.UNNAMED_FLAVOR_DIMENSION, new EvalIssueException("All flavors must now belong to a named flavor dimension. Learn more at https://d.android.com/r/tools/flavorDimensions-missing-error-message.html", null, null, 6, null));
        } else if (flavorDimensions.size() == 1) {
            String dimensionName = (String)flavorDimensions.get(0);
            for (ProductFlavor productFlavor : this.dslModelData.getProductFlavors()) {
                productFlavor.setDimension(dimensionName);
            }
        }
        return VariantBuilderKt.access$createCombinations(flavorDimensions, (Set)this.dslModelData.getProductFlavors(), this.dslScope.getIssueReporter());
    }

    private final void createVariant(BuildType buildType, FlavorCombination flavorCombo) {
        String string = buildType.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildType.name");
        Object object = flavorCombo;
        if (object == null || (object = ((FlavorCombination)object).getFlavorNames()) == null) {
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of()");
            object = (List)immutableList;
        }
        VariantFilterImpl filterObject = new VariantFilterImpl(string, (List<String>)object, this.dslScope);
        for (Action filter : this.extension.getVariantFilters()) {
            filter.execute((Object)filterObject);
            if (!filterObject.getIgnoresAll()) continue;
            return;
        }
        filterObject.seal();
        boolean bl = false;
        List items = new ArrayList();
        items.add(this.dslModelData.getDefaultConfig());
        FlavorCombination flavorCombination = flavorCombo;
        if (flavorCombination != null) {
            FlavorCombination flavorCombination2 = flavorCombination;
            boolean bl2 = false;
            boolean bl3 = false;
            FlavorCombination it = flavorCombination2;
            boolean bl4 = false;
            items.addAll((Collection)it.getFlavors());
        }
        ProductFlavorOrVariantImpl productFlavorOrVariant = this.mergeProductFlavorOrVariant(TypeIntrinsics.asMutableList((Object)items));
        items.add(buildType);
        VariantPropertiesImpl variantProperties = this.mergeVariantProperties(TypeIntrinsics.asMutableList((Object)items));
        String appIdSuffixFromFlavors2 = VariantBuilderKt.access$combineSuffixes(TypeIntrinsics.asMutableList((Object)items), createVariant.appIdSuffixFromFlavors.1.INSTANCE, Character.valueOf('.'));
        String variantNameSuffixFromFlavors2 = VariantBuilderKt.access$combineSuffixes(TypeIntrinsics.asMutableList((Object)items), createVariant.variantNameSuffixFromFlavors.1.INSTANCE, null);
        BuildTypeOrVariantImpl buildTypOrVariant = this.cloneBuildTypeOrVariant(buildType);
        VariantOrExtensionPropertiesImpl variantExtensionProperties = this.cloneVariantOrExtensionProperties(this.extension.getVariantExtensionProperties());
        List<VariantFactory2<E>> variantFactories = this.dslModelData.getVariantFactories$gradle();
        VariantDispatchImpl variantDispatcher = new VariantDispatchImpl();
        boolean bl5 = false;
        Map createdVariantMap = new LinkedHashMap();
        boolean duplicateCommonProps = false;
        for (VariantFactory2<E> factory2 : variantFactories) {
            VariantType generatedType = factory2.getGeneratedType();
            if (filterObject.ignores(generatedType)) continue;
            String string2 = buildType.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buildType.name");
            FlavorCombination flavorCombination3 = flavorCombo;
            String variantName = VariantBuilderKt.access$computeVariantName(string2, flavorCombination3 != null ? flavorCombination3.getName() : null, generatedType, factory2.getTestTarget());
            productFlavorOrVariant.setApplicationId(factory2.computeApplicationId(productFlavorOrVariant, appIdSuffixFromFlavors2));
            VariantPropertiesImpl variantPropertiesCopy = !duplicateCommonProps ? variantProperties : this.cloneVariantProperties(variantProperties);
            ProductFlavorOrVariantImpl productFlavorOrVariantCopy = !duplicateCommonProps ? productFlavorOrVariant : this.cloneProductFlavorOrVariant(productFlavorOrVariant);
            BuildTypeOrVariantImpl buildTypOrVariantCopy = !duplicateCommonProps ? buildTypOrVariant : this.cloneBuildTypeOrVariant(buildTypOrVariant);
            VariantOrExtensionPropertiesImpl variantExtensionPropertiesCopy = !duplicateCommonProps ? variantExtensionProperties : this.cloneVariantOrExtensionProperties(variantExtensionProperties);
            CommonVariantPropertiesImpl commonVariantProperties = this.computeCommonVariantPropertiesImpl(generatedType, variantName, flavorCombo, buildType);
            SealableVariant variant = factory2.createVariant(this.extension, variantPropertiesCopy, productFlavorOrVariantCopy, buildTypOrVariantCopy, variantExtensionPropertiesCopy, commonVariantProperties, variantDispatcher, this.dslScope);
            VariantType variantType = variant.getVariantType();
            this._variants.add(variant);
            Variant shim = variant.createShim();
            this._shims.put(variant, shim);
            if (createdVariantMap.get(variantType) != null) {
                throw (Throwable)new RuntimeException("More than one VariantFactory with same type " + variantType);
            }
            createdVariantMap.put(variantType, variant);
            duplicateCommonProps = true;
        }
        for (VariantFactory2<E> factory2 : variantFactories) {
            Variant shim;
            VariantType variantType;
            Variant generatedVariant;
            if ((Variant)createdVariantMap.get(factory2.getGeneratedType()) == null) {
                continue;
            }
            if (this._shims.get(generatedVariant) == null) {
                Intrinsics.throwNpe();
            }
            if ((variantType = factory2.getGeneratedType()) == VariantTypeImpl.UNIT_TEST) {
                Variant variant = shim;
                if (variant == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.dsl.variant.UnitTestVariant");
                }
                variantDispatcher.setUnitTestVariant((UnitTestVariant)variant);
                continue;
            }
            if (variantType == VariantTypeImpl.ANDROID_TEST) {
                Variant variant = shim;
                if (variant == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.android.build.api.dsl.variant.AndroidTestVariant");
                }
                variantDispatcher.setAndroidTestVariant((AndroidTestVariant)variant);
                continue;
            }
            variantDispatcher.setProductionVariant(shim);
        }
    }

    private final VariantPropertiesImpl mergeVariantProperties(List<? extends VariantProperties> items) {
        Function2 setter$iv;
        Object value$iv;
        int i$iv;
        VariantPropertiesImpl variantProperties = new VariantPropertiesImpl(this.dslScope);
        Function2 function2 = VariantBuilderKt.access$getSET_MULTIDEX_ENABLED$p();
        Function1 getter$iv = VariantBuilderKt.access$getGET_MULTIDEX_ENABLED$p();
        boolean $i$f$takeLastNonNull = false;
        int n = items.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            value$iv = getter$iv.invoke((Object)items.get(i$iv));
            if (value$iv != null) {
                setter$iv.invoke((Object)variantProperties, value$iv);
                break;
            }
            --i$iv;
        }
        setter$iv = VariantBuilderKt.access$getSET_MULTIDEX_KEEPFILE$p();
        getter$iv = VariantBuilderKt.access$getGET_MULTIDEX_KEEPFILE$p();
        $i$f$takeLastNonNull = false;
        bl = false;
        for (i$iv = items.size() - 1; i$iv >= 0; --i$iv) {
            value$iv = getter$iv.invoke((Object)items.get(i$iv));
            if (value$iv == null) continue;
            setter$iv.invoke((Object)variantProperties, value$iv);
            break;
        }
        return variantProperties;
    }

    private final VariantPropertiesImpl cloneVariantProperties(VariantPropertiesImpl that) {
        VariantPropertiesImpl clone = new VariantPropertiesImpl(this.dslScope);
        clone.initWith(that);
        return clone;
    }

    /*
     * WARNING - void declaration
     */
    private final ProductFlavorOrVariantImpl mergeProductFlavorOrVariant(List<? extends ProductFlavorOrVariant> items) {
        ProductFlavorOrVariantImpl productFlavorOrVariant = new ProductFlavorOrVariantImpl(this.dslScope);
        Function2 function2 = VariantBuilderKt.access$getSET_VERSION_CODE$p();
        Function1 getter$iv = VariantBuilderKt.access$getGET_VERSION_CODE$p();
        boolean $i$f$takeLastNonNull = false;
        int n = items.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i$iv;
            Object value$iv = getter$iv.invoke((Object)items.get((int)i$iv));
            if (value$iv != null) {
                void setter$iv;
                setter$iv.invoke((Object)productFlavorOrVariant, value$iv);
                break;
            }
            --i$iv;
        }
        return productFlavorOrVariant;
    }

    private final ProductFlavorOrVariantImpl cloneProductFlavorOrVariant(ProductFlavorOrVariantImpl that) {
        ProductFlavorOrVariantImpl clone = new ProductFlavorOrVariantImpl(this.dslScope);
        clone.initWith$gradle(that);
        return clone;
    }

    private final BuildTypeOrVariantImpl cloneBuildTypeOrVariant(BuildType that) {
        BuildType buildType = that;
        if (buildType == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.android.build.gradle.internal.api.dsl.model.BuildTypeImpl");
        }
        return this.cloneBuildTypeOrVariant(((BuildTypeImpl)buildType).getBuildTypeOrVariant$gradle());
    }

    private final BuildTypeOrVariantImpl cloneBuildTypeOrVariant(BuildTypeOrVariantImpl that) {
        BuildTypeOrVariantImpl clone = new BuildTypeOrVariantImpl("Variant", this.dslScope);
        clone.initWith$gradle(that);
        return clone;
    }

    private final VariantOrExtensionPropertiesImpl cloneVariantOrExtensionProperties(VariantOrExtensionPropertiesImpl that) {
        VariantOrExtensionPropertiesImpl prop = new VariantOrExtensionPropertiesImpl(this.dslScope);
        prop.initWith(that);
        return prop;
    }

    private final CommonVariantPropertiesImpl computeCommonVariantPropertiesImpl(VariantType variantType, String variantName, FlavorCombination flavorCombo, BuildType buildType) {
        AndroidSourceSet androidSourceSet;
        ImmutableList immutableList = flavorCombo;
        if (immutableList == null || (immutableList = immutableList.getFlavors()) == null) {
            ImmutableList immutableList2 = ImmutableList.of();
            immutableList = immutableList2;
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList2, (String)"ImmutableList.of()");
        }
        ImmutableList flavors = immutableList;
        boolean bl = false;
        List sourceSets = new ArrayList();
        AndroidSourceSet androidSourceSet2 = this.dslModelData.getDefaultConfigData().getSourceSet(variantType);
        if (androidSourceSet2 != null) {
            AndroidSourceSet androidSourceSet3 = androidSourceSet2;
            boolean bl2 = false;
            boolean bl3 = false;
            AndroidSourceSet it = androidSourceSet3;
            boolean bl4 = false;
            sourceSets.add(it);
        }
        Iterable $this$forEach$iv = (Iterable)flavors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ProductFlavor it = (ProductFlavor)element$iv;
            boolean bl5 = false;
            Map<String, DimensionData<ProductFlavor>> map = this.dslModelData.getFlavorData();
            ProductFlavor productFlavor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)productFlavor, (String)"it");
            AndroidSourceSet androidSourceSet4 = map.get(productFlavor.getName());
            if (androidSourceSet4 == null || (androidSourceSet4 = androidSourceSet4.getSourceSet(variantType)) == null) continue;
            AndroidSourceSet androidSourceSet5 = androidSourceSet4;
            boolean bl6 = false;
            boolean bl7 = false;
            AndroidSourceSet it2 = androidSourceSet5;
            boolean bl8 = false;
            sourceSets.add(it2);
        }
        DefaultAndroidSourceSet multiFlavorSourceSet = null;
        Object object = flavorCombo;
        if (object != null && (object = object.getName()) != null) {
            Object $i$f$forEach2 = object;
            boolean bl9 = false;
            boolean bl10 = false;
            Object it = $i$f$forEach2;
            boolean bl11 = false;
            multiFlavorSourceSet = (DefaultAndroidSourceSet)this.dslModelData.getSourceSets().maybeCreate((String)it);
        }
        DefaultAndroidSourceSet defaultAndroidSourceSet = multiFlavorSourceSet;
        if (defaultAndroidSourceSet != null) {
            DefaultAndroidSourceSet $i$f$forEach2 = defaultAndroidSourceSet;
            boolean bl12 = false;
            boolean bl13 = false;
            DefaultAndroidSourceSet it = $i$f$forEach2;
            boolean bl14 = false;
            sourceSets.add(it);
        }
        if ((androidSourceSet = this.dslModelData.getBuildTypeData().get(buildType.getName())) != null && (androidSourceSet = androidSourceSet.getSourceSet(variantType)) != null) {
            AndroidSourceSet $i$f$forEach2 = androidSourceSet;
            boolean bl15 = false;
            boolean bl16 = false;
            AndroidSourceSet it = $i$f$forEach2;
            boolean bl17 = false;
            sourceSets.add(it);
        }
        DefaultAndroidSourceSet variantSourceSet = null;
        if (!flavors.isEmpty()) {
            DefaultAndroidSourceSet defaultAndroidSourceSet2 = variantSourceSet = (DefaultAndroidSourceSet)this.dslModelData.getSourceSets().maybeCreate(variantName);
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultAndroidSourceSet2, (String)"variantSourceSet");
            sourceSets.add(defaultAndroidSourceSet2);
        }
        String string = buildType.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buildType.name");
        Object object2 = flavorCombo;
        if (object2 == null || (object2 = object2.getFlavorNames()) == null) {
            ImmutableList immutableList3 = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList3, (String)"ImmutableList.of()");
            object2 = (List)immutableList3;
        }
        return new CommonVariantPropertiesImpl(variantName, string, (List<String>)object2, sourceSets, variantSourceSet, multiFlavorSourceSet, this.dslScope);
    }

    public VariantBuilder(@NotNull DslModelDataImpl<? super E> dslModelData, @NotNull E extension, @NotNull DslScope dslScope) {
        List list;
        Intrinsics.checkParameterIsNotNull(dslModelData, (String)"dslModelData");
        Intrinsics.checkParameterIsNotNull(extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.dslModelData = dslModelData;
        this.extension = extension;
        this.dslScope = dslScope;
        VariantBuilder variantBuilder = this;
        boolean bl = false;
        variantBuilder._variants = list = (List)new ArrayList();
        IdentityHashMap identityHashMap = Maps.newIdentityHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)identityHashMap, (String)"Maps.newIdentityHashMap()");
        this._shims = identityHashMap;
    }
}

