/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.SdkConstants;
import com.android.builder.core.DesugarProcessArgs;
import com.google.common.collect.ImmutableList;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;

public final class DesugarWorkerItem {
    private static final String DESUGAR_MAIN = "com.google.devtools.build.android.desugar.Desugar";
    private static final Logger LOGGER = Logging.getLogger(DesugarWorkerItem.class);
    private final Path java8LangSupportJar;
    private final DesugarProcessArgs args;
    private final Path lambdaTmpDir;

    public DesugarWorkerItem(Path java8LangSupportJar, DesugarProcessArgs args2, Path lambdaTmpDir) {
        this.java8LangSupportJar = java8LangSupportJar;
        this.args = args2;
        this.lambdaTmpDir = lambdaTmpDir;
    }

    public void configure(WorkerConfiguration workerConfiguration) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("desugar configuring in {}", (Object)ManagementFactory.getRuntimeMXBean().getName());
        }
        workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
        workerConfiguration.classpath((Iterable)ImmutableList.of((Object)this.java8LangSupportJar.toFile()));
        workerConfiguration.forkOptions(javaForkOptions -> javaForkOptions.setJvmArgs((List)ImmutableList.of((Object)"-Xmx64m", (Object)("-Djdk.internal.lambda.dumpProxyClasses=" + this.lambdaTmpDir.toString()))));
        boolean isWindows = SdkConstants.currentPlatform() == 2;
        workerConfiguration.setParams(new Object[]{this.args.getArgs(isWindows)});
    }

    public static class DesugarAction
    implements Runnable {
        private final List<String> args;

        @Inject
        public DesugarAction(List<String> args2) {
            this.args = args2;
        }

        @Override
        public void run() {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("New desugar in {}", (Object)ManagementFactory.getRuntimeMXBean().getName());
                }
                Class<?> clazz = Class.forName(DesugarWorkerItem.DESUGAR_MAIN);
                Method mainMethod = clazz.getMethod("main", String[].class);
                mainMethod.setAccessible(true);
                mainMethod.invoke(null, new Object[]{this.args.toArray(new String[0])});
            }
            catch (Exception e) {
                LOGGER.error("Error while running desugar ", (Throwable)e);
            }
        }
    }
}

