/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class PrepareLintJar
extends DefaultTask {
    public static final String NAME = "prepareLintJar";
    private FileCollection lintChecks;
    private File outputLintJar;

    @Classpath
    public FileCollection getLintChecks() {
        return this.lintChecks;
    }

    @OutputFile
    public File getOutputLintJar() {
        return this.outputLintJar;
    }

    @TaskAction
    public void prepare() throws IOException {
        Set files2 = this.lintChecks.getFiles();
        if (files2.size() > 1) {
            throw new RuntimeException("Found more than one jar in the 'lintChecks' configuration. Only one file is supported. If using a separate Gradle project, make sure compilation dependencies are using compileOnly");
        }
        if (files2.isEmpty()) {
            if (this.outputLintJar.isFile()) {
                FileUtils.delete((File)this.outputLintJar);
            }
        } else {
            FileUtils.mkdirs((File)this.outputLintJar.getParentFile());
            Files.copy((File)((File)Iterables.getOnlyElement((Iterable)files2)), (File)this.outputLintJar);
        }
    }

    public static class CreationAction
    extends TaskCreationAction<PrepareLintJar> {
        private final GlobalScope scope;
        private File outputLintJar;

        public CreationAction(GlobalScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return PrepareLintJar.NAME;
        }

        @Override
        public Class<PrepareLintJar> getType() {
            return PrepareLintJar.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputLintJar = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.LINT_JAR, taskName, "lint.jar");
        }

        @Override
        public void configure(PrepareLintJar task) {
            task.outputLintJar = this.outputLintJar;
            task.lintChecks = this.scope.getLocalCustomLintChecks();
        }
    }
}

