/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.gradle.FeaturePlugin;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.MergeFileTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.builder.errors.EvalIssueException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;

public class MergeConsumerProguardFilesTask
extends MergeFileTask {
    private boolean isDynamicFeature;
    private boolean isBaseFeature;
    private boolean hasFeaturePlugin;
    private List<File> consumerProguardFiles;

    @Override
    public void doTaskAction() throws IOException {
        Project project = this.getProject();
        if (!this.isBaseFeature) {
            MergeConsumerProguardFilesTask.checkProguardFiles(project, this.isDynamicFeature, this.hasFeaturePlugin, this.consumerProguardFiles, exception -> {
                throw exception;
            });
        }
        super.doTaskAction();
    }

    public static void checkProguardFiles(Project project, boolean isDynamicFeature, boolean hasFeaturePlugin, List<File> consumerProguardFiles, Consumer<EvalIssueException> exceptionHandler) {
        HashMap<File, String> defaultFiles = new HashMap<File, String>();
        for (String knownFileName : ProguardFiles.KNOWN_FILE_NAMES) {
            defaultFiles.put(ProguardFiles.getDefaultProguardFile(knownFileName, project), knownFileName);
        }
        for (File consumerProguardFile : consumerProguardFiles) {
            if (!defaultFiles.containsKey(consumerProguardFile)) continue;
            String errorMessage = isDynamicFeature || hasFeaturePlugin ? "Default file " + (String)defaultFiles.get(consumerProguardFile) + " should not be specified in this module. It can be specified in the base module instead." : "Default file " + (String)defaultFiles.get(consumerProguardFile) + " should not be used as a consumer configuration file.";
            exceptionHandler.accept(new EvalIssueException(errorMessage));
        }
    }

    public static class CreationAction
    extends TaskCreationAction<MergeConsumerProguardFilesTask> {
        private final VariantScope variantScope;
        private Provider<RegularFile> outputFile;

        public CreationAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("merge", "ConsumerProguardFiles");
        }

        @Override
        public Class<MergeConsumerProguardFilesTask> getType() {
            return MergeConsumerProguardFilesTask.class;
        }

        @Override
        public void preConfigure(String taskName) {
            super.preConfigure(taskName);
            this.outputFile = this.variantScope.getArtifacts().createArtifactFile((ArtifactType)InternalArtifactType.CONSUMER_PROGUARD_FILE, BuildArtifactsHolder.OperationType.APPEND, taskName, "proguard.txt");
        }

        @Override
        public void configure(MergeConsumerProguardFilesTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            Project project = globalScope.getProject();
            task.setOutputFile(this.outputFile);
            task.hasFeaturePlugin = project.getPlugins().hasPlugin(FeaturePlugin.class);
            task.isBaseFeature = task.hasFeaturePlugin && globalScope.getExtension().getBaseFeature() != false;
            if (task.isBaseFeature) {
                task.isDynamicFeature = this.variantScope.getType().isDynamicFeature();
            }
            task.consumerProguardFiles = this.variantScope.getConsumerProguardFilesForFeatures();
            ConfigurableFileCollection inputFiles = project.files(new Object[]{task.consumerProguardFiles, this.variantScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.GENERATED_PROGUARD_FILE)});
            if (this.variantScope.getType().isFeatureSplit()) {
                inputFiles.from(new Object[]{this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CONSUMER_PROGUARD_RULES)});
            }
            task.setInputFiles((FileCollection)inputFiles);
        }
    }
}

