/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.InstallableVariant;
import com.android.build.gradle.internal.api.AndroidArtifactVariantImpl;
import com.android.build.gradle.internal.api.ReadOnlyObjectProvider;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.variant.InstallableVariantData;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Task;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.TaskProvider;

public abstract class InstallableVariantImpl
extends AndroidArtifactVariantImpl
implements InstallableVariant {
    protected InstallableVariantImpl(ObjectFactory objectFactory, ReadOnlyObjectProvider immutableObjectProvider, NamedDomainObjectContainer<BaseVariantOutput> outputs) {
        super(objectFactory, immutableObjectProvider, outputs);
    }

    @Override
    public abstract InstallableVariantData getVariantData();

    @Override
    public DefaultTask getInstall() {
        InstallableVariantData variantData = this.getVariantData();
        variantData.getScope().getGlobalScope().getDslScope().getDeprecationReporter().reportDeprecatedApi("variantOutput.getInstallProvider()", "variantOutput.getInstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (variantData.getTaskContainer().getInstallTask() != null) {
            return (DefaultTask)variantData.getTaskContainer().getInstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getInstallProvider() {
        return this.getVariantData().getTaskContainer().getInstallTask();
    }

    @Override
    public DefaultTask getUninstall() {
        InstallableVariantData variantData = this.getVariantData();
        variantData.getScope().getGlobalScope().getDslScope().getDeprecationReporter().reportDeprecatedApi("variantOutput.getUninstallProvider()", "variantOutput.getUninstall()", "https://d.android.com/r/tools/task-configuration-avoidance", DeprecationReporter.DeprecationTarget.TASK_ACCESS_VIA_VARIANT);
        if (variantData.getTaskContainer().getUninstallTask() != null) {
            return (DefaultTask)variantData.getTaskContainer().getUninstallTask().getOrNull();
        }
        return null;
    }

    @Override
    public TaskProvider<Task> getUninstallProvider() {
        return this.getVariantData().getTaskContainer().getUninstallTask();
    }

    @Incubating
    public BuildableArtifact getFinalArtifact(ArtifactType artifactType) {
        return this.getVariantData().getScope().getArtifacts().getFinalArtifactFiles(artifactType);
    }
}

