/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.tasks.BundleInstallUtils;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.utils.GuavaKtxKt;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.process.ProcessExecutor;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/test/BundleTestDataImpl;", "Lcom/android/build/gradle/internal/test/AbstractTestDataImpl;", "testVariantData", "Lcom/android/build/gradle/internal/variant/TestVariantData;", "testApkDir", "Lcom/android/build/api/artifact/BuildableArtifact;", "moduleName", "", "apkBundle", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/variant/TestVariantData;Lcom/android/build/api/artifact/BuildableArtifact;Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "getApplicationId", "getTestedApks", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "splitSelectExe", "deviceConfigProvider", "Lcom/android/builder/testing/api/DeviceConfigProvider;", "logger", "Lcom/android/utils/ILogger;", "getTestedApksFromBundle", "getTestedApplicationId", "isLibrary", "", "loadFromMetadataFile", "", "metadataFile", "gradle"})
public final class BundleTestDataImpl
extends AbstractTestDataImpl {
    private final TestVariantData testVariantData;
    private final String moduleName;
    private final FileCollection apkBundle;

    public void loadFromMetadataFile(@NotNull File metadataFile) {
        Intrinsics.checkParameterIsNotNull((Object)metadataFile, (String)"metadataFile");
    }

    @NotNull
    public String getApplicationId() {
        String string = this.testVariantData.getApplicationId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"testVariantData.applicationId");
        return string;
    }

    @Nullable
    public String getTestedApplicationId() {
        GradleVariantConfiguration gradleVariantConfiguration = this.testVariantData.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"testVariantData.variantConfiguration");
        return gradleVariantConfiguration.getTestedApplicationId();
    }

    public boolean isLibrary() {
        TestedVariantData testedVariantData = this.testVariantData.getTestedVariantData();
        Intrinsics.checkExpressionValueIsNotNull((Object)testedVariantData, (String)"testVariantData.testedVariantData");
        VariantConfiguration variantConfiguration = testedVariantData.getVariantConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)variantConfiguration, (String)"testVariantData.testedVa\u2026Data.variantConfiguration");
        return variantConfiguration.getType().isAar();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ImmutableList<File> getTestedApks(@NotNull ProcessExecutor processExecutor, @Nullable File splitSelectExe, @NotNull DeviceConfigProvider deviceConfigProvider, @NotNull ILogger logger) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)processExecutor, (String)"processExecutor");
        Intrinsics.checkParameterIsNotNull((Object)deviceConfigProvider, (String)"deviceConfigProvider");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (this.moduleName != null && deviceConfigProvider.getApiLevel() < 21) {
            logger.warning("Testing dynamic features on devices API < 21 is not currently supported.", new Object[0]);
            ImmutableList immutableList = ImmutableList.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.of<File>()");
            return immutableList;
        }
        Path path = this.apkBundle.getSingleFile().toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"apkBundle.singleFile.toPath()");
        Iterable $this$map$iv = BundleInstallUtils.getApkFiles(path, deviceConfigProvider, this.moduleName);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.toFile();
            collection.add(file);
        }
        return GuavaKtxKt.toImmutableList((List)destination$iv$iv);
    }

    @Override
    @Nullable
    public FileCollection getTestedApksFromBundle() {
        return this.apkBundle;
    }

    public BundleTestDataImpl(@NotNull TestVariantData testVariantData, @NotNull BuildableArtifact testApkDir, @Nullable String moduleName, @NotNull FileCollection apkBundle) {
        Intrinsics.checkParameterIsNotNull((Object)testVariantData, (String)"testVariantData");
        Intrinsics.checkParameterIsNotNull((Object)testApkDir, (String)"testApkDir");
        Intrinsics.checkParameterIsNotNull((Object)apkBundle, (String)"apkBundle");
        super(testVariantData.getVariantConfiguration(), testApkDir, null);
        this.testVariantData = testVariantData;
        this.moduleName = moduleName;
        this.apkBundle = apkBundle;
    }
}

