/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DexParams;
import com.android.build.gradle.internal.tasks.DexingRunnable;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.Workers;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.sdklib.AndroidVersion;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001(B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010&\u001a\u00020'H\u0014R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00178G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u001b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR,\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020 0\u001f8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryDexingTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "executor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "bootClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBootClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "classes", "Lorg/gradle/api/file/RegularFileProperty;", "getClasses", "()Lorg/gradle/api/file/RegularFileProperty;", "classpath", "getClasspath", "enableDesugaring", "Lorg/gradle/api/provider/Property;", "", "getEnableDesugaring", "()Lorg/gradle/api/provider/Property;", "<set-?>", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "errorFormatMode", "getErrorFormatMode", "()Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "", "minSdkVersion", "getMinSdkVersion", "()I", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "output", "getOutput", "()Lorg/gradle/api/provider/Provider;", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "doTaskAction", "", "CreationAction", "gradle"})
public abstract class LibraryDexingTask
extends NonIncrementalTask {
    private final WorkerExecutorFacade workers;
    @NotNull
    private Provider<Directory> output;
    private int minSdkVersion;
    @NotNull
    private SyncOptions.ErrorFormatMode errorFormatMode;

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract RegularFileProperty getClasses();

    @OutputDirectory
    @NotNull
    public final Provider<Directory> getOutput() {
        return this.output;
    }

    @Input
    public final int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getEnableDesugaring();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getBootClasspath();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getClasspath();

    @Internal
    @NotNull
    public final SyncOptions.ErrorFormatMode getErrorFormatMode() {
        SyncOptions.ErrorFormatMode errorFormatMode = this.errorFormatMode;
        if (errorFormatMode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorFormatMode");
        }
        return errorFormatMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() {
        Closeable closeable = (Closeable)this.workers;
        boolean bl = false;
        Throwable throwable = null;
        try {
            WorkerExecutorFacade it = (WorkerExecutorFacade)closeable;
            boolean bl2 = false;
            SyncOptions.ErrorFormatMode errorFormatMode = this.errorFormatMode;
            if (errorFormatMode == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"errorFormatMode");
            }
            Object object = this.getClasses().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"classes.get()");
            File file = ((RegularFile)object).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"classes.get().asFile");
            Object object2 = this.output.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"output.get()");
            File file2 = ((Directory)object2).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"output.get().asFile");
            Object object3 = this.getEnableDesugaring().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"enableDesugaring.get()");
            boolean bl3 = (Boolean)object3;
            Set set = this.getBootClasspath().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"bootClasspath.files");
            Collection collection = set;
            Set set2 = this.getClasspath().getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"classpath.files");
            it.submit(DexingRunnable.class, (Serializable)new DexParams(this.minSdkVersion, errorFormatMode, file, file2, bl3, collection, set2));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public LibraryDexingTask(@NotNull ObjectFactory objectFactory, @NotNull WorkerExecutor executor) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
        String string2 = this.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        this.workers = Workers.INSTANCE.preferWorkers(string, string2, executor, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objectFactory.directoryProperty()");
        this.output = (Provider)directoryProperty;
        this.minSdkVersion = 1;
    }

    public static final /* synthetic */ Provider access$getOutput$p(LibraryDexingTask $this) {
        return $this.output;
    }

    public static final /* synthetic */ int access$getMinSdkVersion$p(LibraryDexingTask $this) {
        return $this.minSdkVersion;
    }

    public static final /* synthetic */ SyncOptions.ErrorFormatMode access$getErrorFormatMode$p(LibraryDexingTask $this) {
        SyncOptions.ErrorFormatMode errorFormatMode = $this.errorFormatMode;
        if (errorFormatMode == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorFormatMode");
        }
        return errorFormatMode;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0007H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/LibraryDexingTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/LibraryDexingTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "output", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getScope", "()Lcom/android/build/gradle/internal/scope/VariantScope;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "preConfigure", "taskName", "gradle"})
    public static final class CreationAction
    extends VariantTaskCreationAction<LibraryDexingTask> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<LibraryDexingTask> type;
        private Provider<Directory> output;
        @NotNull
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<LibraryDexingTask> getType() {
            return this.type;
        }

        @Override
        public void preConfigure(@NotNull String taskName) {
            Intrinsics.checkParameterIsNotNull((Object)taskName, (String)"taskName");
            this.output = BuildArtifactsHolder.createDirectory$default(this.scope.getArtifacts(), InternalArtifactType.DEX, taskName, null, 4, null);
        }

        @Override
        public void configure(@NotNull LibraryDexingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            this.scope.getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.RUNTIME_LIBRARY_CLASSES, (Property)task.getClasses());
            Provider<Directory> provider = this.output;
            if (provider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            }
            task.output = provider;
            GradleVariantConfiguration gradleVariantConfiguration = this.scope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"scope.variantConfiguration");
            AndroidVersion androidVersion = gradleVariantConfiguration.getMinSdkVersionWithTargetDeviceApi();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion, (String)"scope.variantConfigurati\u2026ersionWithTargetDeviceApi");
            int minSdkVersion = androidVersion.getFeatureLevel();
            task.minSdkVersion = minSdkVersion;
            GlobalScope globalScope = this.getVariantScope().getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            SyncOptions.ErrorFormatMode errorFormatMode = SyncOptions.getErrorFormatMode(globalScope.getProjectOptions());
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)errorFormatMode), (String)"SyncOptions.getErrorForm\u2026obalScope.projectOptions)");
            task.errorFormatMode = errorFormatMode;
            if (this.scope.getJava8LangSupportType() == VariantScope.Java8LangSupport.D8) {
                task.getEnableDesugaring().set((Object)true);
                if (minSdkVersion < 24) {
                    ConfigurableFileCollection configurableFileCollection = task.getBootClasspath();
                    Object[] objectArray = new Object[1];
                    GlobalScope globalScope2 = this.scope.getGlobalScope();
                    Intrinsics.checkExpressionValueIsNotNull((Object)globalScope2, (String)"scope.globalScope");
                    objectArray[0] = globalScope2.getBootClasspath();
                    configurableFileCollection.from(objectArray);
                    task.getClasspath().from(new Object[]{this.scope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES)});
                }
            } else {
                task.getEnableDesugaring().set((Object)false);
            }
        }

        @NotNull
        public final VariantScope getScope() {
            return this.scope;
        }

        public CreationAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            super(scope);
            this.scope = scope;
            String string = this.scope.getTaskName("dex");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.getTaskName(\"dex\")");
            this.name = string;
            this.type = LibraryDexingTask.class;
        }
    }
}

