/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.BuildSession;
import com.android.builder.model.Version;
import com.android.utils.JvmWideVariable;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

@ThreadSafe
public final class BuildSessionImpl
implements BuildSession {
    private static final BuildSession singleton = BuildSessionImpl.createBuildSessionSingleton(Version.ANDROID_GRADLE_PLUGIN_VERSION);
    private BuildState buildState = BuildState.FINISHED;
    private Set<String> executedActions = new HashSet<String>();
    private LinkedHashMap<String, Runnable> buildFinishedActions = new LinkedHashMap();

    @VisibleForTesting
    static BuildSession createBuildSessionSingleton(String pluginVersion) {
        Object buildSessionSingleton = Verify.verifyNotNull((Object)new JvmWideVariable(BuildSessionImpl.class.getName(), BuildSessionImpl.class.getSimpleName(), pluginVersion, TypeToken.of(Object.class), BuildSessionImpl::new).get());
        if (buildSessionSingleton instanceof BuildSession) {
            return (BuildSession)buildSessionSingleton;
        }
        return (BuildSession)Proxy.newProxyInstance(BuildSession.class.getClassLoader(), new Class[]{BuildSession.class}, (InvocationHandler)new DelegateInvocationHandler(buildSessionSingleton));
    }

    public static BuildSession getSingleton() {
        return singleton;
    }

    @Override
    public synchronized void initialize(Gradle gradle) {
        if (this.buildState == BuildState.STARTED) {
            return;
        }
        this.buildState = BuildState.STARTED;
        Gradle rootGradle = gradle;
        while (rootGradle.getParent() != null) {
            rootGradle = rootGradle.getParent();
        }
        rootGradle.addBuildListener(new BuildListener(){

            public void buildStarted(Gradle gradle) {
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult buildResult) {
                BuildSessionImpl.this.buildFinished();
            }
        });
    }

    @Override
    public synchronized void executeOnce(String actionGroup, String actionName, Runnable action) {
        Preconditions.checkState((this.buildState == BuildState.STARTED ? 1 : 0) != 0);
        String actionId = actionGroup + ":" + actionName;
        if (!this.executedActions.contains(actionId)) {
            this.executedActions.add(actionId);
            action.run();
        }
    }

    @Override
    public synchronized void executeOnceWhenBuildFinished(String actionGroup, String actionName, Runnable action) {
        Preconditions.checkState((this.buildState == BuildState.STARTED ? 1 : 0) != 0);
        this.buildFinishedActions.putIfAbsent(actionGroup + ":" + actionName, action);
    }

    private synchronized void buildFinished() {
        Preconditions.checkState((this.buildState == BuildState.STARTED ? 1 : 0) != 0);
        this.buildState = BuildState.FINISHING;
        try {
            this.buildFinishedActions.values().forEach(Runnable::run);
        }
        finally {
            this.executedActions.clear();
            this.buildFinishedActions.clear();
            this.buildState = BuildState.FINISHED;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("buildState", (Object)this.buildState.name()).toString();
    }

    @VisibleForTesting
    static final class DelegateInvocationHandler
    implements InvocationHandler {
        private final Object delegate;

        public DelegateInvocationHandler(Object delegate) {
            this.delegate = delegate;
        }

        public Object getDelegate() {
            return this.delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            return this.delegate.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke(this.delegate, args2);
        }
    }

    private static enum BuildState {
        STARTED,
        FINISHING,
        FINISHED;

    }
}

