/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.cxx.cmake.MakeCmakeMessagePathsAbsoluteKt;
import com.android.build.gradle.internal.cxx.configure.CmakeAndroidGradleBuildExtensionsKt;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class CmakeExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    protected final CxxCmakeModuleModel cmake;

    CmakeExternalNativeJsonGenerator(CxxVariantModel variant, List<CxxAbiModel> abis, GradleBuildVariant.Builder stats) {
        super(variant, abis, stats);
        this.stats.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        this.cmake = Objects.requireNonNull(variant.getModule().getCmake());
        File cmakelists = this.getMakefile();
        if (cmakelists.isDirectory()) {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path %s is a folder. It must be CMakeLists.txt", cmakelists);
        } else if (cmakelists.isFile()) {
            String filename = cmakelists.getName();
            if (!filename.equals("CMakeLists.txt")) {
                LoggingEnvironmentKt.errorln("Gradle project cmake.path specifies %s but it must be CMakeLists.txt", filename);
            }
        } else {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path is %s but that file doesn't exist", cmakelists);
        }
    }

    abstract List<String> getCacheArguments(CxxAbiModel var1);

    public abstract String executeProcessAndGetOutput(CxxAbiModel var1) throws ProcessException, IOException;

    @Override
    public String executeProcess(CxxAbiModel abi) throws ProcessException, IOException {
        String output2 = this.executeProcessAndGetOutput(abi);
        return MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(output2, this.getMakefile().getParentFile());
    }

    @Override
    void processBuildOutput(String buildOutput, CxxAbiModel abi) {
        if (this.variant.getModule().isNativeCompilerSettingsCacheEnabled()) {
            CmakeAndroidGradleBuildExtensionsKt.writeCompilerSettingsToCache(abi);
        }
    }

    @Override
    ProcessInfoBuilder getProcessBuilder(CxxAbiModel abi) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.cmake.getCmakeExe());
        builder.addArgs(this.getProcessBuilderArgs(abi));
        return builder;
    }

    @VisibleForTesting
    List<String> getProcessBuilderArgs(CxxAbiModel abi) {
        ArrayList processBuilderArgs = Lists.newArrayList();
        File cmakeListsFolder = this.getMakefile().getParentFile();
        processBuilderArgs.add(String.format("-H%s", cmakeListsFolder));
        processBuilderArgs.add(String.format("-B%s", abi.getCxxBuildFolder()));
        processBuilderArgs.addAll(this.getCacheArguments(abi));
        processBuilderArgs.addAll(this.getBuildArguments());
        if (this.variant.getModule().isNativeCompilerSettingsCacheEnabled()) {
            return CmakeAndroidGradleBuildExtensionsKt.wrapCmakeListsForCompilerSettingsCaching(abi, processBuilderArgs).getArgs();
        }
        return processBuilderArgs;
    }

    protected List<String> getCommonCacheArguments(CxxAbiModel abi) {
        ArrayList cacheArguments = Lists.newArrayList();
        cacheArguments.add(String.format("-DANDROID_ABI=%s", abi.getAbi().getTag()));
        cacheArguments.add(String.format("-DANDROID_PLATFORM=android-%s", abi.getAbiPlatformVersion()));
        cacheArguments.add(String.format("-DCMAKE_LIBRARY_OUTPUT_DIRECTORY=%s", new File(this.getObjFolder(), abi.getAbi().getTag())));
        cacheArguments.add(String.format("-DCMAKE_BUILD_TYPE=%s", this.isDebuggable() ? "Debug" : "Release"));
        cacheArguments.add(String.format("-DANDROID_NDK=%s", this.getNdkFolder()));
        if (!this.getcFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_C_FLAGS=%s", Joiner.on((String)" ").join(this.getcFlags())));
        }
        if (!this.getCppFlags().isEmpty()) {
            cacheArguments.add(String.format("-DCMAKE_CXX_FLAGS=%s", Joiner.on((String)" ").join(this.getCppFlags())));
        }
        return cacheArguments;
    }

    @Override
    public NativeBuildSystem getNativeBuildSystem() {
        return NativeBuildSystem.CMAKE;
    }

    @Override
    Map<Abi, File> getStlSharedObjectFiles() {
        String stl = null;
        File ndkBasePath = null;
        for (String argument : this.getBuildArguments()) {
            switch (argument = argument.replace(" ", "")) {
                case "-DANDROID_STL=stlport_shared": {
                    stl = "stlport";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "stlport"});
                    break;
                }
                case "-DANDROID_STL=gnustl_shared": {
                    stl = "gnustl";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "gnu-libstdc++", "4.9"});
                    break;
                }
                case "-DANDROID_STL=c++_shared": {
                    stl = "c++";
                    ndkBasePath = FileUtils.join((File)this.getNdkFolder(), (String[])new String[]{"sources", "cxx-stl", "llvm-libc++"});
                }
            }
        }
        HashMap result = Maps.newHashMap();
        if (stl == null) {
            return result;
        }
        for (Abi abi : this.getAbis()) {
            File file = FileUtils.join((File)ndkBasePath, (String[])new String[]{"libs", abi.getTag(), String.format("lib%s_shared.so", stl)});
            Preconditions.checkState((boolean)file.isFile(), (String)"Expected NDK STL shared object file at %s", (Object)file.toString());
            result.put(abi, file);
        }
        return result;
    }
}

